/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.common.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.isv.ISVService;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.hdtc.hrbm.business.common.metadatafield.parse.IMetaDataFieldParser;
import kd.hdtc.hrbm.business.common.metadatafield.parse.MetaDataFieldParserFactory;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class ExtTemplateUtils {
    public static void handleExtTemplateField(boolean supportContainWhite, Set<String> excludeColumns, String templateId, DynamicObjectCollection propEntry, LinkedList<Integer> propIndexList) {
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)templateId);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainEntityType.getName(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List items = entityMetadata.getItems();
        Set entryEntityIdSet = items.stream().filter(item -> item instanceof EntryEntity).map(item -> item.getId()).collect(Collectors.toSet());
        int[] start = new int[]{10};
        items.forEach(item -> {
            if (excludeColumns.contains(item.getKey()) && supportContainWhite) {
                return;
            }
            if (item instanceof MainEntity && supportContainWhite) {
                ExtTemplateUtils.structPrimaryKeyEntry(propEntry, item, mainEntityType);
                return;
            }
            if (item instanceof EntryEntity || entryEntityIdSet.contains(item.getParentId())) {
                return;
            }
            if (item instanceof MainEntity) {
                return;
            }
            if (HRStringUtils.isEmpty((String)((Field)item).getFieldName())) {
                return;
            }
            DynamicObject propDyc = propEntry.addNew();
            propDyc.set("ename", (Object)item.getName());
            String fieldType = MetaDataFieldParserFactory.META_FIELD_MAP.get(item.getClass().getName());
            propDyc.set("fieldtype", (Object)fieldType);
            propDyc.set("epropkey", (Object)item.getKey());
            propDyc.set("must", (Object)((Field)item).isMustInput());
            propDyc.set("ecusstatus", (Object)"0");
            IMetaDataFieldParser metaDataFieldParser = MetaDataFieldParserFactory.getMetaDataFieldParser(fieldType);
            if (metaDataFieldParser != null) {
                String alias = item instanceof OrgField ? metaDataFieldParser.fieldConfigContent((EntityItem<?>)((BasedataField)item)) : metaDataFieldParser.fieldConfigContent((EntityItem<?>)item);
                propDyc.set("fieldconfig", (Object)alias);
                propDyc.set("fieldextattrname", (Object)metaDataFieldParser.parseAlias(alias));
            }
            propDyc.set("eisv", (Object)ISVService.getISVInfo().getId());
            propDyc.set("extend", (Object)true);
            if (excludeColumns.contains(item.getKey())) {
                propDyc.set("proptype", (Object)"20");
                propDyc.set("eindex", (Object)start);
                start[0] = start[0] + 10;
            } else {
                propDyc.set("proptype", (Object)"10");
                propDyc.set("eindex", propIndexList.poll());
            }
        });
    }

    private static void structPrimaryKeyEntry(DynamicObjectCollection propEntry, EntityItem<?> item, MainEntityType mainEntityType) {
        String fieldType;
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        Optional<IDataEntityProperty> primaryKeyProp = properties.stream().filter(prop -> prop instanceof PKFieldProp).findFirst();
        if (!primaryKeyProp.isPresent()) {
            return;
        }
        IDataEntityProperty primaryKey = primaryKeyProp.get();
        if (primaryKey instanceof LongProp) {
            fieldType = MetaDataFieldParserFactory.META_FIELD_MAP.get("kd.bos.metadata.entity.commonfield.BigIntField");
        } else if (primaryKey instanceof VarcharProp) {
            fieldType = MetaDataFieldParserFactory.META_FIELD_MAP.get("kd.bos.metadata.entity.commonfield.TextField");
        } else {
            return;
        }
        DynamicObject propDyc = propEntry.addNew();
        propDyc.set("must", (Object)true);
        propDyc.set("fieldtype", (Object)fieldType);
        propDyc.set("ename", (Object)"ID");
        propDyc.set("epropkey", (Object)primaryKey.getName());
        propDyc.set("eindex", (Object)1);
        propDyc.set("ecusstatus", (Object)"0");
        propDyc.set("proptype", (Object)"10");
        IMetaDataFieldParser metaDataFieldParser = MetaDataFieldParserFactory.getMetaDataFieldParser(fieldType);
        if (metaDataFieldParser != null) {
            String alias = metaDataFieldParser.fieldConfigContent(item);
            propDyc.set("fieldconfig", (Object)alias);
            propDyc.set("fieldextattrname", (Object)metaDataFieldParser.parseAlias(alias));
        }
        propDyc.set("eisv", (Object)ISVService.getISVInfo().getId());
        propDyc.set("extend", (Object)true);
        propDyc.set("primary", (Object)true);
    }
}

