/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hdtc.hrbm.business.domain.task.bo.OperateResultBo;
import kd.hdtc.hrbm.common.constant.HRBMAppConstants;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class MetaFieldTypeUtils {
    public static String getViewType(String isSingleLineTable) {
        if ("false".equals(isSingleLineTable)) {
            return "2";
        }
        return "1";
    }

    private static String getErrorMsg(OperationResult operationResult) {
        if (operationResult == null || operationResult.isSuccess()) {
            return null;
        }
        List list = operationResult.getAllErrorOrValidateInfo();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        list.forEach(info -> sb.append(info.getMessage()).append(";"));
        return sb.toString();
    }

    public static List<Object> save(DynamicObject[] dys, OperateResultBo operateResultBo) {
        String errorMsg;
        List pkList = Collections.EMPTY_LIST;
        if (dys == null || dys.length == 0) {
            return pkList;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", Boolean.TRUE.toString());
        String entityNumber = dys[0].getDataEntityType().getName();
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)entityNumber, (DynamicObject[])dys, (OperateOption)option);
        if (operationResult != null && operationResult.isSuccess()) {
            pkList = operationResult.getSuccessPkIds();
        }
        if (!StringUtils.isEmpty((String)(errorMsg = MetaFieldTypeUtils.getErrorMsg(operationResult)))) {
            operateResultBo.error(errorMsg);
        }
        return pkList;
    }

    public static DynamicObject buildDy(String entityNumber, Object id) {
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityNumber));
        dynamicObject.set("id", id);
        return dynamicObject;
    }

    public static int getSeq(DynamicObjectCollection col) {
        Optional<DynamicObject> maxSeqOp;
        int seq = 1;
        if (col.size() > 0 && (seq = (maxSeqOp = col.stream().max(Comparator.comparingInt(dy -> dy.getInt("seq")))).get().getInt("seq") + 1) > HRBMAppConstants.PROP_MAX_INDEX) {
            seq = HRBMAppConstants.PROP_MAX_INDEX;
        }
        return seq;
    }
}

