/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.common.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.devportal.api.BizAppService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class SplitNumberUtil {
    private static final ThreadLocal<Set<String>> NUMBER_LIST_THREAD_LOCAL = ThreadLocal.withInitial(() -> new HashSet(16));

    public static String getSplitNumber(String number, int largestNumberLeg) {
        Set<String> appNumberList;
        if (StringUtils.isEmpty((String)number) || number.length() <= largestNumberLeg) {
            return number;
        }
        String isv = ISVServiceHelper.getISVInfo().getId();
        String isvSplitCoin = isv + "_";
        StringBuilder sb = new StringBuilder();
        StringBuilder dealStr = new StringBuilder(number);
        if ((number = number.toLowerCase(Locale.ROOT)).startsWith(isvSplitCoin)) {
            sb.append(isvSplitCoin);
            dealStr.delete(0, isvSplitCoin.length());
            largestNumberLeg -= isvSplitCoin.length();
        }
        if (CollectionUtils.isNotEmpty(appNumberList = SplitNumberUtil.getAppNumberList())) {
            for (String appNumber : appNumberList) {
                String appStartStr = appNumber + "_";
                if (dealStr.indexOf(appStartStr) != 0) continue;
                sb.append(appStartStr);
                dealStr.delete(0, appStartStr.length());
                largestNumberLeg -= appStartStr.length();
                break;
            }
        }
        int index = largestNumberLeg / 2;
        int lastIndex = largestNumberLeg - index - 1;
        sb.append(dealStr.substring(0, index));
        sb.append(dealStr.substring(dealStr.length() - lastIndex, dealStr.length()));
        sb.append(dealStr.length() % 10);
        return sb.toString();
    }

    private static Set<String> getAppNumberList() {
        Set<String> dataSet = NUMBER_LIST_THREAD_LOCAL.get();
        if (CollectionUtils.isNotEmpty(dataSet)) {
            return dataSet;
        }
        BizAppService bizAppService = (BizAppService)ServiceFactory.getService(BizAppService.class);
        DynamicObjectCollection appInfoList = bizAppService.getAllBizApps();
        if (CollectionUtils.isNotEmpty((Collection)appInfoList)) {
            dataSet = appInfoList.stream().map(info -> info.getString("number")).collect(Collectors.toSet());
            NUMBER_LIST_THREAD_LOCAL.set(dataSet);
        }
        return dataSet;
    }
}

