/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.baseconfig.impl;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.baseconfig.IBaseConfigDomainService;
import kd.hdtc.hrbm.business.domain.baseconfig.entity.IBaseConfigEntityService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class BaseConfigDomainServiceImpl
implements IBaseConfigDomainService {
    private final IBaseConfigEntityService baseConfigEntityService = ServiceFactory.getService(IBaseConfigEntityService.class);
    private static final String SELECT_PROPERTIES = "number,value";

    @Override
    public String getValueByKey(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return "";
        }
        DynamicObject result = this.baseConfigEntityService.queryOne(SELECT_PROPERTIES, new QFilter("number", "=", (Object)key).toArray());
        if (ObjectUtils.isEmpty((Object)result)) {
            return "";
        }
        return result.getString("value");
    }

    @Override
    public Map<String, String> getValueByKeyList(List<String> keyList) {
        if (CollectionUtils.isEmpty(keyList)) {
            return new HashMap<String, String>();
        }
        Object[] result = this.baseConfigEntityService.query(SELECT_PROPERTIES, new QFilter("number", "in", keyList).toArray());
        if (ObjectUtils.isEmpty((Object[])result)) {
            return new HashMap<String, String>();
        }
        return Arrays.stream(result).collect(Collectors.toMap(dyc -> dyc.getString("number"), dyc -> dyc.getString("value"), (k1, k2) -> k1));
    }

    @Override
    public Set<String> getPropBlackList() {
        return this.getValueSetByKey("PROP_BLACK", ",");
    }

    @Override
    public boolean isShowCopyBtn(String bizObjNumber) {
        if (StringUtils.isEmpty((String)bizObjNumber)) {
            return false;
        }
        Set<String> bizObjNumberSet = this.getValueSetByKey("SHOW_COPY_OP_BIZ_OBJ_LIST", ",");
        return bizObjNumberSet.contains(bizObjNumber);
    }

    @Override
    public Set<String> getBizModelManageShowBtnList(String bizObjNumber) {
        if (StringUtils.isEmpty((String)bizObjNumber)) {
            return new HashSet<String>();
        }
        Object[] baseConfigs = this.baseConfigEntityService.query(SELECT_PROPERTIES, new QFilter("number", "like", (Object)"SHOW_BIZMODEL_OP_%").toArray());
        if (ArrayUtils.isEmpty((Object[])baseConfigs)) {
            return new HashSet<String>();
        }
        HashSet showBtnList = Sets.newHashSetWithExpectedSize((int)baseConfigs.length);
        Stream.of(baseConfigs).forEach(baseConfig -> {
            String valueSetStr = baseConfig.getString("value");
            LinkedHashSet valueSet = Sets.newLinkedHashSetWithExpectedSize((int)16);
            if (StringUtils.isNotEmpty((String)valueSetStr)) {
                String[] values = valueSetStr.split(",");
                valueSet.addAll(Arrays.asList(values));
                if (valueSet.contains(bizObjNumber)) {
                    String number = baseConfig.getString("number");
                    String btn = number.substring("SHOW_BIZMODEL_OP_".length()).toLowerCase().replace("_", "");
                    showBtnList.add(btn);
                }
            }
        });
        return showBtnList;
    }

    @Override
    public Set<String> getValueSetByKey(String valueKey, String regex) {
        if (StringUtils.isEmpty((String)valueKey) || StringUtils.isEmpty((String)regex)) {
            return new HashSet<String>();
        }
        String valueSetStr = this.getValueByKey(valueKey);
        LinkedHashSet valueSet = Sets.newLinkedHashSetWithExpectedSize((int)16);
        if (StringUtils.isNotEmpty((String)valueSetStr)) {
            String[] values = valueSetStr.split(regex);
            valueSet.addAll(Arrays.asList(values));
        }
        return valueSet;
    }
}

