/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.baseconfig.impl;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.baseconfig.INumberMaxIndexDomainService;
import kd.hdtc.hrbm.business.domain.baseconfig.entity.INumberMaxIndexEntityService;
import kd.hr.hbp.common.util.HRObjectUtils;

public class NumberMaxIndexDomainServiceImpl
implements INumberMaxIndexDomainService {
    public static INumberMaxIndexEntityService numberMaxIndexEntityService = ServiceFactory.getService(INumberMaxIndexEntityService.class);
    public static String selectProps = String.join((CharSequence)",", "isv", "appnumber", "maxindex", "modifier", "modifytime", "creator", "createtime");

    @Override
    public DynamicObject queryNumberMaxIndexDy(String isv, String appNumber) {
        QFilter isvFilter = new QFilter("isv", "=", (Object)isv);
        QFilter appFilter = new QFilter("appnumber", "=", (Object)appNumber);
        return numberMaxIndexEntityService.queryOne(selectProps, new QFilter[]{isvFilter, appFilter});
    }

    @Override
    public String getMaxIndex(String isv, String appNumber) {
        DynamicObject numberMaxIndexDy = this.queryNumberMaxIndexDy(isv, appNumber);
        if (HRObjectUtils.isEmpty((Object)numberMaxIndexDy)) {
            return "0000";
        }
        return numberMaxIndexDy.getString("maxindex");
    }

    @Override
    public void saveAndUpdateMaxIndex(String isv, String appNumber, String maxIndex) {
        DynamicObject numberMaxIndexDy = this.queryNumberMaxIndexDy(isv, appNumber);
        if (HRObjectUtils.isEmpty((Object)numberMaxIndexDy)) {
            numberMaxIndexDy = numberMaxIndexEntityService.generateEmptyDynamicObject();
            numberMaxIndexDy.set("isv", (Object)isv);
            numberMaxIndexDy.set("appnumber", (Object)appNumber);
            numberMaxIndexDy.set("creator", (Object)RequestContext.get().getCurrUserId());
            numberMaxIndexDy.set("createtime", (Object)new Date());
            numberMaxIndexDy.set("maxindex", (Object)maxIndex);
        } else {
            int newMaxIndex = Math.max(Integer.parseInt(maxIndex), Integer.parseInt(numberMaxIndexDy.getString("maxindex")));
            numberMaxIndexDy.set("maxindex", (Object)String.format("%04d", newMaxIndex));
        }
        numberMaxIndexDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
        numberMaxIndexDy.set("modifytime", (Object)new Date());
        numberMaxIndexEntityService.save(numberMaxIndexDy);
    }
}

