/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.caserule;

import java.util.Optional;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.caserule.handle.ICaseRuleHandle;
import kd.hdtc.hrbm.business.domain.extcase.entity.IExtCaseEntityService;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;

public class CaseRuleHandleFactory {
    private static final IExtCaseEntityService extCaseEntityService = ServiceFactory.getService(IExtCaseEntityService.class);

    public static ICaseRuleHandle getCaseRuleHandleByCaseId(Long caseId) {
        DynamicObject extCase = extCaseEntityService.query("serviceclass", caseId);
        String serviceClass = Optional.ofNullable(extCase).map(it -> it.getString("serviceclass")).orElseThrow(() -> new HRDBSBizException("can not find service class"));
        return CaseRuleHandleFactory.getCaseRuleHandle(serviceClass);
    }

    public static ICaseRuleHandle getCaseRuleHandle(DynamicObject extCaseManageDynamicObject) {
        String serviceClass = Optional.ofNullable(extCaseManageDynamicObject).map(it -> it.getDynamicObject("extcase")).map(it -> it.getString("serviceclass")).orElseThrow(() -> new HRDBSBizException("can not find service class"));
        return CaseRuleHandleFactory.getCaseRuleHandle(serviceClass);
    }

    public static ICaseRuleHandle getCaseRuleHandle(String serviceClass) {
        return (ICaseRuleHandle)TypesContainer.createInstance((String)serviceClass);
    }
}

