/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.caserule.handle;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.FormMetadata;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.common.metadatafield.FieldTypeEnum;
import kd.hdtc.hrbm.business.common.metadatafield.handle.IMetaDataFieldHandle;
import kd.hdtc.hrbm.business.common.metadatafield.handle.MetaDataFieldHandleFactory;
import kd.hdtc.hrbm.business.domain.caserule.handle.ICaseRuleHandle;
import kd.hdtc.hrbm.business.domain.extcase.entity.IExtCaseManageEntityService;
import kd.hdtc.hrbm.business.domain.model.IPropDomainService;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IBizUnitEntityService;
import kd.hdtc.hrdbs.common.enums.MetadataGenTypeEnum;
import kd.hdtc.hrdbs.common.exception.HDTCBizException;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public abstract class AbstractCaseRuleHandle
implements ICaseRuleHandle {
    private static final Log LOG = LogFactory.getLog(AbstractCaseRuleHandle.class);
    private final IExtCaseManageEntityService iExtCaseManageEntityService = ServiceFactory.getService(IExtCaseManageEntityService.class);
    public final IBizUnitEntityService bizUnitEntityService = (IBizUnitEntityService)kd.hdtc.hrdbs.business.common.ServiceFactory.getService(IBizUnitEntityService.class);
    private final IPropDomainService propDomainService = ServiceFactory.getService(IPropDomainService.class);

    @Override
    public void callback(long id, Map<String, Object> runContextMap) {
        DynamicObject dynamicObject = this.iExtCaseManageEntityService.queryExtCaseManageById(id);
        this.endOperate(dynamicObject, runContextMap);
        dynamicObject.set("cusstatus", (Object)"1");
        this.iExtCaseManageEntityService.save(dynamicObject);
    }

    protected MetadataGenParam buildMetadataGenParam(DynamicObject caseData) {
        MetadataGenParam metadataGenParam = new MetadataGenParam();
        BaseParam baseParam = new BaseParam();
        metadataGenParam.setBaseParam(baseParam);
        metadataGenParam.setFieldParamList(new ArrayList());
        this.initBaseParam(baseParam, caseData);
        this.handleBaseParam(baseParam, caseData);
        List<DynamicObject> propInfoList = this.getPropInfoList(caseData.getLong("id"));
        this.fillMetadataGenFieldParam(metadataGenParam, propInfoList);
        this.fillMetadataGenParam(metadataGenParam);
        return metadataGenParam;
    }

    protected void fillMetadataGenParam(MetadataGenParam metadataGenParam) {
    }

    protected final Map<String, Object> initResultMap(DynamicObject caseDataDynamicObject) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
        paramMap.put("baseDatatype", caseDataDynamicObject.getDataEntityType().getName());
        paramMap.put("bizModelId", caseDataDynamicObject.getLong("id"));
        return paramMap;
    }

    protected List<DynamicObject> getPropInfoList(Long logicEntityId) {
        return this.propDomainService.getPropByEntityIdAndExtends(logicEntityId);
    }

    protected void initBaseParam(BaseParam baseParam, DynamicObject caseData) {
        baseParam.setMetadataNumber(caseData.getString("number"));
        baseParam.setMetadataName(caseData.getString("name"));
        baseParam.setType(MetadataGenTypeEnum.NORMAL_METADATA);
    }

    protected void handleBaseParam(BaseParam baseParam, DynamicObject logicEntityDy) {
        String parentId;
        FormMetadata formMetadata;
        String metaDataNumber = this.getExtMetadataNumber(logicEntityDy);
        DynamicObject templateMapping = logicEntityDy.getDynamicObject("template");
        String bizUnit = null;
        if (HRStringUtils.isNotEmpty((String)metaDataNumber) && MetadataUtils.isExist((String)metaDataNumber)) {
            formMetadata = MetadataUtils.getFormMetadataByNumber((String)metaDataNumber);
            parentId = formMetadata.getEntityId();
            Optional metadataBizUnit = this.bizUnitEntityService.getMetadataBizUnit(formMetadata.getId(), formMetadata.getBizappId());
            bizUnit = (String)metadataBizUnit.get();
        } else {
            if (HRObjectUtils.isEmpty((Object)templateMapping)) {
                throw new HDTCBizException(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u7ee7\u627f\u6a21\u7248\u3002\u8bf7\u67e5\u770b\u5f53\u524d\u903b\u8f91\u5b9e\u4f53\u662f\u5426\u5b58\u5728\u6a21\u7248\u6620\u5c04\u3002", (String)"LogicEntityCaseRuleHandle_0", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
            }
            DynamicObject mainEntity = logicEntityDy.getDynamicObject("pid");
            if (HRStringUtils.isNotEmpty((String)mainEntity.getString("bizunit"))) {
                Map bizUnitMap = (Map)JsonUtils.castType((String)mainEntity.getString("bizunit"), Map.class);
                bizUnit = (String)bizUnitMap.get("id");
            }
            formMetadata = MetadataUtils.getFormMetadataByNumber((String)templateMapping.getString("template.id"));
            parentId = formMetadata.getEntityId();
        }
        if (HRStringUtils.isEmpty((String)bizUnit)) {
            throw new HDTCBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u529f\u80fd\u5206\u7ec4\u3002\u8bf7\u67e5\u770b\u5f53\u524d\u4e3b\u903b\u8f91\u5b9e\u4f53\u662f\u5426\u5b58\u5728\u529f\u80fd\u5206\u7ec4\u3002", (String)"LogicEntityCaseRuleHandle_1", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        }
        baseParam.setModelType(formMetadata.getModelType());
        baseParam.setAppId(formMetadata.getBizappNumber());
        baseParam.setBizUnitId(bizUnit);
        baseParam.setParentId(parentId);
    }

    protected String getExtMetadataNumber(DynamicObject logicEntityDynamicObject) {
        String extMetaNumber = logicEntityDynamicObject.getString("extmetanum");
        if (StringUtils.isBlank((CharSequence)extMetaNumber)) {
            extMetaNumber = logicEntityDynamicObject.getString("number");
        }
        return extMetaNumber;
    }

    protected void updateTechPropInfo(List<DynamicObject> propInfoList, MainEntityType mainEntityType) {
        Map allFields = mainEntityType.getAllFields();
        for (DynamicObject dynamicObject : propInfoList) {
            String number = dynamicObject.getString("propkey");
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)allFields.get(number);
            if (iDataEntityProperty != null) {
                dynamicObject.set("tablefield", (Object)iDataEntityProperty.getAlias());
            }
            if ("id".equals(number)) {
                dynamicObject.set("coreprop", (Object)Boolean.TRUE);
                dynamicObject.set("tablefield", (Object)mainEntityType.getPrimaryKey().getAlias());
            }
            dynamicObject.set("table", (Object)mainEntityType.getAlias());
            dynamicObject.set("cusstatus", (Object)"1");
            String fieldType = dynamicObject.getString("fieldtype");
            if (fieldType.equals(FieldTypeEnum.MULILANGTEXTFIELD.getType())) {
                dynamicObject.set("multilang", (Object)Boolean.TRUE);
                continue;
            }
            dynamicObject.set("multilang", (Object)Boolean.FALSE);
        }
    }

    public void fillMetadataGenFieldParam(MetadataGenParam metadataGenParam, List<DynamicObject> propDyList) {
        for (DynamicObject field : propDyList) {
            IMetaDataFieldHandle metaDataFieldHandle = MetaDataFieldHandleFactory.getMetaDataFieldHandle(field.getString("fieldtype"));
            FieldParam fieldParam = metaDataFieldHandle.initBaseParam(field, this.getContainNumber());
            if (fieldParam != null) {
                this.fillFieldParam(fieldParam, field);
                metadataGenParam.getFieldParamList().add(fieldParam);
            }
            metaDataFieldHandle.initBasePanel(field, metadataGenParam);
        }
    }

    protected void fillFieldParam(FieldParam fieldParam, DynamicObject field) {
    }

    protected String getContainNumber() {
        return "fs_baseinfo";
    }
}

