/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.caserule.handle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.FormMetadata;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.common.metadatafield.handle.IMetaDataFieldHandle;
import kd.hdtc.hrbm.business.common.metadatafield.handle.MetaDataFieldHandleFactory;
import kd.hdtc.hrbm.business.domain.caserule.handle.AbstractCaseRuleHandle;
import kd.hdtc.hrbm.business.domain.caserule.handle.LogicEntityCaseRuleHandle;
import kd.hdtc.hrbm.business.domain.model.IEntityCardDomainService;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrbm.business.domain.model.IPropDomainService;
import kd.hdtc.hrbm.business.domain.model.entity.ILogicEntityRelEntityService;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IBizUnitEntityService;
import kd.hdtc.hrdbs.common.enums.MetadataGenTypeEnum;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.pojo.metadata.ContainerParam;
import kd.hdtc.hrdbs.common.pojo.metadata.EntryParam;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class AddEntryRuleHandle
extends AbstractCaseRuleHandle {
    private static final Map<String, String> CHG_TYPE_COMBO = ImmutableMap.builder().put((Object)ResManager.loadKDString((String)"\u65b0\u589e", (String)"AddEntryRuleHandle_11", (String)"hdtc-hrbm-business", (Object[])new Object[0]), (Object)"0").put((Object)ResManager.loadKDString((String)"\u53d8\u66f4", (String)"AddEntryRuleHandle_12", (String)"hdtc-hrbm-business", (Object[])new Object[0]), (Object)"1").put((Object)ResManager.loadKDString((String)"\u5931\u6548", (String)"AddEntryRuleHandle_12", (String)"hdtc-hrbm-business", (Object[])new Object[0]), (Object)"2").put((Object)ResManager.loadKDString((String)"\u5220\u9664", (String)"AddEntryRuleHandle_12", (String)"hdtc-hrbm-business", (Object[])new Object[0]), (Object)"3").put((Object)ResManager.loadKDString((String)"\u4e0d\u53d8", (String)"AddEntryRuleHandle_12", (String)"hdtc-hrbm-business", (Object[])new Object[0]), (Object)"4").build();
    private static final List<String> FIELD_NUMBER_LIST = ImmutableList.of((Object)"chgtype", (Object)"pid", (Object)"tid", (Object)"eid", (Object)"did");
    private static final Map<String, String> FIELD_NAME = ImmutableMap.builder().put((Object)"chgtype", (Object)ResManager.loadKDString((String)"\u53d8\u52a8%1$s\u53d8\u52a8\u7c7b\u578b", (String)"AddEntryRuleHandle_8", (String)"hdtc-hrbm-business", (Object[])new Object[0])).put((Object)"pid", (Object)ResManager.loadKDString((String)"\u81ea\u7136\u4eba%1$sid", (String)"AddEntryRuleHandle_4", (String)"hdtc-hrbm-business", (Object[])new Object[0])).put((Object)"tid", (Object)ResManager.loadKDString((String)"\u53d8\u52a8%1$sid", (String)"AddEntryRuleHandle_5", (String)"hdtc-hrbm-business", (Object[])new Object[0])).put((Object)"eid", (Object)ResManager.loadKDString((String)"\u4f01\u4e1a\u4eba%1$sid", (String)"AddEntryRuleHandle_6", (String)"hdtc-hrbm-business", (Object[])new Object[0])).put((Object)"did", (Object)ResManager.loadKDString((String)"\u7ec4\u7ec7\u4eba%1$sid", (String)"AddEntryRuleHandle_7", (String)"hdtc-hrbm-business", (Object[])new Object[0])).build();
    private final ILogicEntityDomainService logicEntityDomainService = ServiceFactory.getService(ILogicEntityDomainService.class);
    private final ILogicEntityRelEntityService logicEntityRelEntityService = ServiceFactory.getService(ILogicEntityRelEntityService.class);
    private final IEntityCardDomainService entityCardDomainService = ServiceFactory.getService(IEntityCardDomainService.class);
    private final IBizUnitEntityService iBizUnitEntityService = (IBizUnitEntityService)kd.hdtc.hrdbs.business.common.ServiceFactory.getService(IBizUnitEntityService.class);
    private static final Log LOG = LogFactory.getLog(LogicEntityCaseRuleHandle.class);
    private String extMetaNumber;
    private String extMetaName;
    private String relLogicEntityNumber;
    private String logicEntityNumberSuffix;
    private final IPropDomainService propDomainService = ServiceFactory.getService(IPropDomainService.class);

    @Override
    public String generateRunParamStr(DynamicObject caseManageData) {
        DynamicObject logicEntityDynamicObject = this.logicEntityDomainService.getLogicEntityInfoById(this.getCaseDataId(caseManageData));
        DynamicObject dynamicObject = logicEntityDynamicObject.getDynamicObject("pid");
        if (dynamicObject == null) {
            return "";
        }
        this.init(dynamicObject);
        String entryKey = "entry";
        String subLogicEntityNumber = Optional.ofNullable(logicEntityDynamicObject.getDynamicObject("sublogicentity")).map(it -> it.getString("number")).orElseThrow(() -> new HRDBSBizException("can not match sub logic entity"));
        String logicEntityNumber = logicEntityDynamicObject.getString("number");
        this.relLogicEntityNumber = subLogicEntityNumber.substring(subLogicEntityNumber.lastIndexOf("_") + 1);
        this.logicEntityNumberSuffix = logicEntityNumber.substring(logicEntityNumber.lastIndexOf("_") + 1);
        if (this.logicEntityNumberSuffix.length() > 4) {
            this.logicEntityNumberSuffix = this.logicEntityNumberSuffix.substring(this.logicEntityNumberSuffix.length() - 4);
        }
        String location = this.getLocation(logicEntityDynamicObject.getString("location"));
        entryKey = entryKey + "_" + location + "_" + this.relLogicEntityNumber;
        MetadataGenParam metadataGenParam = new MetadataGenParam();
        BaseParam baseParam = new BaseParam();
        metadataGenParam.setBaseParam(baseParam);
        baseParam.setMetadataName(this.extMetaName);
        baseParam.setMetadataNumber(this.extMetaNumber);
        baseParam.setParentId(this.getParentId(this.extMetaNumber));
        FormMetadata formMetadata = MetadataUtils.getFormMetadataByNumber((String)this.extMetaNumber);
        baseParam.setModelType(formMetadata.getModelType());
        baseParam.setAppId(formMetadata.getBizappNumber());
        baseParam.setBizUnitId(this.iBizUnitEntityService.getMetadataBizUnit(formMetadata.getId(), formMetadata.getBizappId()).orElse(""));
        baseParam.setType(MetadataGenTypeEnum.EXTEND_ENTRY_METADATA);
        String suffix = this.relLogicEntityNumber;
        this.buildContainerParam(logicEntityDynamicObject, suffix, metadataGenParam);
        EntryParam entryParam = new EntryParam();
        entryParam.setEntryName(logicEntityDynamicObject.getString("changetitle"));
        entryParam.setContainerNumber("advchdpl_" + location + "_" + suffix);
        entryParam.setType("EntryEntity");
        entryParam.setTableName("tk_" + entryKey);
        entryParam.setEntryKey(entryKey);
        metadataGenParam.setEntryParamList((List)ImmutableList.of((Object)entryParam));
        entryParam.setFieldParamList(this.buildFieldParam(entryKey, entryParam, location, logicEntityDynamicObject));
        Map<String, Object> result = this.initResultMap(logicEntityDynamicObject);
        result.put("data", metadataGenParam);
        result.put("mappingRule", "generate_isv_entry");
        result.put("entryKey", entryKey);
        return JsonUtils.toStr(result);
    }

    private String getLocation(String location) {
        if ("1".equals(location)) {
            location = "b";
        } else if ("2".equals(location)) {
            location = "a";
        }
        return location;
    }

    private String getLocationName(String location) {
        String locationName = "";
        if ("1".equals(location)) {
            locationName = ResManager.loadKDString((String)"\u524d", (String)"AddEntryRuleHandle_9", (String)"hdtc-hrbm-business", (Object[])new Object[0]);
        } else if ("2".equals(location)) {
            locationName = ResManager.loadKDString((String)"\u540e", (String)"AddEntryRuleHandle_10", (String)"hdtc-hrbm-business", (Object[])new Object[0]);
        }
        return locationName;
    }

    private void init(DynamicObject logicEntityDynamicObject) {
        this.extMetaNumber = this.getExtMetadataNumber(logicEntityDynamicObject);
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)this.extMetaNumber);
        this.extMetaName = mainEntityType.getDisplayName().getLocaleValue();
    }

    private void buildContainerParam(DynamicObject logicEntityDynamicObject, String suffix, MetadataGenParam metadataGenParam) {
        String location = this.getLocation(logicEntityDynamicObject.getString("location"));
        ContainerParam containerParam = new ContainerParam();
        containerParam.setNumber("adventry_" + suffix);
        containerParam.setName(logicEntityDynamicObject.getString("maintitle"));
        containerParam.setCollapsible(Boolean.TRUE.booleanValue());
        containerParam.setParentNumber("n_extinfo");
        containerParam.setType("AdvConAp");
        ContainerParam containerParam1 = new ContainerParam();
        containerParam1.setNumber("advchdpl_" + suffix);
        containerParam1.setParentNumber(containerParam.getNumber());
        containerParam1.setType("AdvConChildPanelAp");
        containerParam1.setName(ResManager.loadKDString((String)"\u9ad8\u7ea7\u9762\u677f\u5b50\u5bb9\u5668", (String)"AddEntryRuleHandle_1", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        ContainerParam containerParam2 = new ContainerParam();
        if ("b".equals(location)) {
            containerParam2.setIndex(1);
        } else if ("a".equals(location)) {
            containerParam2.setIndex(2);
        }
        containerParam2.setNumber("adventry_" + location + "_" + suffix);
        containerParam2.setName(logicEntityDynamicObject.getString("changetitle"));
        containerParam2.setCollapsible(Boolean.TRUE.booleanValue());
        containerParam2.setParentNumber(containerParam1.getNumber());
        containerParam2.setType("AdvConAp");
        ContainerParam containerParam3 = new ContainerParam();
        containerParam3.setNumber("advchdpl_" + location + "_" + suffix);
        containerParam3.setParentNumber(containerParam2.getNumber());
        containerParam3.setType("AdvConChildPanelAp");
        containerParam3.setName(ResManager.loadKDString((String)"\u9ad8\u7ea7\u9762\u677f\u5b50\u5bb9\u5668", (String)"AddEntryRuleHandle_1", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        ContainerParam containerParam4 = new ContainerParam();
        containerParam4.setNumber("advctlbarap_" + location + "_" + suffix);
        containerParam4.setParentNumber(containerParam2.getNumber());
        containerParam4.setType("AdvConToolbarAp");
        containerParam4.setLocation(location);
        containerParam4.setSuffix(this.relLogicEntityNumber);
        containerParam4.setName(ResManager.loadKDString((String)"\u9ad8\u7ea7\u9762\u677f\u5de5\u5177\u680f", (String)"AddEntryRuleHandle_2", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        metadataGenParam.setContainerParamList((List)ImmutableList.of((Object)containerParam, (Object)containerParam1, (Object)containerParam2, (Object)containerParam3, (Object)containerParam4));
    }

    private List<FieldParam> buildFieldParam(String entryKey, EntryParam entryParam, String location, DynamicObject dynamicObject) {
        String prefix = ISVService.getISVInfo().getId();
        String locationName = this.getLocationName(dynamicObject.getString("location"));
        ArrayList<FieldParam> fieldParamList = new ArrayList<FieldParam>(10);
        FIELD_NUMBER_LIST.stream().forEach(fieldNumber -> {
            FieldParam fieldParam = new FieldParam();
            fieldParam.setName(String.format(FIELD_NAME.get(fieldNumber), locationName));
            fieldParam.setNumber(prefix + "_" + location + "_" + this.logicEntityNumberSuffix + "_" + fieldNumber);
            this.initFieldParam(fieldParam, entryKey, entryParam, Boolean.TRUE);
            if ("chgtype".equals(fieldNumber)) {
                fieldParam.setFieldRuleMap(this.chgTypeRuleMap());
                fieldParam.setType("ComboFieldEntry");
            } else {
                fieldParam.setType("BigintFieldEntry");
            }
            fieldParamList.add(fieldParam);
        });
        List<DynamicObject> propInfoList = this.propDomainService.getAllPropInfoByLogicEntityId(dynamicObject.getLong("id"));
        for (DynamicObject field : propInfoList) {
            String fieldType;
            IMetaDataFieldHandle metaDataFieldHandle;
            FieldParam fieldParam;
            if ("id".equals(field.getString("propkey")) || (fieldParam = (metaDataFieldHandle = MetaDataFieldHandleFactory.getMetaDataFieldHandle(fieldType = field.getString("fieldtype"))).initBaseParam(field)) == null) continue;
            fieldParam.setName(field.getString("name"));
            fieldParam.setNumber(field.getString("propkey"));
            fieldParam.setType(fieldType + "entry");
            this.initFieldParam(fieldParam, entryKey, entryParam, Boolean.FALSE);
            fieldParamList.add(fieldParam);
        }
        return fieldParamList;
    }

    private void initFieldParam(FieldParam fieldParam, String entryKey, EntryParam entryParam, boolean invisible) {
        fieldParam.setContainerNumber(entryKey);
        fieldParam.setEntryParam(entryParam);
        fieldParam.setInvisible(invisible);
    }

    private String getParentId(String number) {
        return MetadataUtils.getFormMetadataByNumber((String)number).getId();
    }

    @Override
    public void endOperate(DynamicObject extCaseManageDynamicObject, Map<String, Object> runContextMap) {
        DynamicObject caseData = this.logicEntityDomainService.getLogicEntityInfoById(this.getCaseDataId(extCaseManageDynamicObject));
        if (HRObjectUtils.isEmpty((Object)caseData)) {
            LOG.info("LogicEntityCaseRuleHandle.endOperate is end, because caseData is empty");
            return;
        }
        if (CollectionUtils.isEmpty(runContextMap)) {
            LOG.info("LogicEntityCaseRuleHandle.endOperate is end, because runContextMap is empty");
            return;
        }
        String entryKey = "entry";
        String subLogicEntityNumber = Optional.ofNullable(caseData.getDynamicObject("sublogicentity")).map(it -> it.getString("number")).orElseThrow(() -> new HRDBSBizException("can not match sub logic entity"));
        this.relLogicEntityNumber = subLogicEntityNumber.substring(subLogicEntityNumber.lastIndexOf("_") + 1);
        String location = this.getLocation(caseData.getString("location"));
        entryKey = entryKey + "_" + location + "_" + this.relLogicEntityNumber;
        caseData.set("cusstatus", (Object)"1");
        this.logicEntityDomainService.saveLogicEntity(caseData);
        String entityNumber = caseData.getDynamicObject("bizobj").getString("number");
        if (HRStringUtils.isEmpty((String)entityNumber)) {
            LOG.info("LogicEntityCaseRuleHandle.saveLogicEntityRel is end, because entityNumber is null");
            return;
        }
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        if (mainEntityType == null) {
            LOG.info("LogicEntityCaseRuleHandle.saveLogicEntityRel is end, because mainEntityType is null");
            return;
        }
        this.saveLogicEntityRel(caseData, mainEntityType, entryKey);
        List<DynamicObject> propInfoList = this.propDomainService.getPropInfobyLogicEntityId(caseData.getLong("id"));
        this.updateTechPropInfo(propInfoList, mainEntityType);
        for (DynamicObject propDynObj : propInfoList) {
            propDynObj.set("table", (Object)("tk_" + entryKey));
        }
        this.propDomainService.batchSaveProp(propInfoList);
        this.saveEntityRelCard(caseData.getLong("id"), caseData.getLong("pid.id"));
    }

    protected void saveEntityRelCard(long logicEntityId, long relLogicEntityId) {
        this.entityCardDomainService.saveEntityRelCard(logicEntityId, relLogicEntityId);
    }

    private void saveLogicEntityRel(DynamicObject caseData, MainEntityType mainEntityType, String entryKey) {
        DynamicObject logicEntityRel = this.logicEntityRelEntityService.generateEmptyDynamicObject();
        logicEntityRel.set("logicentity", (Object)caseData);
        logicEntityRel.set("metadatanum", (Object)(this.getExtMetadataNumber(caseData.getDynamicObject("pid")) + "." + entryKey));
        logicEntityRel.set("metadataname", (Object)mainEntityType.getDisplayName());
        logicEntityRel.set("table", (Object)("tk_" + entryKey));
        logicEntityRel.set("creator", (Object)RequestContext.get().getCurrUserId());
        logicEntityRel.set("createtime", (Object)new Date());
        this.logicEntityRelEntityService.save(logicEntityRel);
    }

    private Map<String, Object> chgTypeRuleMap() {
        HashMap fieldRuleMap = Maps.newHashMapWithExpectedSize((int)8);
        ArrayList itemsMap = Lists.newArrayListWithExpectedSize((int)CHG_TYPE_COMBO.size());
        CHG_TYPE_COMBO.forEach((caption, value) -> {
            HashMap map = Maps.newHashMapWithExpectedSize((int)4);
            map.put("_Type", "ComboItem");
            map.put("Value", value);
            map.put("Caption", caption);
            itemsMap.add(map);
        });
        fieldRuleMap.put("Items", itemsMap);
        return fieldRuleMap;
    }
}

