/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.caserule.handle;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.common.metadatafield.FieldTypeEnum;
import kd.hdtc.hrbm.business.domain.caserule.handle.AbstractCaseRuleHandle;
import kd.hdtc.hrbm.business.domain.model.IPropDomainService;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;

public class CadreFileCaseRuleHandle
extends AbstractCaseRuleHandle {
    private static final Log LOG = LogFactory.getLog(CadreFileCaseRuleHandle.class);
    protected final IPropDomainService propDomainService = ServiceFactory.getService(IPropDomainService.class);
    private static final Set<String> SINGLE_LINE_TEMPLATE_SET = ImmutableSet.of((Object)"21ZNULG+9Q7D", (Object)"21YR3KJ5/NUQ", (Object)"3WTHZC5GT6Z5", (Object)"3WTITBQR9I40");

    @Override
    public String generateRunParamStr(DynamicObject caseManageData) {
        DynamicObject caseDataDynamicObject = caseManageData.getDynamicObject("bizmodel");
        String modelEntityNumber = Optional.ofNullable(caseManageData).map(it -> it.getDynamicObject("bizmodel")).map(it -> it.getString("number")).orElse("");
        Map<String, Object> paramMap = this.initResultMap(caseDataDynamicObject);
        paramMap.put("modelEntityNumber", modelEntityNumber);
        paramMap.put("modelNumber", CadreFileCaseRuleHandle.getModelNumber(modelEntityNumber));
        paramMap.put("appId", Optional.ofNullable(MetadataUtils.getMainEntityType((String)modelEntityNumber)).map(it -> it.getAppId()).orElse(""));
        paramMap.put("isSingleLineTable", this.isSingleLineTable(modelEntityNumber));
        paramMap.put("sourceData", this.buildSourceMetadataGen(caseDataDynamicObject));
        Map<String, Object> otherParamMap = this.getOtherParamMap(caseDataDynamicObject);
        if (!CollectionUtils.isEmpty(otherParamMap)) {
            paramMap.putAll(otherParamMap);
        }
        paramMap.putAll((Map)JsonUtils.castType((String)caseManageData.getString("caserule"), Map.class));
        return JsonUtils.toStr(paramMap);
    }

    private MetadataGenParam buildSourceMetadataGen(DynamicObject bizModelDy) {
        MetadataGenParam metadataGenParam = new MetadataGenParam();
        List<DynamicObject> propDyList = this.getPropInfoList(bizModelDy.getLong("id"));
        this.fillMetadataGenFieldParam(metadataGenParam, propDyList);
        return metadataGenParam;
    }

    @Override
    protected List<DynamicObject> getPropInfoList(Long logicEntityId) {
        QFilter qFilter = new QFilter("proptype", "=", (Object)"10");
        qFilter.and("cusstatus", "=", (Object)"1");
        qFilter.and("propkey", "not in", Arrays.asList("id", "person", "issingle", "description"));
        return this.propDomainService.getPropsByEntityIdAndQFilter(logicEntityId, qFilter, "index");
    }

    @Override
    protected void fillFieldParam(FieldParam fieldParam, DynamicObject field) {
        if (FieldTypeEnum.MULBASEDATAFIELD.getType().equals(fieldParam.getType()) || "kingdee".equals(field.getString("isv"))) {
            fieldParam.setTableField(field.getString("tablefield"));
        }
    }

    protected Map<String, Object> getOtherParamMap(DynamicObject bizModelDy) {
        return null;
    }

    private boolean isSingleLineTable(String modelEntityNumber) {
        return Optional.ofNullable(MetadataUtils.getMainEntityType((String)modelEntityNumber)).map(it -> it.getInheritPath()).map(it -> SINGLE_LINE_TEMPLATE_SET.stream().anyMatch(tpl -> it.contains((CharSequence)tpl))).orElse(false);
    }

    private static String getModelNumber(String modelEntityNumber) {
        return Optional.ofNullable(modelEntityNumber).map(it -> it.substring(it.lastIndexOf("_") + 1)).orElse("");
    }

    @Override
    public void endOperate(DynamicObject extCaseManageDynamicObject, Map<String, Object> runContextMap) {
    }
}

