/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.caserule.handle;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.caserule.handle.AbstractCaseRuleHandle;
import kd.hdtc.hrbm.business.domain.model.IEntityCardDomainService;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrbm.business.domain.model.IPropDomainService;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IBizUnitEntityService;
import kd.hdtc.hrdbs.common.enums.MetadataGenTypeEnum;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hr.hbp.common.util.HRObjectUtils;

public class ExtCaseRuleHandle
extends AbstractCaseRuleHandle {
    private static final Log LOG = LogFactory.getLog(ExtCaseRuleHandle.class);
    private final ILogicEntityDomainService logicEntityDomainService = ServiceFactory.getService(ILogicEntityDomainService.class);
    private final IPropDomainService propDomainService = ServiceFactory.getService(IPropDomainService.class);
    private final IBizUnitEntityService bizUnitEntityService = (IBizUnitEntityService)kd.hdtc.hrdbs.business.common.ServiceFactory.getService(IBizUnitEntityService.class);
    private final IEntityCardDomainService entityCardDomainService = ServiceFactory.getService(IEntityCardDomainService.class);
    private String extMetaNumber;
    private String extMetaName;
    private String appId;

    private void init(DynamicObject logicEntityDynamicObject) {
        this.extMetaNumber = this.getExtMetadataNumber(logicEntityDynamicObject);
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)this.extMetaNumber);
        this.extMetaName = mainEntityType.getDisplayName().getLocaleValue();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.extMetaNumber);
        this.appId = mainType.getAppId();
    }

    private void specialHandle(DynamicObject logicEntityDynamicObject, MetadataGenParam metadataGenParam) {
        if ("homs_positionbill".equals(logicEntityDynamicObject.getString("number"))) {
            metadataGenParam.getFieldParamList().forEach(fieldParam -> fieldParam.getFieldRuleMap().put("Lock", ""));
        }
    }

    @Override
    public String generateRunParamStr(DynamicObject caseManageData) {
        DynamicObject logicEntityDynamicObject = this.logicEntityDomainService.getLogicEntityInfoById(this.getCaseDataId(caseManageData));
        this.init(logicEntityDynamicObject);
        MetadataGenParam metadataGenParam = this.buildMetadataGenParam(logicEntityDynamicObject);
        this.specialHandle(logicEntityDynamicObject, metadataGenParam);
        Map<String, Object> result = this.initResultMap(logicEntityDynamicObject);
        result.put("data", metadataGenParam);
        result.put("bizEntityNumber", this.extMetaNumber);
        result.put("bizObjNumber", logicEntityDynamicObject.getString("bizobj.number"));
        result.put("mappingRule", "extEntity");
        result.put("appId", this.appId);
        return JsonUtils.toStr(result);
    }

    @Override
    public void endOperate(DynamicObject extCaseManageDynamicObject, Map<String, Object> runContextMap) {
        DynamicObject caseData = this.logicEntityDomainService.getLogicEntityInfoById(this.getCaseDataId(extCaseManageDynamicObject));
        if (HRObjectUtils.isEmpty((Object)caseData)) {
            LOG.info("CommonCaseRuleHandle.endOperate is end, because caseData is empty");
            return;
        }
        caseData.set("cusstatus", (Object)"1");
        this.logicEntityDomainService.saveLogicEntity(caseData);
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)caseData.getString("number"));
        List<DynamicObject> propInfoList = this.propDomainService.getPropByEntityIdAndIsv(caseData.getLong("id"), ISVServiceHelper.getISVInfo().getId());
        this.updateTechPropInfo(propInfoList, mainEntityType);
        this.propDomainService.batchSaveProp(propInfoList);
        String entityNumber = (String)runContextMap.get("resultEntityNumber");
        this.saveEntityCardAndRelEntityCard(caseData.getLong("id"), entityNumber);
    }

    protected void saveEntityCardAndRelEntityCard(long logicEntityId, String metaNumber) {
        this.entityCardDomainService.saveEntityCardAndRelEntityCard(logicEntityId, metaNumber);
    }

    @Override
    protected void initBaseParam(BaseParam baseParam, DynamicObject caseData) {
        baseParam.setMetadataNumber(this.extMetaNumber);
        baseParam.setMetadataName(this.extMetaName);
        baseParam.setType(MetadataGenTypeEnum.EXTEND_METADATA);
    }

    @Override
    protected void handleBaseParam(BaseParam baseParam, DynamicObject logicEntityDy) {
        FormMetadata formMetadata = MetadataUtils.getFormMetadataByNumber((String)this.extMetaNumber);
        baseParam.setParentId(formMetadata.getEntityId());
        baseParam.setModelType(formMetadata.getModelType());
        baseParam.setBizUnitId((String)this.bizUnitEntityService.getMetadataBizUnit(formMetadata.getEntityId(), formMetadata.getBizappId()).orElse(null));
        baseParam.setAppId(this.appId);
    }

    @Override
    protected List<DynamicObject> getPropInfoList(Long logicEntityId) {
        return this.propDomainService.getPropByEntityIdAndIsv(logicEntityId, ISVServiceHelper.getISVInfo().getId());
    }
}

