/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.caserule.handle;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.caserule.handle.AbstractCaseRuleHandle;
import kd.hdtc.hrbm.business.domain.model.IEntityCardDomainService;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrbm.business.domain.model.IPropDomainService;
import kd.hdtc.hrbm.business.domain.model.ITempMappingDomainService;
import kd.hdtc.hrbm.business.domain.model.entity.ILogicEntityRelEntityService;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class LogicEntityCaseRuleHandle
extends AbstractCaseRuleHandle {
    private static final Log LOG = LogFactory.getLog(LogicEntityCaseRuleHandle.class);
    private final ILogicEntityDomainService logicEntityDomainService = ServiceFactory.getService(ILogicEntityDomainService.class);
    private final ILogicEntityRelEntityService logicEntityRelEntityService = ServiceFactory.getService(ILogicEntityRelEntityService.class);
    private final IPropDomainService propDomainService = ServiceFactory.getService(IPropDomainService.class);
    private final ITempMappingDomainService tempMappingDomainService = ServiceFactory.getService(ITempMappingDomainService.class);
    private final IEntityCardDomainService entityCardDomainService = ServiceFactory.getService(IEntityCardDomainService.class);

    @Override
    public String generateRunParamStr(DynamicObject caseManageData) {
        DynamicObject caseDataDynamicObject = this.logicEntityDomainService.getLogicEntityInfoById(this.getCaseDataId(caseManageData));
        Map<String, Object> result = this.initResultMap(caseDataDynamicObject);
        MetadataGenParam metadataGenParam = this.buildMetadataGenParam(caseDataDynamicObject);
        result.put("data", metadataGenParam);
        result.put("mappingRule", "generate_isv_entity");
        result.put("appId", metadataGenParam.getBaseParam().getAppId());
        result.put("bizEntityNumber", caseDataDynamicObject.getDynamicObject("bizobj").getString("number"));
        result.put("logicEntityNumber", caseDataDynamicObject.getString("number"));
        result.put("logicEntityName", caseDataDynamicObject.getString("name"));
        result.put("classify", this.getPersonClassify(caseDataDynamicObject.getLong("template.id")));
        result.put("fieldList", metadataGenParam.getFieldParamList());
        result.put("mulline", caseDataDynamicObject.getBoolean("mulline"));
        DynamicObject menuLocal = caseDataDynamicObject.getDynamicObject("menulocal");
        if (menuLocal != null) {
            result.put("menuLocal", menuLocal.getDynamicObject("app").getString("number"));
            result.put("menuLocalNumber", menuLocal.getString("number"));
        }
        return JsonUtils.toStr(result);
    }

    @Override
    public void endOperate(DynamicObject extCaseManageDynamicObject, Map<String, Object> runContextMap) {
        DynamicObject caseData = this.logicEntityDomainService.getLogicEntityInfoById(this.getCaseDataId(extCaseManageDynamicObject));
        if (HRObjectUtils.isEmpty((Object)caseData)) {
            LOG.info("LogicEntityCaseRuleHandle.endOperate is end, because caseData is empty");
            return;
        }
        if (CollectionUtils.isEmpty(runContextMap)) {
            LOG.info("LogicEntityCaseRuleHandle.endOperate is end, because runContextMap is empty");
            return;
        }
        caseData.set("cusstatus", (Object)"1");
        this.logicEntityDomainService.saveLogicEntity(caseData);
        String entityNumber = (String)runContextMap.get("resultEntityNumber");
        if (HRStringUtils.isEmpty((String)entityNumber)) {
            LOG.info("LogicEntityCaseRuleHandle.saveLogicEntityRel is end, because entityNumber is null");
            return;
        }
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        if (mainEntityType == null) {
            LOG.info("LogicEntityCaseRuleHandle.saveLogicEntityRel is end, because mainEntityType is null");
            return;
        }
        this.saveLogicEntityRel(caseData, mainEntityType);
        List<DynamicObject> propInfoList = this.propDomainService.getPropInfobyLogicEntityId(caseData.getLong("id"));
        this.updateTechPropInfo(propInfoList, mainEntityType);
        this.propDomainService.batchSaveProp(propInfoList);
        this.saveEntityCardAndRelEntityCard(caseData.getLong("id"), entityNumber);
    }

    protected void saveEntityCardAndRelEntityCard(long logicEntityId, String metaNumber) {
        this.entityCardDomainService.saveEntityCardAndRelEntityCard(logicEntityId, metaNumber);
    }

    private void saveLogicEntityRel(DynamicObject caseData, MainEntityType mainEntityType) {
        Object logicEntityRel;
        Object[] logicEntityRels = this.logicEntityRelEntityService.queryLogicEntityRelByLogicEntityId(caseData.getLong("id"));
        if (HRArrayUtils.isEmpty((Object[])logicEntityRels)) {
            logicEntityRel = this.logicEntityRelEntityService.generateEmptyDynamicObject();
            logicEntityRel.set("logicentity", (Object)caseData);
            logicEntityRel.set("creator", (Object)RequestContext.get().getCurrUserId());
            logicEntityRel.set("createtime", (Object)new Date());
        } else {
            logicEntityRel = logicEntityRels[0];
            logicEntityRel.set("modifier", (Object)RequestContext.get().getCurrUserId());
            logicEntityRel.set("modifytime", (Object)new Date());
        }
        logicEntityRel.set("metadatanum", (Object)mainEntityType.getName());
        logicEntityRel.set("metadataname", (Object)mainEntityType.getDisplayName());
        logicEntityRel.set("table", (Object)mainEntityType.getAlias());
        this.logicEntityRelEntityService.save((DynamicObject)logicEntityRel);
    }

    private String getPersonClassify(Long tempMappingId) {
        return this.tempMappingDomainService.getPersonClassify(tempMappingId);
    }
}

