/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.caserule.handle.hr;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.caserule.handle.CadreFileCaseRuleHandle;
import kd.hdtc.hrbm.business.domain.model.entity.ILogicEntityEntityService;
import kd.hdtc.hrbm.business.domain.model.entity.IPersonInfoConfEntityService;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseEntityService;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class CadreFileCaseExtRuleHandle
extends CadreFileCaseRuleHandle {
    private static final Log LOG = LogFactory.getLog(CadreFileCaseExtRuleHandle.class);
    private final IPersonInfoConfEntityService personInfoConfEntityService = ServiceFactory.getService(IPersonInfoConfEntityService.class);
    private final IBaseEntityService infoGroupFieldEntityService = CommonEntityServiceFactory.getEntityService((String)"soebs_infogrouppagereg");
    private final ILogicEntityEntityService logicEntityEntityService = ServiceFactory.getService(ILogicEntityEntityService.class);

    @Override
    protected Map<String, Object> getOtherParamMap(DynamicObject bizModelDy) {
        HashMap otherParamMap = Maps.newHashMapWithExpectedSize((int)16);
        if ((bizModelDy = this.logicEntityEntityService.queryOriginalOne("id,number,extmetanum", bizModelDy.getLong("id"))) == null) {
            LOG.error("not find bizmodel");
            return otherParamMap;
        }
        String bizModelNumber = bizModelDy.getString("extmetanum");
        bizModelNumber = StringUtils.isEmpty((String)bizModelNumber) ? bizModelDy.getString("number") : bizModelNumber;
        DynamicObject confDy = this.personInfoConfEntityService.queryOriginalByEntityObj(bizModelNumber);
        if (confDy == null) {
            LOG.info("not find personInfoConfig");
            return otherParamMap;
        }
        boolean isMul = confDy.getBoolean("ismul");
        otherParamMap.put("isSingleLineTable", !isMul);
        otherParamMap.put("cardContainerNumber", confDy.getString("cardflexnum"));
        otherParamMap.put("infoContainerNumber", confDy.getString("infoflexnum"));
        otherParamMap.put("containerParentNumber", confDy.getString("infoattflexnum"));
        otherParamMap.put("exttype", confDy.getString("exttype"));
        otherParamMap.put("modelEntityNumber", bizModelNumber);
        if (confDy.getBoolean("ismgfileview")) {
            this.addGroupInfoValue(bizModelNumber, otherParamMap, isMul);
        }
        return otherParamMap;
    }

    @Override
    protected List<DynamicObject> getPropInfoList(Long logicEntityId) {
        return this.propDomainService.getPropByEntityIdAndIsv(logicEntityId, ISVServiceHelper.getISVInfo().getId());
    }

    private void addGroupInfoValue(String bizModelNumber, Map<String, Object> otherParamMap, boolean isMul) {
        QFilter qFilter = new QFilter("pageinfo", "=", (Object)bizModelNumber);
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("businesstype", "!=", (Object)"1");
        DynamicObject groupInfoDy = this.infoGroupFieldEntityService.queryOriginalOne("dyviewpc", qFilter.toArray());
        if (groupInfoDy == null) {
            LOG.info("not find groupInfo");
            return;
        }
        String key = "mgmtSingleEntityNumber";
        if (isMul) {
            key = "mgmtMultiEntityNumber";
        }
        otherParamMap.put(key, groupInfoDy.getString("dyviewpc"));
    }
}

