/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.caserule.handle.hr;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.caserule.handle.AbstractCaseRuleHandle;
import kd.hdtc.hrbm.business.domain.model.IEntityCardDomainService;
import kd.hdtc.hrbm.business.domain.model.IPropDomainService;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseEntityService;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class OnBrdPersonCaseRuleHandle
extends AbstractCaseRuleHandle {
    private final IPropDomainService propDomainService = ServiceFactory.getService(IPropDomainService.class);
    private final IBaseEntityService onBrdConfigService = CommonEntityServiceFactory.getEntityService((String)"hom_peronbrdinfoconf");
    private final IEntityCardDomainService entityCardDomainService = ServiceFactory.getService(IEntityCardDomainService.class);

    @Override
    public String generateRunParamStr(DynamicObject caseManageData) {
        Map caseRuleMap = (Map)JsonUtils.castType((String)caseManageData.getString("caserule"), Map.class);
        DynamicObject bizModelDy = caseManageData.getDynamicObject("bizmodel");
        String modelEntityNumber = bizModelDy.getString("number");
        Map<String, Object> paramMap = this.initResultMap(bizModelDy);
        paramMap.put("modelEntityNumber", modelEntityNumber);
        paramMap.putAll(caseRuleMap);
        paramMap.put("showChange", this.getShowChanged(modelEntityNumber, caseRuleMap));
        paramMap.put("appId", "hom");
        paramMap.put("data", this.buildSourceMetadataGen(bizModelDy));
        return JsonUtils.toStr(paramMap);
    }

    private MetadataGenParam buildSourceMetadataGen(DynamicObject bizModelDy) {
        MetadataGenParam metadataGenParam = new MetadataGenParam();
        List<DynamicObject> propDyList = this.getPropInfoList(bizModelDy.getLong("id"));
        this.fillMetadataGenFieldParam(metadataGenParam, propDyList);
        return metadataGenParam;
    }

    private String getShowChanged(String modelEntityNumber, Map<String, Object> caseRuleMap) {
        String mul;
        String showChange = "0";
        QFilter qFilter = new QFilter("obj", "=", (Object)modelEntityNumber);
        qFilter.and("enable", "=", (Object)"1");
        DynamicObject configDy = this.onBrdConfigService.queryOne("ismul,showtype", qFilter.toArray());
        if (configDy == null) {
            return showChange;
        }
        String string = mul = configDy.getBoolean("ismul") ? "1" : "0";
        if (!mul.equals(caseRuleMap.get("ismul"))) {
            return "1";
        }
        if (!configDy.getString("showtype").equals(caseRuleMap.get("showtype"))) {
            return "1";
        }
        return showChange;
    }

    @Override
    protected void fillFieldParam(FieldParam fieldParam, DynamicObject field) {
        fieldParam.cancelAutoGenFieldName();
    }

    @Override
    protected List<DynamicObject> getPropInfoList(Long logicEntityId) {
        QFilter qFilter = new QFilter("proptype", "=", (Object)"10");
        qFilter.and("cusstatus", "=", (Object)"1");
        qFilter.and("propkey", "not in", Arrays.asList("id", "candidate", "issingle"));
        return this.propDomainService.getPropsByEntityIdAndQFilter(logicEntityId, qFilter, "index");
    }

    @Override
    public void endOperate(DynamicObject extCaseManageDynamicObject, Map<String, Object> runContextMap) {
        long bizModelId = extCaseManageDynamicObject.getLong("bizmodel.id");
        String oldEditEntityNumber = (String)runContextMap.get("oldEditEntityNumber");
        if (StringUtils.isNotEmpty((String)oldEditEntityNumber)) {
            this.entityCardDomainService.deleteByLogicEntityIds(Sets.newHashSet((Object[])new Long[]{bizModelId}));
        }
        String entityNumber = (String)runContextMap.get("editEntityNumber");
        this.entityCardDomainService.saveEntityCardAndRelEntityCard(bizModelId, entityNumber);
    }
}

