/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.caserule.handle.sihc;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.caserule.handle.AbstractCaseRuleHandle;
import kd.hdtc.hrbm.business.domain.caserule.handle.ExtCaseRuleHandle;
import kd.hdtc.hrbm.business.domain.model.IEntityCardDomainService;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrbm.business.domain.model.IPropDomainService;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IBizUnitEntityService;
import kd.hdtc.hrdbs.common.enums.MetadataGenTypeEnum;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.pojo.metadata.EntryParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class AppRemRegRuleHandle
extends AbstractCaseRuleHandle {
    private static final Log LOG = LogFactory.getLog(ExtCaseRuleHandle.class);
    private final ILogicEntityDomainService logicEntityDomainService = ServiceFactory.getService(ILogicEntityDomainService.class);
    private final IPropDomainService propDomainService = ServiceFactory.getService(IPropDomainService.class);
    private final IBizUnitEntityService bizUnitEntityService = (IBizUnitEntityService)kd.hdtc.hrdbs.business.common.ServiceFactory.getService(IBizUnitEntityService.class);
    private final IEntityCardDomainService entityCardDomainService = ServiceFactory.getService(IEntityCardDomainService.class);
    private String extMetaNumber;
    private String extMetaName;
    private String appId;
    private static final String APPREMFLEX_FIELDSETPANELAP = "fieldsetpanelap";
    private static final Map<String, String> CONTAINER_MAP = new HashMap<String, String>(16);
    private static final Map<String, String> TABLENAME_MAP = new HashMap<String, String>(16);

    private void init(DynamicObject logicEntityDynamicObject) {
        String extMetadataNumber = this.getExtMetadataNumber(logicEntityDynamicObject);
        if (HRStringUtils.startsWithIgnoreCase((String)extMetadataNumber, (String)"soecadm_appremreg.")) {
            extMetadataNumber = "soecadm_appremreg";
        }
        this.extMetaNumber = extMetadataNumber;
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)this.extMetaNumber);
        this.extMetaName = mainEntityType.getDisplayName().getLocaleValue();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.extMetaNumber);
        this.appId = mainType.getAppId();
    }

    private void specialHandle(DynamicObject logicEntityDynamicObject, MetadataGenParam metadataGenParam) {
        String extMetadataNumber = this.getExtMetadataNumber(logicEntityDynamicObject);
        List fieldParamList = metadataGenParam.getFieldParamList();
        if (CollectionUtils.isNotEmpty((Collection)fieldParamList) && HRStringUtils.startsWithIgnoreCase((String)extMetadataNumber, (String)"soecadm_appremreg.")) {
            String entryKey = extMetadataNumber.substring("soecadm_appremreg.".length());
            EntryParam entryParam = new EntryParam();
            entryParam.setContainerNumber(CONTAINER_MAP.get(entryKey));
            entryParam.setType("EntryEntity");
            entryParam.setTableName(TABLENAME_MAP.get(entryKey));
            entryParam.setEntryKey(entryKey);
            fieldParamList.forEach(fieldParam -> {
                fieldParam.setType(fieldParam.getType() + "entry");
                fieldParam.setContainerNumber(entryKey);
                fieldParam.setIndex(fieldParam.getIndex() + 99);
            });
            entryParam.setFieldParamList(fieldParamList);
            metadataGenParam.setEntryParamList((List)ImmutableList.of((Object)entryParam));
            metadataGenParam.setFieldParamList(new ArrayList());
        }
    }

    @Override
    public String generateRunParamStr(DynamicObject caseManageData) {
        DynamicObject logicEntityDynamicObject = this.logicEntityDomainService.getLogicEntityInfoById(this.getCaseDataId(caseManageData));
        this.init(logicEntityDynamicObject);
        MetadataGenParam metadataGenParam = this.buildMetadataGenParam(logicEntityDynamicObject);
        this.specialHandle(logicEntityDynamicObject, metadataGenParam);
        Map<String, Object> result = this.initResultMap(logicEntityDynamicObject);
        result.put("data", metadataGenParam);
        result.put("bizEntityNumber", this.extMetaNumber);
        result.put("bizObjNumber", logicEntityDynamicObject.getString("bizobj.number"));
        result.put("mappingRule", "extEntity");
        result.put("appId", this.appId);
        return JsonUtils.toStr(result);
    }

    @Override
    public void endOperate(DynamicObject extCaseManageDynamicObject, Map<String, Object> runContextMap) {
        DynamicObject caseData = this.logicEntityDomainService.getLogicEntityInfoById(this.getCaseDataId(extCaseManageDynamicObject));
        if (HRObjectUtils.isEmpty((Object)caseData)) {
            LOG.info("CommonCaseRuleHandle.endOperate is end, because caseData is empty");
            return;
        }
        caseData.set("cusstatus", (Object)"1");
        this.logicEntityDomainService.saveLogicEntity(caseData);
        String extMetadataNumber = caseData.getString("number");
        if (HRStringUtils.startsWithIgnoreCase((String)extMetadataNumber, (String)"soecadm_appremreg.")) {
            extMetadataNumber = "soecadm_appremreg";
        }
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)extMetadataNumber);
        List<DynamicObject> propInfoList = this.propDomainService.getPropByEntityIdAndIsv(caseData.getLong("id"), ISVServiceHelper.getISVInfo().getId());
        this.updateTechPropInfo(propInfoList, mainEntityType);
        this.propDomainService.batchSaveProp(propInfoList);
        String entityNumber = (String)runContextMap.get("resultEntityNumber");
        this.saveEntityCardAndRelEntityCard(caseData.getLong("id"), entityNumber);
    }

    protected void saveEntityCardAndRelEntityCard(long logicEntityId, String metaNumber) {
        this.entityCardDomainService.saveEntityCardAndRelEntityCard(logicEntityId, metaNumber);
    }

    @Override
    protected void initBaseParam(BaseParam baseParam, DynamicObject caseData) {
        baseParam.setMetadataNumber(this.extMetaNumber);
        baseParam.setMetadataName(this.extMetaName);
        baseParam.setType(MetadataGenTypeEnum.EXTEND_METADATA);
    }

    @Override
    protected void handleBaseParam(BaseParam baseParam, DynamicObject logicEntityDy) {
        FormMetadata formMetadata = MetadataUtils.getFormMetadataByNumber((String)this.extMetaNumber);
        baseParam.setParentId(formMetadata.getEntityId());
        baseParam.setModelType(formMetadata.getModelType());
        baseParam.setBizUnitId((String)this.bizUnitEntityService.getMetadataBizUnit(formMetadata.getEntityId(), formMetadata.getBizappId()).orElse(null));
        baseParam.setAppId(this.appId);
    }

    @Override
    protected List<DynamicObject> getPropInfoList(Long logicEntityId) {
        return this.propDomainService.getPropByEntityIdAndIsv(logicEntityId, ISVServiceHelper.getISVInfo().getId());
    }

    @Override
    protected String getContainNumber() {
        return APPREMFLEX_FIELDSETPANELAP;
    }

    static {
        CONTAINER_MAP.put("aentryentity", "flexpanelap1");
        CONTAINER_MAP.put("authorityentry", "flexpanelap");
        CONTAINER_MAP.put("centryentity", "changepositionflex");
        CONTAINER_MAP.put("ientryentity", "currentinfoflex");
        CONTAINER_MAP.put("rentryentity", "prodismissalflex");
        TABLENAME_MAP.put("aentryentity", "t_soecadm_appentry");
        TABLENAME_MAP.put("authorityentry", "t_soecadm_arrauthentry");
        TABLENAME_MAP.put("centryentity", "t_soecadm_chaposentry");
        TABLENAME_MAP.put("ientryentity", "t_soecadm_incposentry");
        TABLENAME_MAP.put("rentryentity", "t_soecadm_rementry");
    }
}

