/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.caserule.handle.sihc;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.caserule.handle.AbstractCaseRuleHandle;
import kd.hdtc.hrbm.business.domain.extcase.entity.sihc.IModifyCadreReportEntityService;
import kd.hdtc.hrbm.business.domain.model.IPropDomainService;
import kd.hdtc.hrbm.business.domain.task.impl.sihc.SnapCadreRosterHelper;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.util.JsonUtils;

public class ModCadreReportCaseRuleHandle
extends AbstractCaseRuleHandle {
    protected final IPropDomainService propDomainService = ServiceFactory.getService(IPropDomainService.class);
    private final IModifyCadreReportEntityService modifyCadreReportService = ServiceFactory.getService(IModifyCadreReportEntityService.class);
    private List<Long> propIds;

    @Override
    public String generateRunParamStr(DynamicObject caseManageData) {
        DynamicObject caseDataDynamicObject = caseManageData.getDynamicObject("bizmodel");
        Map<String, Object> paramMap = this.initResultMap(caseDataDynamicObject);
        Map caseRuleMap = (Map)JsonUtils.castType((String)caseManageData.getString("caserule"), Map.class);
        paramMap.putAll(caseRuleMap);
        paramMap.put("genCadreReportQuery", true);
        MetadataGenParam metadataGenParam = this.getMetadataGenParam(caseDataDynamicObject, caseRuleMap, paramMap);
        paramMap.put("data", metadataGenParam);
        return JsonUtils.toStr(paramMap);
    }

    private MetadataGenParam getMetadataGenParam(DynamicObject caseDataDynamicObject, Map<String, Object> caseRuleMap, Map<String, Object> paramMap) {
        MetadataGenParam metadataGenParam = new MetadataGenParam();
        long primaryKey = (Long)caseRuleMap.get("primaryKey");
        DynamicObject modifyCadreReportObj = this.modifyCadreReportService.getModifyCadreReportById(primaryKey);
        String bizEntityNumber = modifyCadreReportObj.getString("bizmodel.number");
        String rosterEntityNumber = SnapCadreRosterHelper.getSnapCadreRosterEntityNumber(bizEntityNumber);
        paramMap.put("bizEntityNumber", bizEntityNumber);
        paramMap.put("rosterEntityNumber", rosterEntityNumber);
        this.propIds = modifyCadreReportObj.getDynamicObjectCollection("entryentity_snap").stream().map(obj -> obj.getLong("snapprop.id")).collect(Collectors.toList());
        List<DynamicObject> propDyList = this.getPropInfoList(caseDataDynamicObject.getLong("id"));
        this.fillMetadataGenFieldParam(metadataGenParam, propDyList);
        return metadataGenParam;
    }

    @Override
    protected List<DynamicObject> getPropInfoList(Long logicEntityId) {
        QFilter qFilter = new QFilter("proptype", "=", (Object)"10");
        qFilter.and("cusstatus", "=", (Object)"1");
        qFilter.and("id", "in", this.propIds);
        return this.propDomainService.getPropsByEntityIdAndQFilter(logicEntityId, qFilter, "index");
    }

    @Override
    public void endOperate(DynamicObject extCaseManageDynamicObject, Map<String, Object> runContextMap) {
    }
}

