/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.caserule.handle.swc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.caserule.handle.ICaseRuleHandle;
import kd.hdtc.hrbm.business.domain.extcase.entity.IExtCaseManageEntityService;
import kd.hdtc.hrbm.common.constant.swc.SWCBaseConstants;
import kd.hdtc.hrbm.common.constant.swc.SWCRelExtPropRuleConstants;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IBizUnitEntityService;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseEntityService;
import kd.hdtc.hrdbs.common.enums.MetadataGenTypeEnum;
import kd.hdtc.hrdbs.common.enums.NodeHandleTypeEnum;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class SWCRelExtPropRuleHandle
implements ICaseRuleHandle,
SWCBaseConstants,
SWCRelExtPropRuleConstants {
    private static final Map<String, String> bdPropMap = new HashMap<String, String>(10);
    public final IBizUnitEntityService bizUnitEntityService = (IBizUnitEntityService)kd.hdtc.hrdbs.business.common.ServiceFactory.getService(IBizUnitEntityService.class);
    private final IExtCaseManageEntityService iExtCaseManageEntityService = ServiceFactory.getService(IExtCaseManageEntityService.class);
    private final IBaseEntityService iRelExtEntityService = CommonEntityServiceFactory.getEntityService((String)"hrbm_swcrelextprop");
    private final IBaseEntityService iPropEntityService = CommonEntityServiceFactory.getEntityService((String)"hrbm_prop");

    @Override
    public String generateRunParamStr(DynamicObject caseManageData) {
        String bdPropNumber;
        String logicEntity = caseManageData.getDynamicObject("bizmodel").getDataEntityType().getName();
        long logicEntityId = caseManageData.getDynamicObject("bizmodel").getLong("id");
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
        paramMap.put("baseDatatype", logicEntity);
        paramMap.put("bizModelId", logicEntityId);
        QFilter bizModelFilter = new QFilter("logicentity", "=", (Object)logicEntityId);
        DynamicObject[] confArr = this.iRelExtEntityService.query("logicentity.number,logicentity.extmetanum,entryentity,entryentity.extappcase,entryentity.prop", bizModelFilter.toArray());
        if (confArr == null || confArr.length == 0) {
            return JsonUtils.toStr((Object)paramMap);
        }
        String extMetaNum = confArr[0].getString("logicentity.extmetanum");
        if (extMetaNum == null || HRStringUtils.isEmpty((String)extMetaNum)) {
            extMetaNum = confArr[0].getString("logicentity.number");
        }
        if ((bdPropNumber = bdPropMap.get(extMetaNum)) != null) {
            this.addBasedataRefProp(paramMap, confArr, bdPropNumber);
        }
        if (paramMap.containsKey("data")) {
            paramMap.put("mappingRule", "relExtPropRule");
        } else {
            paramMap.put("mappingRule", "relExtPropRule_notmatch");
        }
        return JsonUtils.toStr((Object)paramMap);
    }

    private void addBasedataRefProp(Map<String, Object> paramMap, DynamicObject[] confArr, String bdPropNumber) {
        DynamicObject[] propArr = this.getPropArr(confArr[0], CALPERSON_CASEID);
        if (propArr == null || propArr.length == 0) {
            return;
        }
        MetadataGenParam metadataGenParam = new MetadataGenParam();
        BaseParam baseParam = new BaseParam();
        baseParam.setMetadataNumber("hsas_calperson");
        baseParam.setType(MetadataGenTypeEnum.EXTEND_METADATA);
        FormMetadata formMetadata = MetadataUtils.getFormMetadataByNumber((String)baseParam.getMetadataNumber());
        baseParam.setParentId(formMetadata.getEntityId());
        baseParam.setModelType(formMetadata.getModelType());
        baseParam.setAppId(formMetadata.getBizappNumber());
        baseParam.setMetadataName(formMetadata.getName().getLocaleValue());
        Optional metadataBizUnit = this.bizUnitEntityService.getMetadataBizUnit(formMetadata.getId(), formMetadata.getBizappId());
        String bizUnit = (String)metadataBizUnit.get();
        baseParam.setBizUnitId(bizUnit);
        metadataGenParam.setBaseParam(baseParam);
        FieldParam fieldParam = new FieldParam();
        String propName = " ";
        List items = formMetadata.getItems();
        for (DynamicObject[] item : items) {
            if (!bdPropNumber.equals(item.getKey())) continue;
            propName = item.getName().getLocaleValue();
        }
        fieldParam.setName(propName);
        fieldParam.setNumber(bdPropNumber);
        fieldParam.setType("BasedataField");
        fieldParam.setNodeHandleTypeEnum(NodeHandleTypeEnum.UPDATE);
        ArrayList basedataRefProp = Lists.newArrayListWithExpectedSize((int)10);
        fieldParam.setBasedataRefProp((List)basedataRefProp);
        for (DynamicObject prop : propArr) {
            String fieldType = prop.getString("fieldtype");
            Boolean isDelete = (Boolean)prop.get("deleted");
            if (isDelete.booleanValue() || "BasedataPropField".equals(fieldType)) continue;
            basedataRefProp.add(prop.getString("propkey"));
        }
        if (basedataRefProp.size() == 0) {
            return;
        }
        ArrayList fieldParamList = Lists.newArrayListWithExpectedSize((int)10);
        fieldParamList.add(fieldParam);
        metadataGenParam.setFieldParamList((List)fieldParamList);
        paramMap.put("data", metadataGenParam);
    }

    private DynamicObject[] getPropArr(DynamicObject conf, Long matchCaseId) {
        HashSet<Long> ids = new HashSet<Long>(16);
        DynamicObjectCollection entryentitys = conf.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryentitys) {
            DynamicObjectCollection extappcases = entry.getDynamicObjectCollection("extappcase");
            boolean isContain = false;
            for (DynamicObject extappcase : extappcases) {
                Long caseId = extappcase.getLong("fbasedataid_id");
                if (matchCaseId.compareTo(caseId) != 0) continue;
                isContain = true;
                break;
            }
            if (!isContain) continue;
            DynamicObjectCollection props = entry.getDynamicObjectCollection("prop");
            for (DynamicObject prop : props) {
                ids.add(prop.getLong("fbasedataid_id"));
            }
        }
        if (ids.size() == 0) {
            return null;
        }
        QFilter idFilter = new QFilter("id", "in", ids);
        DynamicObject[] propArr = this.iPropEntityService.query("number,name,propkey,fieldtype,deleted", idFilter.toArray());
        return propArr;
    }

    @Override
    public void endOperate(DynamicObject extCaseManageDynamicObject, Map<String, Object> runContextMap) {
    }

    @Override
    public void callback(long id, Map<String, Object> runContextMap) {
        DynamicObject dynamicObject = this.iExtCaseManageEntityService.queryExtCaseManageById(id);
        this.endOperate(dynamicObject, runContextMap);
        dynamicObject.set("cusstatus", (Object)"1");
        this.iExtCaseManageEntityService.save(dynamicObject);
    }

    static {
        bdPropMap.put("hsas_salaryfile", "salaryfilev");
        bdPropMap.put("hsas_empentrel", "empentrelv");
        bdPropMap.put("hsas_empjobrel", "empjobrelv");
        bdPropMap.put("hsas_empposorgrelhr", "empposorgrelhrv");
        bdPropMap.put("hsas_pernontsprop", "pernontspropv");
        bdPropMap.put("hsas_perserlen", "perserlenv");
        bdPropMap.put("hsas_trialperiod", "trialperiodv");
        bdPropMap.put("hsas_managingscope", "manascoperecordv");
    }
}

