/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.extcase.bo;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.baseconfig.IBaseConfigDomainService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class ExtCaseUniversalRangeBo {
    private final IBaseConfigDomainService iBaseConfigDomainService = ServiceFactory.createInstance(IBaseConfigDomainService.class);
    private final List<DynamicObject> extCaseList;
    private final Set<Long> bizCloudIdSet = Sets.newHashSetWithExpectedSize((int)16);
    private final Set<Long> bizAppIdSet = Sets.newHashSetWithExpectedSize((int)16);
    private final Set<Long> bizObjIdSet = Sets.newHashSetWithExpectedSize((int)16);
    private final Set<Long> logicEntityIdSet = Sets.newHashSetWithExpectedSize((int)16);
    private int currentIsvFlag;

    public ExtCaseUniversalRangeBo(List<DynamicObject> extCaseList) {
        this.extCaseList = extCaseList;
        this.currentIsvFlag = this.initCurrentIsvFlag();
        this.initUniversalRange();
    }

    private int initCurrentIsvFlag() {
        if (CollectionUtils.isEmpty(this.extCaseList)) {
            return 2;
        }
        Set<String> notNeedIsvFilterExtCaseNumberSet = this.iBaseConfigDomainService.getValueSetByKey("CHECK_IGNORE_ISV", ",");
        boolean initCurrentIsv = this.extCaseList.get(0).getBoolean("currentisv");
        for (DynamicObject extCase : this.extCaseList) {
            String casePage = extCase.getString("casepage");
            if (HRStringUtils.isNotEmpty((String)casePage) && notNeedIsvFilterExtCaseNumberSet.contains(casePage)) {
                return 2;
            }
            if (initCurrentIsv == extCase.getBoolean("currentisv")) continue;
            return 2;
        }
        return initCurrentIsv ? 1 : 0;
    }

    private void initUniversalRange() {
        if (CollectionUtils.isEmpty(this.extCaseList)) {
            return;
        }
        for (DynamicObject extCase : this.extCaseList) {
            this.handleUniversalRange(extCase);
        }
    }

    private void handleUniversalRange(DynamicObject extCase) {
        DynamicObjectCollection universalRangeCollection = extCase.getDynamicObjectCollection("entryentity");
        universalRangeCollection.forEach(dy -> {
            String baseDataType = dy.getString("basedatatype");
            DynamicObject bizModel = dy.getDynamicObject("bizmodel");
            switch (baseDataType) {
                case "hrbm_cloud": {
                    this.bizCloudIdSet.add(bizModel.getLong("id"));
                    break;
                }
                case "hrbm_app": {
                    this.bizAppIdSet.add(bizModel.getLong("id"));
                    break;
                }
                case "hrbm_bizobj": {
                    this.bizObjIdSet.add(bizModel.getLong("id"));
                    break;
                }
                case "hrbm_logicentity": {
                    this.logicEntityIdSet.add(bizModel.getLong("id"));
                    break;
                }
            }
        });
    }

    public Set<Long> getBizAppIdSet() {
        return this.bizAppIdSet;
    }

    public Set<Long> getBizObjIdSet() {
        return this.bizObjIdSet;
    }

    public Set<Long> getBizCloudIdSet() {
        return this.bizCloudIdSet;
    }

    public Set<Long> getLogicEntityIdSet() {
        return this.logicEntityIdSet;
    }

    public int getCurrentIsvFlag() {
        return this.currentIsvFlag;
    }
}

