/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.extcase.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.extcase.IExtCaseDomainService;
import kd.hdtc.hrbm.business.domain.extcase.entity.IExtCaseEntityService;
import kd.hdtc.hrbm.business.domain.model.IBizModelDataDomainService;
import kd.hdtc.hrbm.business.domain.model.bean.BizModelDataBean;
import kd.hdtc.hrbm.common.enums.BizModelTypeEnum;
import kd.hdtc.hrbm.common.exception.HRBMBizException;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.IsvUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class ExtCaseDomainServiceImpl
implements IExtCaseDomainService {
    private static final Log LOG = LogFactory.getLog(ExtCaseDomainServiceImpl.class);
    private IExtCaseEntityService extCaseEntityService = ServiceFactory.getService(IExtCaseEntityService.class);
    private IBizModelDataDomainService bizModelDataDomainService = ServiceFactory.getService(IBizModelDataDomainService.class);
    private static final String NORMAL_EXT_FIELD_CASE = "1010_S";
    private static final String ISV_BASE_DATA_CASE = "1050_S";
    private static final Set<String> BASE_DATA_BIZ_OBJ_TYPE_SET = ImmutableSet.of((Object)"40", (Object)"50", (Object)"60");

    @Override
    public DynamicObject getMatchedExtCase(String bizObjNumber, boolean isCurrentIsv) {
        Map<Object, DynamicObject> originExtCaseMap = this.getAllExtCaseFromCache();
        Map<String, DynamicObject> allExtCaseMap = this.getAllExtCaseMap(originExtCaseMap);
        DynamicObject extCaseDy = this.getExtCaseDy(NORMAL_EXT_FIELD_CASE, originExtCaseMap);
        DynamicObject dy = allExtCaseMap.get(this.getExtCaseKey("hrbm_bizobj", bizObjNumber, isCurrentIsv));
        if (dy != null) {
            return dy;
        }
        if (!isCurrentIsv) {
            return extCaseDy;
        }
        LOG.info("ExtCaseDomainServiceImpl.getMatchedExtCase() bizObjNumber:{}, isCurrentIsv:{}", (Object)bizObjNumber, (Object)isCurrentIsv);
        throw new HRBMBizException(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u6269\u5c55\u573a\u666f\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"ExtCaseDomainServiceImpl_0", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
    }

    @Override
    public String getMatchedPage(String bizObjNumber, boolean isCurrentIsv) {
        return this.getMatchedExtCase(bizObjNumber, isCurrentIsv).getString("casepage");
    }

    private DynamicObject getMatchedExtCase(BizModelTypeEnum bizModelType, String bizModelNumber, boolean isCurrentIsv) {
        Map<Object, DynamicObject> originExtCaseMap = this.getAllExtCaseFromCache();
        Map<String, DynamicObject> allExtCaseMap = this.getAllExtCaseMap(originExtCaseMap);
        DynamicObject dy = allExtCaseMap.get(this.getExtCaseKey(bizModelType.getType(), bizModelNumber, isCurrentIsv));
        if (dy != null) {
            return dy;
        }
        return null;
    }

    @Override
    public DynamicObject getMatchedExtCase(BizModelDataBean bizModelDataBean, boolean isCurrentIsv) {
        Map<Object, DynamicObject> originExtCaseMap;
        DynamicObject extCaseDy;
        DynamicObject extCase;
        if (bizModelDataBean == null || bizModelDataBean.getBizModelType() == null || bizModelDataBean.getBizModel() == null) {
            LOG.info("ExtCaseDomainServiceImpl.getMatchedExtCase() \u6b64\u6a21\u578b\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            throw new HRBMBizException(ResManager.loadKDString((String)"\u6b64\u6a21\u578b\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExtCaseDomainServiceImpl_1", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        }
        if (bizModelDataBean.getBizModelType() == BizModelTypeEnum.LOGIC_ENTITY) {
            this.bizModelDataDomainService.putParentBean(bizModelDataBean, false);
        }
        if (!((extCase = this.getMatchedPageDy(bizModelDataBean, isCurrentIsv)) != null || isCurrentIsv || bizModelDataBean.getBizModelType() != BizModelTypeEnum.BIZ_OBJ && bizModelDataBean.getBizModelType() != BizModelTypeEnum.LOGIC_ENTITY || (extCaseDy = this.getExtCaseDy(NORMAL_EXT_FIELD_CASE, originExtCaseMap = this.getAllExtCaseFromCache())) == null)) {
            return extCaseDy;
        }
        if (extCase == null) {
            LOG.info("ExtCaseDomainServiceImpl.getMatchedExtCase() bizModelType:{} bizModelNumber:{}, isCurrentIsv:{}", new Object[]{bizModelDataBean.getBizModelType(), bizModelDataBean.getBizModel().getString("number"), isCurrentIsv});
            throw new HRBMBizException(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u6269\u5c55\u573a\u666f\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"ExtCaseDomainServiceImpl_0", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        }
        return extCase;
    }

    @Override
    public String getMatchedPage(BizModelDataBean bizModelDataBean, boolean isCurrentIsv) {
        return this.getMatchedExtCase(bizModelDataBean, isCurrentIsv).getString("casepage");
    }

    private DynamicObject getMatchedPageDy(BizModelDataBean bizModelDataBean, boolean isCurrentIsv) {
        if (bizModelDataBean == null || bizModelDataBean.getBizModelType() == null || bizModelDataBean.getBizModel() == null) {
            return null;
        }
        DynamicObject bizModel = bizModelDataBean.getBizModel();
        DynamicObject extCase = this.getMatchedExtCase(bizModelDataBean.getBizModelType(), bizModel.getString("number"), isCurrentIsv);
        if (extCase != null) {
            return extCase;
        }
        BizModelDataBean parentBean = bizModelDataBean.getParentBean();
        if (parentBean == null) {
            return null;
        }
        return this.getMatchedPageDy(parentBean, isCurrentIsv);
    }

    @Override
    public Map<DynamicObject, DynamicObject> getExtCaseByLogicEntity(List<DynamicObject> logicEntityDyList) {
        String bizObjType = Optional.ofNullable(logicEntityDyList).filter(it -> CollectionUtils.isNotEmpty((Collection)it)).map(it -> (DynamicObject)it.get(0)).map(it -> it.getDynamicObject("bizobj")).map(it -> it.getString("type")).orElse("");
        if (StringUtils.isEmpty((String)bizObjType)) {
            throw new HRBMBizException("bizObjType should not be empty");
        }
        if (this.isBaseDataType(bizObjType)) {
            return this.getBaseDataExtCaseMatch(logicEntityDyList);
        }
        return this.getBizModelExtCaseMap(logicEntityDyList);
    }

    @Override
    public boolean hasMatchedExtCase(Long bizObjId, List<String> extCaseNumberList, String baseDataType) {
        if (bizObjId == null || CollectionUtils.isEmpty(extCaseNumberList) || StringUtils.isEmpty((String)baseDataType)) {
            return false;
        }
        QFilter numberFilter = new QFilter("number", "in", extCaseNumberList);
        QFilter bizModelFilter = new QFilter("entryentity.bizmodel", "=", (Object)bizObjId);
        QFilter baseDataTypeFilter = new QFilter("entryentity.basedatatype", "=", (Object)baseDataType);
        DynamicObject dynamicObject = this.extCaseEntityService.queryOne("id,name,number,entryentity.bizmodel,entryentity.basedatatype", new QFilter[]{numberFilter, bizModelFilter, baseDataTypeFilter});
        return dynamicObject != null;
    }

    @Override
    public Map<String, List<Long>> transferExtCaseRangeToMap(List<DynamicObject> extCaseList) {
        if (CollectionUtils.isEmpty(extCaseList)) {
            return Maps.newHashMap();
        }
        List<Long> idList = extCaseList.stream().map(extCase -> extCase.getLong("id")).collect(Collectors.toList());
        DynamicObject[] extCases = this.extCaseEntityService.queryExtCaseByIdList(idList);
        HashMap extCaseRangeMap = Maps.newHashMapWithExpectedSize((int)extCases.length);
        Arrays.stream(extCases).forEach(extCase -> {
            boolean currentIsv = extCase.getBoolean("currentisv");
            DynamicObjectCollection entryRangeCollection = extCase.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isNotEmpty((Collection)entryRangeCollection)) {
                entryRangeCollection.forEach(entryRange -> {
                    String modelNumber = Optional.ofNullable(entryRange.getDynamicObject("bizmodel")).map(it -> it.getString("number")).orElse("");
                    String modelType = Optional.ofNullable(entryRange.getString("basedatatype")).orElse("");
                    String extCaseKey = this.getExtCaseKey(modelType, modelNumber, currentIsv);
                    List extCaseIdList = extCaseRangeMap.computeIfAbsent(extCaseKey, split -> Lists.newArrayList());
                    extCaseIdList.add(extCase.getLong("id"));
                });
            }
        });
        return extCaseRangeMap;
    }

    private Map<DynamicObject, DynamicObject> getBizModelExtCaseMap(List<DynamicObject> logicEntityDyList) {
        return logicEntityDyList.stream().collect(Collectors.toMap(it -> it, it -> {
            BizModelDataBean bizModelDataBean = new BizModelDataBean(BizModelTypeEnum.LOGIC_ENTITY, (DynamicObject)it);
            String isv = Optional.ofNullable(it.getString("isv")).orElse("");
            return this.getMatchedExtCase(bizModelDataBean, IsvUtils.isCurrentIsv((String)isv));
        }));
    }

    private Map<DynamicObject, DynamicObject> getBaseDataExtCaseMatch(List<DynamicObject> logicEntityDyList) {
        Map<Object, DynamicObject> originExtCaseMap = this.getAllExtCaseFromCache();
        DynamicObject extCaseDy = this.getExtCaseDy(NORMAL_EXT_FIELD_CASE, originExtCaseMap);
        DynamicObject isvCaseDy = this.getExtCaseDy(ISV_BASE_DATA_CASE, originExtCaseMap);
        HashMap baseDataExtCaseMap = Maps.newHashMapWithExpectedSize((int)logicEntityDyList.size());
        for (DynamicObject dynamicObject : logicEntityDyList) {
            baseDataExtCaseMap.put(dynamicObject, IsvUtils.isNotCurrentIsv((String)dynamicObject.getString("isv")) ? extCaseDy : isvCaseDy);
        }
        return baseDataExtCaseMap;
    }

    private boolean isBaseDataType(String bizObjType) {
        return BASE_DATA_BIZ_OBJ_TYPE_SET.contains(bizObjType);
    }

    private DynamicObject getExtCaseDy(String number, Map<Object, DynamicObject> allExtCaseMap) {
        for (Map.Entry<Object, DynamicObject> entry : allExtCaseMap.entrySet()) {
            DynamicObject dy = entry.getValue();
            if (!number.equals(dy.getString("number"))) continue;
            return dy;
        }
        return null;
    }

    private Map<String, DynamicObject> getAllExtCaseMap(Map<Object, DynamicObject> extCaseDyMap) {
        HashMap allExtCaseMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<Object, DynamicObject> extCase : extCaseDyMap.entrySet()) {
            DynamicObject extCaseDy = extCase.getValue();
            boolean currentIsv = extCaseDy.getBoolean("currentisv");
            DynamicObjectCollection entry = extCaseDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entry) {
                String modelNumber = Optional.ofNullable(dynamicObject.getDynamicObject("bizmodel")).map(it -> it.getString("number")).orElse("");
                String modelType = Optional.ofNullable(dynamicObject.getString("basedatatype")).orElse("");
                allExtCaseMap.put(this.getExtCaseKey(modelType, modelNumber, currentIsv), extCaseDy);
            }
        }
        return allExtCaseMap;
    }

    private Map<Object, DynamicObject> getAllExtCaseFromCache() {
        QFilter qFilter = new QFilter("type", "=", (Object)"10");
        return this.extCaseEntityService.getMapFromCache("casepage,currentisv, entryentity.bizmodel, entryentity.basedatatype,type", qFilter.toArray());
    }

    private String getLogicEntityExtCaseKey(DynamicObject logicEntityDy) {
        String isv = logicEntityDy.getString("isv");
        String modelNumber = Optional.ofNullable(logicEntityDy).map(it -> it.getDynamicObject("bizobj")).map(it -> it.getString("number")).orElse("");
        return this.getExtCaseKey("hrbm_bizobj", modelNumber, IsvUtils.isCurrentIsv((String)isv));
    }

    @Override
    public String getExtCaseKey(String modelType, String modelNumber, boolean currentIsv) {
        return modelType + "|" + modelNumber + "|" + currentIsv;
    }
}

