/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.extcase.impl;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.caserule.CaseRuleHandleFactory;
import kd.hdtc.hrbm.business.domain.caserule.handle.ICaseRuleHandle;
import kd.hdtc.hrbm.business.domain.extcase.IExtCaseManageDomainService;
import kd.hdtc.hrbm.business.domain.extcase.entity.IExtCaseEntityService;
import kd.hdtc.hrbm.business.domain.extcase.entity.IExtCaseManageEntityService;
import kd.hdtc.hrbm.business.domain.task.ITaskRecordDomainService;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hr.hbp.common.util.HRObjectUtils;

public class ExtCaseManageDomainServiceImpl
implements IExtCaseManageDomainService {
    private static final Log LOG = LogFactory.getLog(ExtCaseManageDomainServiceImpl.class);
    private final IExtCaseManageEntityService extCaseManageEntityService = ServiceFactory.createInstance(IExtCaseManageEntityService.class);
    private final IExtCaseEntityService extCaseEntityService = ServiceFactory.createInstance(IExtCaseEntityService.class);
    private final ITaskRecordDomainService taskRecordDomainService = ServiceFactory.createInstance(ITaskRecordDomainService.class);

    @Override
    public Long saveExtCaseManage(DynamicObject bizModel, long extCaseId, long primaryId, Map<String, Object> caseRule) {
        if (HRObjectUtils.isEmpty((Object)bizModel)) {
            LOG.info("ExtCaseManageDomainServiceImpl saveExtCaseManage is failure, the reason is: bizModel is empty");
            return 0L;
        }
        DynamicObject extCase = this.extCaseEntityService.query("number, name", extCaseId);
        if (HRObjectUtils.isEmpty((Object)extCase)) {
            LOG.info("ExtCaseManageDomainServiceImpl saveExtCaseManage is failure, the reason is: extCase is empty");
            return 0L;
        }
        DynamicObject extCaseManage = this.extCaseManageEntityService.queryExtCaseManage(extCaseId, "hrbm_logicentity", bizModel.getLong("id"));
        if (HRObjectUtils.isEmpty((Object)extCaseManage)) {
            extCaseManage = this.extCaseManageEntityService.generateEmptyDynamicObject();
            String number = this.generateNumberOrName(bizModel.getString("number"), extCase.getString("number"));
            String name = this.generateNumberOrName(bizModel.getString("name"), extCase.getString("name"));
            extCaseManage.set("number", (Object)number);
            extCaseManage.set("name", (Object)name);
            extCaseManage.set("extcase", (Object)extCase);
            extCaseManage.set("basedatatype", (Object)"hrbm_logicentity");
            extCaseManage.set("bizmodel", (Object)bizModel.getLong("id"));
            extCaseManage.set("enable", (Object)"1");
            extCaseManage.set("status", (Object)"C");
            extCaseManage.set("creator", (Object)RequestContext.get().getCurrUserId());
            extCaseManage.set("createtime", (Object)new Date());
        }
        extCaseManage.set("cusstatus", (Object)"0");
        extCaseManage.set("caserule", (Object)this.getCaseRule(caseRule, primaryId));
        extCaseManage.set("task", (Object)0L);
        extCaseManage.set("modifier", (Object)RequestContext.get().getCurrUserId());
        extCaseManage.set("modifytime", (Object)new Date());
        this.extCaseManageEntityService.save(extCaseManage);
        return extCaseManage.getLong("id");
    }

    @Override
    public boolean effect(long id) {
        DynamicObject extCaseManageDynamicObject = this.extCaseManageEntityService.queryExtCaseManageById(id);
        if (HRObjectUtils.isEmpty((Object)extCaseManageDynamicObject)) {
            throw new HRDBSBizException("ext case manage is empty, id = " + id);
        }
        ICaseRuleHandle caseRuleHandle = CaseRuleHandleFactory.getCaseRuleHandle(extCaseManageDynamicObject);
        String runParamStr = caseRuleHandle.generateRunParamStr(extCaseManageDynamicObject);
        long taskId = this.taskRecordDomainService.generateTaskRecord(extCaseManageDynamicObject.getLong("id"), runParamStr, caseRuleHandle.getClass().getName());
        this.updateTaskIdInTrans(extCaseManageDynamicObject, taskId);
        return this.taskRecordDomainService.run(taskId);
    }

    private void updateTaskIdInTrans(DynamicObject extCaseManageDynamicObject, long taskId) {
        extCaseManageDynamicObject.set("task", (Object)taskId);
        this.extCaseManageEntityService.save(extCaseManageDynamicObject);
    }

    @Override
    public void updateExtCaseManageTask(Long extCaseManageId, Long TaskId, String cusStatus) {
        DynamicObject extCaseManage = this.extCaseManageEntityService.query("task, cusstatus", extCaseManageId);
        extCaseManage.set("task", (Object)TaskId);
        extCaseManage.set("cusstatus", (Object)cusStatus);
        this.extCaseManageEntityService.save(extCaseManage);
    }

    @Override
    public void effectExtCaseManage(Long extCaseManageId) {
        DynamicObject extCaseManage = this.extCaseManageEntityService.query("cusstatus", extCaseManageId);
        extCaseManage.set("cusstatus", (Object)"1");
        this.extCaseManageEntityService.save(extCaseManage);
    }

    @Override
    public DynamicObject queryExtCaseManage(Long extCaseId, String baseDataType, Long bizModelId) {
        return this.extCaseManageEntityService.queryExtCaseManage(extCaseId, baseDataType, bizModelId);
    }

    private String generateNumberOrName(String bizModelKey, String extCaseKey) {
        StringBuilder builder = new StringBuilder();
        if (extCaseKey == null) {
            extCaseKey = "";
        }
        if (bizModelKey == null) {
            bizModelKey = "";
        }
        builder.append(extCaseKey).append('_').append(bizModelKey);
        return builder.toString();
    }

    private String getCaseRule(Map<String, Object> caseRule, long primaryKey) {
        if (caseRule == null) {
            caseRule = Maps.newHashMapWithExpectedSize((int)4);
        }
        caseRule.put("primaryKey", primaryKey);
        return JsonUtils.toStr((Object)caseRule);
    }
}

