/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.extcase.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.extcase.IExtCaseDomainService;
import kd.hdtc.hrbm.business.domain.extcase.ISceneCardConfigDomainService;
import kd.hdtc.hrbm.business.domain.extcase.bean.SceneCardConfigBean;
import kd.hdtc.hrbm.business.domain.extcase.bean.SceneCardConfigRelFunctionBean;
import kd.hdtc.hrbm.business.domain.extcase.bean.SceneCardConfigUniversalRangeBean;
import kd.hdtc.hrbm.business.domain.extcase.bo.ExtCaseUniversalRangeBo;
import kd.hdtc.hrbm.business.domain.extcase.bo.SceneCardConfigUniversalRangeQueryBo;
import kd.hdtc.hrbm.business.domain.extcase.entity.ISceneCardConfigEntityService;
import kd.hdtc.hrbm.business.domain.model.IAppDomainService;
import kd.hdtc.hrbm.business.domain.model.IBizObjDomainService;
import kd.hdtc.hrbm.business.domain.model.bean.BizModelDataBean;
import kd.hdtc.hrbm.common.enums.BizModelTypeEnum;
import kd.hdtc.hrdbs.business.servicehelper.CacheServiceHelper;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.IsvUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;

public class SceneCardConfigDomainServiceImpl
implements ISceneCardConfigDomainService {
    private static final Log LOG = LogFactory.getLog(SceneCardConfigDomainServiceImpl.class);
    private static final String BIZ_OBJ = "bizobj";
    private final ISceneCardConfigEntityService sceneCardConfigEntityService = ServiceFactory.getService(ISceneCardConfigEntityService.class);
    private final IBizObjDomainService bizObjDomainService = ServiceFactory.getService(IBizObjDomainService.class);
    private final IAppDomainService appDomainService = ServiceFactory.getService(IAppDomainService.class);
    private final IExtCaseDomainService extCaseDomainService = ServiceFactory.getService(IExtCaseDomainService.class);

    @Override
    public List<SceneCardConfigRelFunctionBean> getSceneCardConfigRelFunctionList(Long sceneCardConfigId, BizModelDataBean bizModelDataBean) {
        if (sceneCardConfigId == null) {
            return new ArrayList<SceneCardConfigRelFunctionBean>();
        }
        DynamicObject sceneCardConfig = this.sceneCardConfigEntityService.queryById(sceneCardConfigId);
        if (sceneCardConfig == null) {
            return new ArrayList<SceneCardConfigRelFunctionBean>();
        }
        String cardType = sceneCardConfig.getString("cardtype");
        if ("1010".equals(cardType)) {
            DynamicObjectCollection opEntryEntityCollection = sceneCardConfig.getDynamicObjectCollection("opentryentity");
            ArrayList sceneCardConfigRelFunctionBeanList = Lists.newArrayListWithExpectedSize((int)opEntryEntityCollection.size());
            opEntryEntityCollection.forEach(opEntry -> {
                DynamicObjectCollection relModelCardCollection;
                SceneCardConfigRelFunctionBean sceneCardConfigRelFunctionBean = new SceneCardConfigRelFunctionBean();
                String functionType = opEntry.getString("functiontype");
                sceneCardConfigRelFunctionBean.setFunctionType(functionType);
                if (StringUtils.equals((String)"1010", (String)functionType)) {
                    DynamicObject functionExtCase = opEntry.getDynamicObject("functionextcase");
                    if (functionExtCase != null) {
                        sceneCardConfigRelFunctionBean.setFunctionExtCase(functionExtCase);
                        sceneCardConfigRelFunctionBean.setPageNumber(functionExtCase.getString("casepage"));
                    }
                } else {
                    DynamicObject page = opEntry.getDynamicObject("pageid");
                    if (page != null) {
                        sceneCardConfigRelFunctionBean.setPageNumber(page.getString("number"));
                        sceneCardConfigRelFunctionBean.setPageType(page.getString("modeltype"));
                    }
                }
                if (StringUtils.equals((String)"1040", (String)functionType) && CollectionUtils.isNotEmpty((Collection)(relModelCardCollection = opEntry.getDynamicObjectCollection("relmodelcard")))) {
                    ArrayList relModelCardList = Lists.newArrayListWithExpectedSize((int)relModelCardCollection.size());
                    relModelCardCollection.forEach(relModelCard -> relModelCardList.add(relModelCard));
                    sceneCardConfigRelFunctionBean.setRelModelCardList(relModelCardList);
                }
                sceneCardConfigRelFunctionBean.setId(sceneCardConfig.getLong("id"));
                sceneCardConfigRelFunctionBean.setFunctionName(opEntry.getLocaleString("functionname"));
                sceneCardConfigRelFunctionBean.setRelCardId(opEntry.getLong("relcard.id"));
                sceneCardConfigRelFunctionBean.setRecommendDesc(opEntry.getLocaleString("recommenddesc"));
                sceneCardConfigRelFunctionBean.setParamRule(opEntry.getString("paramrule"));
                sceneCardConfigRelFunctionBeanList.add(sceneCardConfigRelFunctionBean);
            });
            return this.filterSceneCardConfigRelFunctionBeanList(bizModelDataBean, sceneCardConfigRelFunctionBeanList);
        }
        return new ArrayList<SceneCardConfigRelFunctionBean>();
    }

    @Override
    public ExtCaseUniversalRangeBo getExtCaseUniversalRange(Long sceneCardConfigId) {
        if (sceneCardConfigId == null) {
            return null;
        }
        DynamicObject sceneCardConfig = this.sceneCardConfigEntityService.queryById(sceneCardConfigId);
        if (sceneCardConfig == null) {
            return null;
        }
        DynamicObjectCollection containCaseCollection = sceneCardConfig.getDynamicObjectCollection("containcase");
        if (CollectionUtils.isEmpty((Collection)containCaseCollection)) {
            return null;
        }
        List<DynamicObject> extCaseList = containCaseCollection.stream().map(containCase -> containCase.getDynamicObject("fbasedataid")).collect(Collectors.toList());
        return new ExtCaseUniversalRangeBo(extCaseList);
    }

    @Override
    public List<SceneCardConfigBean> getMatchedSceneCardConfigList(Long nodeId, BizModelTypeEnum nodeType, String cardClassify) {
        List<SceneCardConfigUniversalRangeBean> sceneCardConfigUniversalRangeBeanList;
        if (nodeId == null || nodeType == null || StringUtils.isEmpty((String)cardClassify)) {
            return new ArrayList<SceneCardConfigBean>();
        }
        ArrayList sceneCardConfigBeanList = Lists.newArrayListWithExpectedSize((int)10);
        String sceneCardConfigListStr = (String)CacheServiceHelper.getAppCache((String)"hrbm", (String)"HRBM_SCENE_CARD_CONFIG_UNIVERSAL_RANGE", String.class);
        if (StringUtils.isEmpty((String)sceneCardConfigListStr)) {
            DynamicObject[] sceneCardConfigs = this.sceneCardConfigEntityService.queryAllEnableData();
            sceneCardConfigUniversalRangeBeanList = this.buildSceneCardConfigUniversalRange(sceneCardConfigs);
            CacheServiceHelper.putAppCache((String)"hrbm", (String)"HRBM_SCENE_CARD_CONFIG_UNIVERSAL_RANGE", (Object)JSONObject.toJSONString(sceneCardConfigUniversalRangeBeanList));
        } else {
            sceneCardConfigUniversalRangeBeanList = JSONObject.parseArray((String)sceneCardConfigListStr, SceneCardConfigUniversalRangeBean.class);
        }
        sceneCardConfigUniversalRangeBeanList = this.filterSceneCardConfigUniversalRangeBeans(nodeId, nodeType, sceneCardConfigUniversalRangeBeanList);
        List<Long> sceneCardConfigIdList = sceneCardConfigUniversalRangeBeanList.stream().map(SceneCardConfigUniversalRangeBean::getSceneCardConfigId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sceneCardConfigIdList)) {
            return sceneCardConfigBeanList;
        }
        Object[] sceneCardConfigs = this.sceneCardConfigEntityService.queryByIdList(sceneCardConfigIdList);
        if (ArrayUtils.isEmpty((Object[])sceneCardConfigs)) {
            return sceneCardConfigBeanList;
        }
        return Stream.of(sceneCardConfigs).map(this::getSceneCardConfigBean).filter(bean -> bean.getCardClassify().equals(cardClassify)).sorted(Comparator.comparingInt(SceneCardConfigBean::getIndex)).collect(Collectors.toList());
    }

    @Override
    public List<SceneCardConfigUniversalRangeBean> buildSceneCardConfigUniversalRange(DynamicObject[] sceneCardConfigs) {
        if (ArrayUtils.isEmpty((Object[])sceneCardConfigs)) {
            return new ArrayList<SceneCardConfigUniversalRangeBean>();
        }
        HashMap idAndSccurbMap = Maps.newHashMapWithExpectedSize((int)sceneCardConfigs.length);
        ArrayList sccurqbList = Lists.newArrayListWithExpectedSize((int)sceneCardConfigs.length);
        Stream.of(sceneCardConfigs).forEach(sceneCardConfig -> {
            SceneCardConfigUniversalRangeBean sccurb = new SceneCardConfigUniversalRangeBean(sceneCardConfig.getLong("id"));
            idAndSccurbMap.put(sccurb.getSceneCardConfigId(), sccurb);
            SceneCardConfigUniversalRangeQueryBo sccurqb = new SceneCardConfigUniversalRangeQueryBo(sceneCardConfig.getLong("id"));
            sccurqbList.add(sccurqb);
            DynamicObjectCollection universalRangeCollection = sceneCardConfig.getDynamicObjectCollection("bdentryentity");
            universalRangeCollection.forEach(dy -> this.parseUniversalRange(sccurb, sccurqb, (DynamicObject)dy));
        });
        return this.querySceneCardConfigUniversalRangeBeanList(idAndSccurbMap, sccurqbList);
    }

    @Override
    public Map<String, List<DynamicObject>> getAllMulMainCardMap() {
        Object[] allMulMainCardDatas = this.sceneCardConfigEntityService.queryAllMulMainCardData();
        if (HRArrayUtils.isEmpty((Object[])allMulMainCardDatas)) {
            return Maps.newHashMap();
        }
        HashMap allMulMainCardMap = Maps.newHashMapWithExpectedSize((int)allMulMainCardDatas.length);
        for (Object mainCardData : allMulMainCardDatas) {
            DynamicObjectCollection containCaseCollection;
            DynamicObjectCollection dataRangeCollection = mainCardData.getDynamicObjectCollection("bdentryentity");
            if (CollectionUtils.isEmpty((Collection)dataRangeCollection) || CollectionUtils.isEmpty((Collection)(containCaseCollection = mainCardData.getDynamicObjectCollection("containcase")))) continue;
            List<DynamicObject> extCaseList = containCaseCollection.stream().map(containCase -> containCase.getDynamicObject("fbasedataid")).collect(Collectors.toList());
            this.buildAllMulMainCardMap((DynamicObject)mainCardData, dataRangeCollection, extCaseList, allMulMainCardMap);
        }
        return allMulMainCardMap;
    }

    @Override
    public DynamicObject getMainCardFromBizObj(DynamicObject logicEntityDy, Long bizObjId) {
        String mainCardKey;
        if (logicEntityDy == null || bizObjId == null || bizObjId == 0L) {
            return null;
        }
        BizModelDataBean bizModelDataBean = new BizModelDataBean(BizModelTypeEnum.LOGIC_ENTITY, logicEntityDy);
        String isv = logicEntityDy.getString("isv");
        DynamicObject matchedExtCase = this.extCaseDomainService.getMatchedExtCase(bizModelDataBean, IsvUtils.isCurrentIsv((String)isv));
        Map<String, List<DynamicObject>> allMulMainCardMap = this.getAllMulMainCardMap();
        if (CollectionUtils.isNotEmpty((Collection)allMulMainCardMap.get(mainCardKey = this.getMainCardKey("hrbm_bizobj", bizObjId, BIZ_OBJ, matchedExtCase)))) {
            return allMulMainCardMap.get(mainCardKey).get(0);
        }
        DynamicObject bizObjInfo = this.bizObjDomainService.getBizObjInfoById(bizObjId);
        mainCardKey = this.getMainCardKey("hrbm_app", bizObjInfo.getLong("app.id"), BIZ_OBJ, matchedExtCase);
        if (CollectionUtils.isNotEmpty((Collection)allMulMainCardMap.get(mainCardKey))) {
            return allMulMainCardMap.get(mainCardKey).get(0);
        }
        mainCardKey = this.getMainCardKey("hrbm_cloud", bizObjInfo.getLong("app.cloud.id"), BIZ_OBJ, matchedExtCase);
        if (CollectionUtils.isNotEmpty((Collection)allMulMainCardMap.get(mainCardKey))) {
            return allMulMainCardMap.get(mainCardKey).get(0);
        }
        return null;
    }

    private void buildAllMulMainCardMap(DynamicObject mainCardData, DynamicObjectCollection dataRangeCollection, List<DynamicObject> extCaseList, Map<String, List<DynamicObject>> allMulMainCardMap) {
        dataRangeCollection.forEach(dataRange -> extCaseList.forEach(extCase -> {
            String bizModelType = dataRange.getString("bizmodeltype");
            Long bizModelId = dataRange.getLong("bizmodel.id");
            String cardActLevel = dataRange.getString("cardactlevel");
            String key = this.getMainCardKey(bizModelType, bizModelId, cardActLevel, (DynamicObject)extCase);
            List mulMainCardList = allMulMainCardMap.computeIfAbsent(key, split -> Lists.newArrayList());
            mulMainCardList.add(mainCardData);
        }));
    }

    private List<SceneCardConfigRelFunctionBean> filterSceneCardConfigRelFunctionBeanList(BizModelDataBean bizModelDataBean, List<SceneCardConfigRelFunctionBean> sceneCardConfigRelFunctionBeanList) {
        if (CollectionUtils.isEmpty(sceneCardConfigRelFunctionBeanList)) {
            return sceneCardConfigRelFunctionBeanList;
        }
        List<DynamicObject> extCaseList = sceneCardConfigRelFunctionBeanList.stream().filter(sceneCardConfigRelFunctionBean -> sceneCardConfigRelFunctionBean.getFunctionExtCase() != null).map(SceneCardConfigRelFunctionBean::getFunctionExtCase).collect(Collectors.toList());
        Map<String, List<Long>> extCaseRangeToMap = this.extCaseDomainService.transferExtCaseRangeToMap(extCaseList);
        return sceneCardConfigRelFunctionBeanList.stream().filter(sceneCardConfigRelFunctionBean -> {
            DynamicObject functionExtCase = sceneCardConfigRelFunctionBean.getFunctionExtCase();
            if (functionExtCase == null) {
                return true;
            }
            DynamicObjectCollection extCaseRangeCollection = functionExtCase.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)extCaseRangeCollection)) {
                return true;
            }
            return this.isContainExtCase(bizModelDataBean, functionExtCase, extCaseRangeToMap);
        }).collect(Collectors.toList());
    }

    private boolean isContainExtCase(BizModelDataBean bizModelDataBean, DynamicObject functionExtCase, Map<String, List<Long>> extCaseRangeToMap) {
        if (BizModelTypeEnum.LOGIC_ENTITY == bizModelDataBean.getBizModelType()) {
            DynamicObject bizModel = bizModelDataBean.getBizModel();
            boolean currentIsv = IsvUtils.isCurrentIsv((String)bizModel.getString("isv"));
            String extCaseKey = this.extCaseDomainService.getExtCaseKey(bizModelDataBean.getBizModelType().getType(), bizModel.getString("number"), currentIsv);
            LOG.info("bizModelAllLineLog about SceneCardConfigDomainServiceImpl.isContainExtCase():logicentity extCaseKey:{}", (Object)extCaseKey);
            List<Long> extCaseIdList = extCaseRangeToMap.get(extCaseKey);
            if (CollectionUtils.isNotEmpty(extCaseIdList) && extCaseIdList.contains(functionExtCase.getLong("id"))) {
                return true;
            }
            DynamicObject pLogicEntity = bizModel.getDynamicObject("pid");
            if (HRObjectUtils.isEmpty((Object)pLogicEntity)) {
                return false;
            }
            extCaseKey = this.extCaseDomainService.getExtCaseKey(bizModelDataBean.getBizModelType().getType(), pLogicEntity.getString("number"), currentIsv);
            LOG.info("bizModelAllLineLog about SceneCardConfigDomainServiceImpl.isContainExtCase():pid extCaseKey:{}", (Object)extCaseKey);
            extCaseIdList = extCaseRangeToMap.get(extCaseKey);
            return CollectionUtils.isNotEmpty(extCaseIdList) && extCaseIdList.contains(functionExtCase.getLong("id"));
        }
        return true;
    }

    private String getMainCardKey(String bizModelType, Long bizModelId, String cardActLevel, DynamicObject extCase) {
        return bizModelType + "." + bizModelId + "." + cardActLevel + "." + extCase.getLong("id");
    }

    private List<SceneCardConfigUniversalRangeBean> querySceneCardConfigUniversalRangeBeanList(Map<Long, SceneCardConfigUniversalRangeBean> idAndSccurbMap, List<SceneCardConfigUniversalRangeQueryBo> sccurqbList) {
        HashSet needQueryBizObjOfCloudIdSet = Sets.newHashSetWithExpectedSize((int)16);
        sccurqbList.forEach(dy -> needQueryBizObjOfCloudIdSet.addAll(dy.getNeedQueryBizObjOfCloudIdList()));
        List<DynamicObject> appInfoList = this.appDomainService.getAppInfoListByCloudId(needQueryBizObjOfCloudIdSet);
        appInfoList.forEach(appInfo -> {
            long appId = appInfo.getLong("id");
            long cloudId = appInfo.getDynamicObject("cloud") != null ? appInfo.getDynamicObject("cloud").getLong("id") : 0L;
            sccurqbList.forEach(sccurqb -> {
                if (sccurqb.getNeedQueryBizObjOfCloudIdList().contains(cloudId)) {
                    sccurqb.getNeedQueryBizObjOfAppIdList().add(appId);
                }
            });
        });
        HashSet cloudIdSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet appIdSet = Sets.newHashSetWithExpectedSize((int)16);
        sccurqbList.forEach(dy -> {
            cloudIdSet.addAll(dy.getNeedQueryAppOfCloudIdList());
            appIdSet.addAll(dy.getNeedQueryBizObjOfAppIdList());
        });
        appInfoList = this.appDomainService.getAppInfoListByCloudId(cloudIdSet);
        appInfoList.forEach(appInfo -> {
            long appId = appInfo.getLong("id");
            long cloudId = appInfo.getDynamicObject("cloud") != null ? appInfo.getDynamicObject("cloud").getLong("id") : 0L;
            sccurqbList.forEach(sccurqb -> {
                if (sccurqb.getNeedQueryAppOfCloudIdList().contains(cloudId)) {
                    sccurqb.getResultBizAppIdSet().add(appId);
                }
            });
        });
        List<DynamicObject> bizObjList = this.bizObjDomainService.getBizObjInfoByAppIds(appIdSet);
        bizObjList.forEach(bizObj -> {
            long bizObjId = bizObj.getLong("id");
            long appId = bizObj.getDynamicObject("app") != null ? bizObj.getDynamicObject("app").getLong("id") : 0L;
            sccurqbList.forEach(sccurqb -> {
                if (sccurqb.getNeedQueryBizObjOfAppIdList().contains(appId)) {
                    sccurqb.getResultBizObjIdSet().add(bizObjId);
                }
            });
        });
        sccurqbList.forEach(sccurqb -> {
            SceneCardConfigUniversalRangeBean sceneCardConfigUniversalRangeBean = (SceneCardConfigUniversalRangeBean)idAndSccurbMap.get(sccurqb.getSceneCardConfigId());
            if (sceneCardConfigUniversalRangeBean != null) {
                sceneCardConfigUniversalRangeBean.getBizAppIdSet().addAll(sccurqb.getResultBizAppIdSet());
                sceneCardConfigUniversalRangeBean.getBizObjIdSet().addAll(sccurqb.getResultBizObjIdSet());
            }
        });
        return new ArrayList<SceneCardConfigUniversalRangeBean>(idAndSccurbMap.values());
    }

    private void parseUniversalRange(SceneCardConfigUniversalRangeBean sccurb, SceneCardConfigUniversalRangeQueryBo sccurqb, DynamicObject dy) {
        String bizModelType = dy.getString("bizmodeltype");
        String cardActLevel = dy.getString("cardactlevel");
        DynamicObject bizModel = dy.getDynamicObject("bizmodel");
        if (bizModel == null) {
            return;
        }
        switch (bizModelType) {
            case "hrbm_cloud": {
                if ("cloud".equals(cardActLevel)) {
                    sccurb.getBizCloudIdSet().add(bizModel.getLong("id"));
                    break;
                }
                if ("app".equals(cardActLevel)) {
                    sccurqb.getNeedQueryAppOfCloudIdList().add(bizModel.getLong("id"));
                    break;
                }
                sccurqb.getNeedQueryBizObjOfCloudIdList().add(bizModel.getLong("id"));
                break;
            }
            case "hrbm_app": {
                if ("app".equals(cardActLevel)) {
                    sccurb.getBizAppIdSet().add(bizModel.getLong("id"));
                    break;
                }
                sccurqb.getNeedQueryBizObjOfAppIdList().add(bizModel.getLong("id"));
                break;
            }
            case "hrbm_bizobj": {
                sccurb.getBizObjIdSet().add(bizModel.getLong("id"));
                break;
            }
        }
    }

    private List<SceneCardConfigUniversalRangeBean> filterSceneCardConfigUniversalRangeBeans(Long nodeId, BizModelTypeEnum nodeType, List<SceneCardConfigUniversalRangeBean> sceneCardConfigUniversalRangeBeanList) {
        sceneCardConfigUniversalRangeBeanList = nodeType == BizModelTypeEnum.CLOUD ? sceneCardConfigUniversalRangeBeanList.stream().filter(dy -> dy.getBizCloudIdSet().contains(nodeId)).collect(Collectors.toList()) : (nodeType == BizModelTypeEnum.APP ? sceneCardConfigUniversalRangeBeanList.stream().filter(dy -> dy.getBizAppIdSet().contains(nodeId)).collect(Collectors.toList()) : (nodeType == BizModelTypeEnum.BIZ_OBJ ? sceneCardConfigUniversalRangeBeanList.stream().filter(dy -> dy.getBizObjIdSet().contains(nodeId)).collect(Collectors.toList()) : new ArrayList<SceneCardConfigUniversalRangeBean>()));
        return sceneCardConfigUniversalRangeBeanList;
    }

    private SceneCardConfigBean getSceneCardConfigBean(DynamicObject sceneCardConfig) {
        SceneCardConfigBean sceneCardConfigBean = new SceneCardConfigBean();
        sceneCardConfigBean.setId(sceneCardConfig.getString("id"));
        sceneCardConfigBean.setCurrentName(sceneCardConfig.getString("name"));
        sceneCardConfigBean.setNumber(sceneCardConfig.getString("number"));
        sceneCardConfigBean.setCardClassify(sceneCardConfig.getString("cardclassify"));
        sceneCardConfigBean.setCurrentDescription(sceneCardConfig.getString("description"));
        sceneCardConfigBean.setIndex(sceneCardConfig.getInt("index"));
        sceneCardConfigBean.setCardJumpType(sceneCardConfig.getString("cardjumptype"));
        sceneCardConfigBean.setNeedLogicEntity(sceneCardConfig.getBoolean("needlogicentity"));
        return sceneCardConfigBean;
    }
}

