/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.extcase.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.extcase.SharedTaskPoolDomainService;
import kd.hdtc.hrbm.business.domain.extcase.entity.SharedTaskPoolEntityService;
import kd.hdtc.hrbm.common.constant.SharedTaskPoolConstants;
import kd.hdtc.hrbm.common.msgEnum.SharedTaskPoolEnum;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IMetadataEntityService;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.DesignMetadataParser;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseEntityService;
import kd.hdtc.hrdbs.common.pojo.query.QueryEntity;
import kd.hdtc.hrdbs.common.pojo.query.QueryField;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenParam;
import kd.hdtc.hrdbs.common.pojo.query.QueryList;
import kd.hdtc.hrdbs.common.pojo.query.RelationCondition;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class SharedTaskPoolDomainServiceImpl
implements SharedTaskPoolDomainService {
    private static final Log LOG = LogFactory.getLog(SharedTaskPoolDomainServiceImpl.class);
    private static final String MENU_ID = "413WWOJAHM45";
    private static final String OPERATIONS = "Operations";
    private static final String PERMISSION_ITEMS = "PermissionItems";
    private static final String QUERY_PERM_CODE = "QXX0001";
    SharedTaskPoolEntityService sharedTaskPoolEntityService = ServiceFactory.getService(SharedTaskPoolEntityService.class);
    IMetadataEntityService metadataEntityService = (IMetadataEntityService)kd.hdtc.hrdbs.business.common.ServiceFactory.getService(IMetadataEntityService.class);
    private final IBaseEntityService queryTaskPoolEntityService = CommonEntityServiceFactory.getEntityService((String)"task_querylistpool");
    private final IBaseEntityService bosFormMetaEntityService = CommonEntityServiceFactory.getEntityService((String)"bos_formmeta");
    private final IBaseEntityService bosEntityObjectEntityService = CommonEntityServiceFactory.getEntityService((String)"bos_entityobject");
    private final IBaseEntityService permrelatEntityService = CommonEntityServiceFactory.getEntityService((String)"hrcs_permrelat");
    private final IBaseEntityService appEntityService = CommonEntityServiceFactory.getEntityService((String)"bos_devportal_bizapp");
    private static final String SELECT_FIELD = "id,name,number,enable,sourcebill,description,processquerylistname,processquerylist,finishquerylistname,finishquerylist,isv";

    @Override
    public DynamicObject queryTaskPoolById(Object pkId) {
        return this.sharedTaskPoolEntityService.queryOne(SELECT_FIELD, pkId);
    }

    @Override
    public List<String> getAllShareTaskNumbers() {
        Object[] result = this.sharedTaskPoolEntityService.query("processqueryconf,finishqueryconf,processquerylist,finishquerylist", null);
        if (ObjectUtils.isEmpty((Object[])result)) {
            return new ArrayList<String>();
        }
        ArrayList numberList = Lists.newArrayListWithCapacity((int)(result.length * 4));
        Arrays.stream(result).forEach(task -> {
            numberList.add(task.getString("processqueryconf"));
            numberList.add(task.getString("processquerylist"));
            numberList.add(task.getString("finishqueryconf"));
            numberList.add(task.getString("finishquerylist"));
        });
        numberList.remove("");
        return numberList;
    }

    @Override
    public Map<String, String> jsonStr2Map(String fieldStr) {
        if (HRStringUtils.isEmpty((String)fieldStr)) {
            return new HashMap<String, String>();
        }
        Map taskSupportFieldMap = (Map)JSONObject.parseObject((String)fieldStr, (TypeReference)new TypeReference<LinkedHashMap<String, String>>(){}, (Feature[])new Feature[0]);
        return taskSupportFieldMap;
    }

    @Override
    public QueryGenParam buildGenParamForFinish(DynamicObject taskPool) {
        DynamicObjectCollection finishEntryEntity = taskPool.getDynamicObjectCollection("finishentryentity");
        QueryGenParam queryGenParam = new QueryGenParam();
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)"hstc");
        queryGenParam.setAppId(appId);
        queryGenParam.setNumber(taskPool.getString("finishqueryconf"));
        queryGenParam.setName(taskPool.getLocaleString("finishqueryconfname").getLocaleValue());
        queryGenParam.setMainEntity(this.buildMainEntity("task_taskhistory"));
        queryGenParam.setQueryList(this.buildQueryListForFinish(taskPool));
        queryGenParam.setUnit(MENU_ID);
        queryGenParam.setSubQueryEntityList(this.buildSubQueryEntityList(taskPool));
        queryGenParam.setQueryFieldList(this.buildQueryFieldList(queryGenParam, finishEntryEntity, "finish"));
        List<Map<String, Object>> editParamList = this.buildOps(this.metadataEntityService.getDesignMetadata("hstc_sscbasedatafinish"));
        queryGenParam.setEntityOperationList((List)editParamList.get(0).get(OPERATIONS));
        queryGenParam.setPermissionItemsList((List)editParamList.get(0).get(PERMISSION_ITEMS));
        return queryGenParam;
    }

    @Override
    public QueryGenParam buildGenParamForProcess(DynamicObject taskPool) {
        DynamicObjectCollection processEntryEntity = taskPool.getDynamicObjectCollection("processentryentity");
        QueryGenParam queryGenParam = new QueryGenParam();
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)"hstc");
        queryGenParam.setAppId(appId);
        queryGenParam.setNumber(taskPool.getString("processqueryconf"));
        queryGenParam.setName(taskPool.getLocaleString("processqueryconfname").getLocaleValue());
        queryGenParam.setMainEntity(this.buildMainEntity("task_task"));
        queryGenParam.setQueryList(this.buildQueryListForProcess(taskPool));
        queryGenParam.setUnit(MENU_ID);
        queryGenParam.setSubQueryEntityList(this.buildSubQueryEntityList(taskPool));
        queryGenParam.setQueryFieldList(this.buildQueryFieldList(queryGenParam, processEntryEntity, "process"));
        List<Map<String, Object>> editParamList = this.buildOps(this.metadataEntityService.getDesignMetadata("hstc_sscbasedataprocess"));
        queryGenParam.setEntityOperationList((List)editParamList.get(0).get(OPERATIONS));
        queryGenParam.setPermissionItemsList((List)editParamList.get(0).get(PERMISSION_ITEMS));
        return queryGenParam;
    }

    @Override
    public boolean syncCustomTaskPool(DynamicObject taskPool) {
        long pkId = taskPool.getLong("id");
        DynamicObject hrTaskPool = this.queryTaskPoolEntityService.queryOne("id,name", (Object)pkId);
        if (!ObjectUtils.isEmpty((Object)hrTaskPool)) {
            hrTaskPool.set("name", (Object)taskPool.getLocaleString("name"));
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"task_querylistpool", (DynamicObject[])new DynamicObject[]{hrTaskPool}, (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                LOG.info("syncCustomTaskPool update,error info:{}", (Object)operationResult.getMessage());
                return false;
            }
            return true;
        }
        DynamicObject newTaskPool = this.queryTaskPoolEntityService.generateEmptyDynamicObject();
        newTaskPool.set("id", (Object)pkId);
        newTaskPool.set("number", (Object)taskPool.getString("number"));
        newTaskPool.set("name", (Object)taskPool.getLocaleString("name"));
        newTaskPool.set("status", (Object)taskPool.getString("status"));
        newTaskPool.set("enable", (Object)taskPool.getString("enable"));
        String processQueryListNumber = taskPool.getString("processquerylist");
        String finishQueryListNumber = taskPool.getString("finishquerylist");
        DynamicObject sourceBill = taskPool.getDynamicObject("sourcebill");
        if (ObjectUtils.isEmpty((Object)sourceBill)) {
            LOG.info("syncCustomTaskPool,the sourceBill is empty");
            return false;
        }
        ImmutableList queryNumberList = ImmutableList.of((Object)processQueryListNumber, (Object)finishQueryListNumber, (Object)sourceBill.getString("id"));
        DynamicObject[] querListArr = this.bosFormMetaEntityService.query("id,number", new QFilter("number", "in", (Object)queryNumberList).toArray());
        Arrays.stream(querListArr).forEach(query -> {
            String number = query.getString("number");
            if (HRStringUtils.equals((String)processQueryListNumber, (String)number)) {
                newTaskPool.set("querylist", query);
            } else if (HRStringUtils.equals((String)finishQueryListNumber, (String)number)) {
                newTaskPool.set("querylisth", query);
            } else {
                newTaskPool.set("bill", query);
            }
        });
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"task_querylistpool", (DynamicObject[])new DynamicObject[]{newTaskPool}, (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            LOG.info("syncCustomTaskPool save,error info:{}", (Object)operationResult.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void deleteTaskPoolById(Object id) {
        this.sharedTaskPoolEntityService.delete(id);
    }

    @Override
    public List<DynamicObject> getTaskPoolByIds(Set<Long> idSet) {
        Object[] result = this.sharedTaskPoolEntityService.query("id,enable", new QFilter("id", "in", idSet).toArray());
        if (ObjectUtils.isEmpty((Object[])result)) {
            return new ArrayList<DynamicObject>();
        }
        return ConvertUtils.toList((Object[])result);
    }

    @Override
    public void generatepermRel(DynamicObject taskPool) {
        QFilter entityQFilter = new QFilter("entitytype", "in", (Object)SharedTaskPoolConstants.ENTITY_TAG_LIST);
        QFilter permQFilter = new QFilter("mainpermitem", "=", (Object)QUERY_PERM_CODE);
        HashMap mainEntiyMappingMap = Maps.newHashMapWithExpectedSize((int)16);
        mainEntiyMappingMap.put("task_task", taskPool.getString("processqueryconf"));
        mainEntiyMappingMap.put("task_taskhistory", taskPool.getString("finishqueryconf"));
        Object[] permArr = this.permrelatEntityService.query("id,entitytype,mainpermitem,entryentity", entityQFilter.and(permQFilter).toArray());
        if (ObjectUtils.isEmpty((Object[])permArr)) {
            return;
        }
        Arrays.stream(permArr).forEach(perm -> {
            DynamicObject entityTypeDyn = perm.getDynamicObject("entitytype");
            if (!ObjectUtils.isEmpty((Object)entityTypeDyn)) {
                DynamicObjectCollection entryEntity = perm.getDynamicObjectCollection("entryentity");
                String entityType = entityTypeDyn.getString("id");
                String queryListStr = (String)mainEntiyMappingMap.get(entityType);
                String queryListId = MetadataDao.getIdByNumber((String)queryListStr, (MetaCategory)MetaCategory.Form);
                DynamicObject newRow = entryEntity.addNew();
                newRow.set("entitytypeid", (Object)this.bosEntityObjectEntityService.queryOne("id", (Object)queryListStr));
                newRow.set("app", (Object)this.appEntityService.queryOne("id", (Object)MetadataDao.readRuntimeMeta((String)queryListId, (MetaCategory)MetaCategory.Form).getBizappId()));
                newRow.set("permitemid", (Object)QUERY_PERM_CODE);
                newRow.set("permitem", (Object)QUERY_PERM_CODE);
            }
        });
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"hrcs_permrelat", (DynamicObject[])permArr, (OperateOption)OperateOption.create());
        ValidateResultCollection validateResult = operationResult.getValidateResult();
        validateResult.isSuccess();
    }

    private List<QueryField> buildQueryFieldList(QueryGenParam queryGenParam, DynamicObjectCollection entryEntity, String fieldSuffix) {
        ArrayList fieldList = Lists.newArrayList();
        QueryEntity mainEntity = queryGenParam.getMainEntity();
        String mainEntityNumber = mainEntity.getNumber();
        QueryEntity sonEntity = (QueryEntity)queryGenParam.getSubQueryEntityList().get(0);
        String sonEntityNumber = sonEntity.getNumber();
        entryEntity.forEach(row -> {
            String entityNumber = row.getString("entitynumber" + fieldSuffix);
            if (HRStringUtils.equals((String)entityNumber, (String)mainEntityNumber)) {
                fieldList.add(this.structQueryField((DynamicObject)row, mainEntity, fieldSuffix));
            } else if (HRStringUtils.equals((String)entityNumber, (String)sonEntityNumber)) {
                fieldList.add(this.structQueryField((DynamicObject)row, sonEntity, fieldSuffix));
            }
        });
        return fieldList;
    }

    private QueryField structQueryField(DynamicObject row, QueryEntity queryEntity, String fieldSuffix) {
        String fieldNumber = row.getString("fieldnumber" + fieldSuffix);
        String fieldName = row.getString("fieldname" + fieldSuffix);
        String sharedTaskListName = row.getString("sharedtasklistname" + fieldSuffix);
        boolean filter = row.getBoolean("filter" + fieldSuffix);
        boolean hide = row.getBoolean("hide" + fieldSuffix);
        QueryField queryField = new QueryField();
        queryField.setFieldName(HRStringUtils.isEmpty((String)sharedTaskListName) ? fieldName : sharedTaskListName);
        queryField.setFieldNumber(fieldNumber.substring(fieldNumber.indexOf(".") + 1));
        queryField.setNormalQueryFilter(filter);
        queryField.setVisible(!hide);
        queryField.setTableHeaderFilter(true);
        queryField.setSchemaFilter(true);
        if (HRStringUtils.equals((String)fieldSuffix, (String)"process")) {
            if (HRStringUtils.equals((String)fieldNumber, (String)"task_task.subject")) {
                queryField.setFastFilter(true);
                queryField.setHyperLink(true);
            }
        } else if (HRStringUtils.equals((String)fieldNumber, (String)"task_taskhistory.subject")) {
            queryField.setFastFilter(true);
            queryField.setHyperLink(true);
        }
        queryField.setQueryEntity(queryEntity);
        return queryField;
    }

    private List<Map<String, Object>> buildOps(Map<String, Object> sourceMetaData) {
        DesignMetadataParser sourceDesignMetadataParser = new DesignMetadataParser(sourceMetaData);
        List editParamList = sourceDesignMetadataParser.getEntityMetadata();
        return editParamList;
    }

    private List<QueryEntity> buildSubQueryEntityList(DynamicObject taskPool) {
        DynamicObject sourceBill = taskPool.getDynamicObject("sourcebill");
        QueryEntity queryEntity = new QueryEntity();
        queryEntity.setNumber(sourceBill.getString("number"));
        queryEntity.setName(sourceBill.getLocaleString("name").getLocaleValue());
        queryEntity.setAlias(sourceBill.getString("number"));
        queryEntity.setRelationConditionList(this.buildConditionList(sourceBill));
        return Lists.newArrayList((Object[])new QueryEntity[]{queryEntity});
    }

    private List<RelationCondition> buildConditionList(DynamicObject sourceBill) {
        RelationCondition relationCondition = new RelationCondition();
        relationCondition.setMainEntityProp("billlongid");
        relationCondition.setMainEntityPropName(SharedTaskPoolEnum.BILL_ID.get());
        String sonBillNumber = sourceBill.getString("number") + "." + "id";
        relationCondition.setSubEntityProp(sonBillNumber);
        String sonBillName = sourceBill.getLocaleString("name").getLocaleValue() + "." + "Fid" + '(' + sonBillNumber + ')';
        relationCondition.setSubEntityPropName(sonBillName);
        return Lists.newArrayList((Object[])new RelationCondition[]{relationCondition});
    }

    private QueryList buildQueryListForProcess(DynamicObject taskPool) {
        QueryList queryList = new QueryList();
        queryList.setGenerateSeq(true);
        queryList.setListName(taskPool.getLocaleString("processquerylistname").getLocaleValue());
        queryList.setListNumber(taskPool.getString("processquerylist"));
        queryList.setRelQueryListNumber("hstc_sscbdprocess_ql");
        return queryList;
    }

    private QueryList buildQueryListForFinish(DynamicObject taskPool) {
        QueryList queryList = new QueryList();
        queryList.setGenerateSeq(true);
        queryList.setListName(taskPool.getLocaleString("finishquerylistname").getLocaleValue());
        queryList.setListNumber(taskPool.getString("finishquerylist"));
        queryList.setRelQueryListNumber("hstc_sscbdfinish_ql");
        return queryList;
    }

    private QueryEntity buildMainEntity(String mainEntityNumber) {
        QueryEntity queryEntity = new QueryEntity();
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)mainEntityNumber);
        queryEntity.setNumber(mainEntityType.getName());
        queryEntity.setName(mainEntityType.getDisplayName().getLocaleValue());
        queryEntity.setAlias(mainEntityType.getName());
        return queryEntity;
    }
}

