/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.extcase.parser;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrbm.business.domain.extcase.bo.ParserParam;
import kd.hdtc.hrbm.business.domain.extcase.bo.QueryEntityBo;
import kd.hdtc.hrbm.business.domain.extcase.bo.QueryFieldBo;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;

public class QueryEntityParser {
    private static final Log LOG = LogFactory.getLog(QueryEntityParser.class);
    private List<QueryEntityBo> queryEntityBoList = Lists.newArrayListWithExpectedSize((int)10);
    private List<QueryFieldBo> queryFieldBoList = Lists.newArrayListWithExpectedSize((int)10);
    Map<String, List<TreeNode>> entityNumberAndFieldTreeNodeListMap = Maps.newHashMapWithExpectedSize((int)10);

    public List<QueryEntityBo> getQueryEntityBoList() {
        return this.queryEntityBoList;
    }

    public QueryEntityParser(String mainEntityNumber, String sonEntityNumber) {
        this.queryEntityBoList.add(this.structEntityBo(mainEntityNumber, true));
        this.queryEntityBoList.add(this.structEntityBo(sonEntityNumber, false));
        this.getQueryFieldList();
    }

    public QueryEntityParser(String mainEntityNumber) {
        this.queryEntityBoList.add(this.structEntityBo(mainEntityNumber, true));
        this.getQueryFieldList();
    }

    private QueryEntityBo structEntityBo(String entityNumber, Boolean isMainEntity) {
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        QueryEntityBo queryEntityBo = new QueryEntityBo();
        queryEntityBo.setEntityNumber(entityNumber);
        queryEntityBo.setMainEntity(isMainEntity);
        queryEntityBo.setEntityName(mainEntityType.getDisplayName().getLocaleValue());
        return queryEntityBo;
    }

    private void getQueryFieldList() {
        LinkedHashMap entityNumberAndFieldTreeNodeListMap = Maps.newLinkedHashMapWithExpectedSize((int)this.queryEntityBoList.size());
        for (QueryEntityBo queryEntityBo : this.queryEntityBoList) {
            Map allEntities;
            List fieldNumberList = MetadataUtils.getFieldNumberList((String)queryEntityBo.getEntityNumber());
            MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)queryEntityBo.getEntityNumber());
            if (mainEntityType instanceof QueryEntityType || CollectionUtils.isEmpty((Map)(allEntities = mainEntityType.getAllEntities()))) continue;
            ArrayList fieldTreeNodeList = Lists.newArrayListWithExpectedSize((int)10);
            allEntities.forEach((entryKey, entityType) -> {
                if (entityType instanceof EntryType) {
                    return;
                }
                List<TreeNode> treeNodeList = this.buildQueryFieldInfoList(queryEntityBo, fieldNumberList, (EntityType)entityType);
                fieldTreeNodeList.addAll(treeNodeList);
            });
            entityNumberAndFieldTreeNodeListMap.put(queryEntityBo.getEntityNumber(), fieldTreeNodeList);
            this.entityNumberAndFieldTreeNodeListMap = entityNumberAndFieldTreeNodeListMap;
        }
    }

    private TreeNode buildFieldTreeNode(String parentId, QueryFieldBo queryFieldBo) {
        TreeNode treeNode = new TreeNode(parentId, queryFieldBo.getFullFieldNumber(), queryFieldBo.getFieldName());
        treeNode.setIsOpened(false);
        return treeNode;
    }

    private List<TreeNode> buildQueryFieldInfoList(QueryEntityBo queryEntityBo, List<String> fieldNumberList, EntityType entityType) {
        Map fields = entityType.getFields();
        ArrayList fieldTreeNodeList = Lists.newArrayListWithExpectedSize((int)fields.size());
        for (Map.Entry entry : fields.entrySet()) {
            if (StringUtils.isEmpty((String)((IDataEntityProperty)entry.getValue()).getAlias()) || entry.getValue() instanceof MulBasedataProp) continue;
            if (entry.getValue() instanceof BasedataProp) {
                TreeNode baseDataFieldTreeNode = this.getBaseDataFieldTreeNode(new ParserParam(queryEntityBo), (IDataEntityProperty)entry.getValue(), true);
                baseDataFieldTreeNode.setIsOpened(false);
                fieldTreeNodeList.add(baseDataFieldTreeNode);
                continue;
            }
            ParserParam parserParam = new ParserParam(queryEntityBo);
            if (!fieldNumberList.contains(entry.getKey()) || !StringUtils.isNotEmpty((String)((IDataEntityProperty)entry.getValue()).getAlias())) continue;
            QueryFieldBo queryFieldBo = this.getQueryFieldModel((IDataEntityProperty)entry.getValue());
            if (queryFieldBo != null) {
                queryFieldBo.setEntityNumber(parserParam.getEntityNumber());
                queryFieldBo.setEntityName(parserParam.getEntityName());
                queryFieldBo.setFullFieldNumber(parserParam.getFullFieldNumberPrefix() + (String)entry.getKey());
                queryFieldBo.setFullFieldName(parserParam.getFullFieldNamePrefix() + ((IDataEntityProperty)entry.getValue()).getDisplayName().getLocaleValue());
                queryFieldBo.setQueryFieldNumber(parserParam.getQueryFieldNumberPrefix() + (String)entry.getKey());
                TreeNode treeNode = this.buildFieldTreeNode(parserParam.getEntityNumber(), queryFieldBo);
                fieldTreeNodeList.add(treeNode);
                this.queryFieldBoList.add(queryFieldBo);
                continue;
            }
            LOG.info("entityNumber:{},fieldNumber:{} is not DisplayName", (Object)parserParam.getEntityNumber(), (Object)((IDataEntityProperty)entry.getValue()).getName());
        }
        return fieldTreeNodeList;
    }

    private TreeNode getBaseDataFieldTreeNode(ParserParam parserParam, IDataEntityProperty baseDataProperty, boolean buildBasedata) {
        TreeNode treeNode = new TreeNode(parserParam.getEntityNumber(), parserParam.getFullFieldNumberPrefix() + baseDataProperty.getName(), baseDataProperty.getDisplayName().getLocaleValue());
        treeNode.setIsOpened(true);
        QueryFieldBo queryField = this.buildBaseDataQueryFieldModel(parserParam, baseDataProperty);
        this.queryFieldBoList.add(queryField);
        Map fields = ((MainEntityType)this.getBaseComplexType(baseDataProperty)).getFields();
        boolean mulBaseData = this.isMulBaseData(baseDataProperty);
        String fullFieldName = parserParam.getFullFieldNamePrefix() + baseDataProperty.getDisplayName().getLocaleValue() + ".";
        String fullFieldNumber = parserParam.getFullFieldNumberPrefix() + baseDataProperty.getName() + ".";
        String queryFieldNumber = parserParam.getQueryFieldNumberPrefix() + baseDataProperty.getName() + ".";
        ArrayList childNodes = Lists.newArrayListWithExpectedSize((int)fields.size());
        fields.forEach((fieldNumber, propType) -> {
            if (propType instanceof BasedataProp && buildBasedata) {
                parserParam.setFullFieldNamePrefix(fullFieldName);
                parserParam.setFullFieldNumberPrefix(fullFieldNumber);
                parserParam.setQueryFieldNumberPrefix(queryFieldNumber);
                TreeNode baseDataFieldTreeNode = this.getBaseDataFieldTreeNode(parserParam, (IDataEntityProperty)propType, false);
                childNodes.add(baseDataFieldTreeNode);
            } else {
                QueryFieldBo queryFieldBo = this.getQueryFieldModel((IDataEntityProperty)propType);
                if (queryFieldBo != null) {
                    this.setQueryFieldModelType(mulBaseData, queryFieldBo);
                    queryFieldBo.setEntityNumber(parserParam.getEntityNumber());
                    queryFieldBo.setEntityName(parserParam.getEntityName());
                    queryFieldBo.setFullFieldNumber(fullFieldNumber + propType.getName());
                    queryFieldBo.setFullFieldName(fullFieldName + propType.getDisplayName().getLocaleValue());
                    queryFieldBo.setQueryFieldNumber(queryFieldNumber + propType.getName());
                    queryFieldBo.setBaseEntityName(queryField.getBaseEntityName());
                    queryFieldBo.setBelongComplexFieldType(queryField.getFieldType());
                    queryFieldBo.setBelongQueryField(propType.getName());
                    TreeNode fieldTreeNode = this.buildFieldTreeNode(treeNode.getId(), queryFieldBo);
                    childNodes.add(fieldTreeNode);
                    this.queryFieldBoList.add(queryFieldBo);
                } else {
                    LOG.info("entityNumber:{},baseDataFieldNumber:{},fieldNumber:{} is not DisplayName or not table field ", new Object[]{parserParam.getEntityNumber(), baseDataProperty.getName(), propType.getName()});
                }
            }
        });
        treeNode.setChildren((List)childNodes);
        return treeNode;
    }

    private IDataEntityType getBaseComplexType(IDataEntityProperty baseDataProperty) {
        if (baseDataProperty instanceof BasedataProp) {
            return ((BasedataProp)baseDataProperty).getComplexType();
        }
        return ((MulBasedataProp)baseDataProperty).getComplexType();
    }

    private void setQueryFieldModelType(boolean isMulBaseData, QueryFieldBo queryFieldBo) {
        if (isMulBaseData) {
            queryFieldBo.setFieldType(TextProp.class.getSimpleName());
        }
    }

    private boolean isMulBaseData(IDataEntityProperty baseDataProperty) {
        return baseDataProperty instanceof MulBasedataProp;
    }

    private QueryFieldBo buildBaseDataQueryFieldModel(ParserParam parserParam, IDataEntityProperty baseDataProperty) {
        QueryFieldBo queryField = new QueryFieldBo();
        queryField.setFieldName(baseDataProperty.getDisplayName().getLocaleValue());
        queryField.setFieldNumber(baseDataProperty.getName());
        queryField.setComplexType(true);
        if (baseDataProperty instanceof BasedataProp) {
            queryField.setFieldType("BasedataProp");
            queryField.setBaseEntityName(((BasedataProp)baseDataProperty).getBaseEntityId());
        } else {
            queryField.setFieldType("MulBasedataProp");
            queryField.setBaseEntityName(((MulBasedataProp)baseDataProperty).getBaseEntityId());
        }
        queryField.setEntityNumber(parserParam.getEntityNumber());
        queryField.setEntityName(parserParam.getEntityName());
        queryField.setFullFieldNumber(parserParam.getFullFieldNumberPrefix() + baseDataProperty.getName());
        queryField.setFullFieldName(parserParam.getFullFieldNamePrefix() + baseDataProperty.getDisplayName().getLocaleValue());
        queryField.setQueryFieldNumber(parserParam.getQueryFieldNumberPrefix() + baseDataProperty.getName());
        return queryField;
    }

    private QueryFieldBo getQueryFieldModel(IDataEntityProperty property) {
        if (StringUtils.isEmpty((String)property.getAlias())) {
            return null;
        }
        if (property.getDisplayName() == null) {
            LOG.info("fieldNumber:{} is not DisplayName", (Object)property.getName());
            return null;
        }
        QueryFieldBo queryField = new QueryFieldBo();
        String fieldType = "";
        if (property instanceof LongProp) {
            fieldType = LongProp.class.getSimpleName();
        }
        if (property instanceof IntegerProp) {
            fieldType = IntegerProp.class.getSimpleName();
        } else if (property instanceof DecimalProp) {
            fieldType = DecimalProp.class.getSimpleName();
        } else if (property instanceof DateProp) {
            fieldType = DateProp.class.getSimpleName();
        } else if (property instanceof BooleanProp) {
            fieldType = BooleanProp.class.getSimpleName();
        } else if (property instanceof ComboProp) {
            fieldType = ComboProp.class.getSimpleName();
            ArrayList comboItemList = Lists.newArrayListWithExpectedSize((int)((ComboProp)property).getComboItems().size());
            ((ComboProp)property).getComboItems().forEach(item -> {
                JSONObject comboItem = new JSONObject();
                comboItem.put("name", (Object)item.getName());
                comboItem.put("value", (Object)item.getValue());
                comboItemList.add(comboItem);
            });
            queryField.setComboItemList(comboItemList);
        } else if (property instanceof TextProp) {
            fieldType = TextProp.class.getSimpleName();
        } else if (property instanceof DateTimeProp) {
            fieldType = DateTimeProp.class.getSimpleName();
        } else if (property instanceof PictureProp) {
            fieldType = PictureProp.class.getSimpleName();
        }
        queryField.setFieldType(fieldType);
        if (property.getDisplayName() != null) {
            queryField.setFieldName(property.getDisplayName().getLocaleValue());
        } else {
            queryField.setFieldName("no_name");
        }
        queryField.setFieldNumber(property.getName());
        queryField.setComplexType(false);
        return queryField;
    }

    public List<QueryFieldBo> getQueryFieldBoList() {
        return this.queryFieldBoList;
    }

    public Map<String, List<TreeNode>> getEntityNumberAndFieldTreeNodeListMap() {
        return this.entityNumberAndFieldTreeNodeListMap;
    }
}

