/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.extcase.wtc.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.common.util.SplitNumberUtil;
import kd.hdtc.hrbm.business.domain.extcase.bean.WtcFormulaConfigSyncBean;
import kd.hdtc.hrbm.business.domain.extcase.bean.WtcFormulaConfigSyncFilterBean;
import kd.hdtc.hrbm.business.domain.extcase.bean.WtcFormulaConfigSyncSortBean;
import kd.hdtc.hrbm.business.domain.extcase.entity.wtc.IRetrievalGroupEntityService;
import kd.hdtc.hrbm.business.domain.extcase.entity.wtc.IRetrievalRuleEntityService;
import kd.hdtc.hrbm.business.domain.extcase.entity.wtc.IWtcFormulaConfigEntityService;
import kd.hdtc.hrbm.business.domain.extcase.wtc.IWtcFormulaConfigDomainService;
import kd.hdtc.hrbm.business.domain.model.entity.IPropEntityService;
import kd.hdtc.hrbm.common.enums.OrderEnum;
import kd.hdtc.hrbm.common.enums.hr.HrPiPersonClassifyEnum;
import kd.hdtc.hrbm.common.enums.hr.HrPiPersonHisTypeEnum;
import kd.hdtc.hrbm.common.enums.wtc.AffiliationParamsEnum;
import kd.hdtc.hrbm.common.enums.wtc.ConfigCompareValueTypeEnum;
import kd.hdtc.hrbm.common.enums.wtc.PersonParamsEnum;
import kd.hdtc.hrbm.common.enums.wtc.RuleOperatorEnum;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseEntityService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.HDTCArrayUtils;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class WtcFormulaConfigDomainServiceImpl
implements IWtcFormulaConfigDomainService {
    private static final Log LOG = LogFactory.getLog(WtcFormulaConfigDomainServiceImpl.class);
    private IRetrievalGroupEntityService retrievalGroupEntityService = ServiceFactory.getService(IRetrievalGroupEntityService.class);
    private IRetrievalRuleEntityService retrievalRuleEntityService = ServiceFactory.getService(IRetrievalRuleEntityService.class);
    private IWtcFormulaConfigEntityService wtcFormulaConfigEntityService = ServiceFactory.getService(IWtcFormulaConfigEntityService.class);
    private IPropEntityService propEntityService = ServiceFactory.getService(IPropEntityService.class);
    private static final String CONFIG_SELECT_COLS = "id,number,prop,alias,wtcfmlgroup,wtcfmlrule,cusstatus";
    private static final String RETRIEVAL_BUSINESS_MODEL_SERVICE = "IRetrievalBusinessModelService";
    private static final String QUERY_RETRIEVAL_GROUP = "queryRetrievalGroup";
    private static final String QUERY_RETRIEVAL_RULE = "queryRetrievalRule";
    private static final String VALIDATE_ITEM_EXIST = "validateItemExist";
    private static final String QUERY_RETRIEVAL_GRAYSCALE_STATUS = "queryRetrievalGrayscaleStatus";
    private static final String ADD_RETRIEVAL_BUSINESS_MODEL = "addRetrievalBusinessModel";
    private static final String PROP_SELECT_FIELD = "id,name,number,fieldtype,must,bizrule,fieldconfig,proptype,propkey,coreprop,cusstatus,index,modifier,isv,description,proplabelmul,deleted,bizrule,table,multilang,tablefield,unique,metadata,logicentity,logicentity.extmetanum,primary,extend";
    private static final String HR_PI_PERSON_ENTITY_SELECT_FIELD = "entity,classify,historytype";
    private final IBaseEntityService hrPiPersonEntityService = CommonEntityServiceFactory.getEntityService((String)"hrpi_personentityconf");
    private static final String BASE_DATA_FIELD_TYPE = "BasedataField";
    private static final String MUL_BASE_DATA_FIELD_TYPE = "MulBasedataField";
    private static final String DESC_STR = "createtime asc";
    private static final String HRPI_PERSON = "hrpi_person";
    private static final String HRPI_EMPLOYEE = "hrpi_employee";
    private static final String HRPI_CMPEMP = "hrpi_cmpemp";
    private static final String HRPI_DEPEMP = "hrpi_depemp";
    public static final DecimalFormat df = new DecimalFormat("0000");

    @Override
    public DynamicObject[] getWtcFormulaConfigDataArr(Boolean isGetAllData) {
        QFilter selectQFilter = new QFilter("1", "=", (Object)1);
        if (!isGetAllData.booleanValue()) {
            selectQFilter.and(new QFilter("cusstatus", "=", (Object)"1"));
        }
        DynamicObject[] dys = this.wtcFormulaConfigEntityService.query(CONFIG_SELECT_COLS, new QFilter[]{selectQFilter}, DESC_STR);
        return dys;
    }

    @Override
    public List<DynamicObject> saveWtcFormulaConfigData(DynamicObjectCollection entityList) {
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return null;
        }
        List validList = entityList.stream().filter(data -> !StringUtils.equals((String)data.getString("cusstatus"), (String)"1")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(validList)) {
            return null;
        }
        ArrayList saveList = Lists.newArrayListWithExpectedSize((int)validList.size());
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                this.wtcFormulaConfigEntityService.deleteByFilter(new QFilter[]{new QFilter("cusstatus", "!=", (Object)"1")});
                validList.stream().forEach(data -> {
                    DynamicObject formulaConfig = this.wtcFormulaConfigEntityService.generateEmptyDynamicObject();
                    formulaConfig.set("number", data.get("number"));
                    formulaConfig.set("prop", data.get("prop"));
                    formulaConfig.set("alias", data.get("alias"));
                    formulaConfig.set("wtcfmlgroup", data.get("wtcfmlgroup"));
                    formulaConfig.set("wtcfmlrule", data.get("wtcfmlrule"));
                    formulaConfig.set("cusstatus", data.get("cusstatus"));
                    formulaConfig.set("status", (Object)"C");
                    formulaConfig.set("enable", (Object)"1");
                    saveList.add(formulaConfig);
                });
                this.wtcFormulaConfigEntityService.save(saveList.toArray(new DynamicObject[0]));
            }
            catch (Exception ex) {
                txHandle.markRollback();
                LOG.error("saveWtcFormulaConfigData error" + ex);
            }
        }
        return saveList;
    }

    @Override
    public String syncToWtcFormulaConfig(List<DynamicObject> configList, DynamicObjectCollection entityList) {
        String msg;
        if (CollectionUtils.isEmpty(configList)) {
            return null;
        }
        ArrayList beanList = Lists.newArrayListWithExpectedSize((int)configList.size());
        List propIdList = configList.stream().map(data -> data.getLong("prop.id")).collect(Collectors.toList());
        DynamicObject[] allPropArr = this.propEntityService.query(PROP_SELECT_FIELD, propIdList.toArray());
        Map<Long, DynamicObject> propMap = Arrays.stream(allPropArr).collect(Collectors.toMap(data -> data.getLong("id"), dy -> dy, (d1, d2) -> d2));
        configList.stream().forEach(configDy -> {
            Long propId = configDy.getLong("prop.id");
            DynamicObject propDetail = (DynamicObject)propMap.get(propId);
            if (propDetail == null) {
                return;
            }
            WtcFormulaConfigSyncBean wtcFormulaConfigSyncBean = new WtcFormulaConfigSyncBean();
            this.dealParam(propDetail, (DynamicObject)configDy, wtcFormulaConfigSyncBean);
            beanList.add(wtcFormulaConfigSyncBean);
        });
        for (WtcFormulaConfigSyncBean wtcFormulaConfigSyncBean2 : beanList) {
            boolean isExist = entityList.stream().anyMatch(item -> HRStringUtils.equals((String)wtcFormulaConfigSyncBean2.getItemCode(), (String)item.getString("number")));
            boolean isExist2 = beanList.stream().anyMatch(item -> wtcFormulaConfigSyncBean2 != item && HRStringUtils.equals((String)wtcFormulaConfigSyncBean2.getItemCode(), (String)item.getItemCode()));
            if (!isExist && !isExist2) continue;
            String itemCode = wtcFormulaConfigSyncBean2.getItemCode();
            itemCode = itemCode + "_" + df.format(new SecureRandom().nextInt(10000));
            wtcFormulaConfigSyncBean2.setItemCode(itemCode);
        }
        List numberList = beanList.stream().map(WtcFormulaConfigSyncBean::getFetchSource).collect(Collectors.toList());
        Object[] personEntityArr = this.hrPiPersonEntityService.query(HR_PI_PERSON_ENTITY_SELECT_FIELD, new QFilter[]{new QFilter("entity", "in", numberList)});
        Map<String, DynamicObject> numberDyMap = Arrays.stream(personEntityArr).collect(Collectors.toMap(data -> data.getString("entity"), dy -> dy, (v1, v2) -> v2));
        ArrayList syncBeanList = Lists.newArrayListWithExpectedSize((int)beanList.size());
        if (HDTCArrayUtils.isNotEmpty((Object[])personEntityArr)) {
            beanList.stream().forEach(wtcFormulaConfigSyncBean -> {
                String metaNumber = wtcFormulaConfigSyncBean.getFetchSource();
                DynamicObject personEntity = (DynamicObject)numberDyMap.get(metaNumber);
                if (personEntity == null) {
                    return;
                }
                String hisType = personEntity.getString("historytype");
                this.buildHisTypeCondition((WtcFormulaConfigSyncBean)wtcFormulaConfigSyncBean, hisType);
                String classify = personEntity.getString("classify");
                this.buildPersonClassifyCondition((WtcFormulaConfigSyncBean)wtcFormulaConfigSyncBean, classify, metaNumber);
                syncBeanList.add(wtcFormulaConfigSyncBean);
            });
        }
        if (StringUtils.isNotEmpty((String)(msg = this.retrievalBusinessModelService(syncBeanList)))) {
            return msg;
        }
        this.validConfigData(syncBeanList);
        return null;
    }

    private void dealParam(DynamicObject propDetail, DynamicObject configDy, WtcFormulaConfigSyncBean wtcFormulaConfigSyncBean) {
        wtcFormulaConfigSyncBean.setBizConfigId(configDy.getLong("id"));
        wtcFormulaConfigSyncBean.setItemName(configDy.getLocaleString("alias"));
        wtcFormulaConfigSyncBean.setItemParentId(configDy.getLong("wtcfmlgroup.id"));
        wtcFormulaConfigSyncBean.setSceneRuleId(configDy.getLong("wtcfmlrule.id"));
        String propKey = propDetail.getString("propkey");
        String propNumber = propDetail.getString("number");
        if (propNumber.indexOf(".") > 0) {
            String[] metaNumbers = propNumber.split("\\.", 2);
            String metaNumber = metaNumbers[0];
            wtcFormulaConfigSyncBean.setFieldId(propKey);
            wtcFormulaConfigSyncBean.setFetchSource(metaNumber);
            StringBuilder fieldId = new StringBuilder(metaNumbers[1]);
            if (StringUtils.equals((String)propDetail.getString("fieldtype"), (String)BASE_DATA_FIELD_TYPE) || StringUtils.equals((String)propDetail.getString("fieldtype"), (String)MUL_BASE_DATA_FIELD_TYPE)) {
                fieldId.append(".");
                fieldId.append("id");
            }
            wtcFormulaConfigSyncBean.setFieldId(fieldId.toString());
        }
        String itemCodeFull = wtcFormulaConfigSyncBean.getFetchSource() + "_" + wtcFormulaConfigSyncBean.getFieldId();
        itemCodeFull = itemCodeFull.replace(".", "_");
        String itemCode = SplitNumberUtil.getSplitNumber(itemCodeFull, 45);
        wtcFormulaConfigSyncBean.setItemCode(itemCode);
    }

    private void validConfigData(List<WtcFormulaConfigSyncBean> syncBeanList) {
        Map<Long, WtcFormulaConfigSyncBean> syncMap = syncBeanList.stream().collect(Collectors.toMap(WtcFormulaConfigSyncBean::getBizConfigId, bean -> bean, (v1, v2) -> v2));
        DynamicObject[] configSyncDataArr = this.wtcFormulaConfigEntityService.query("cusstatus", new QFilter[]{new QFilter("id", "in", syncMap.keySet())});
        Arrays.stream(configSyncDataArr).forEach(data -> {
            data.set("cusstatus", (Object)"1");
            WtcFormulaConfigSyncBean bean = (WtcFormulaConfigSyncBean)syncMap.get(data.getLong("id"));
            if (bean != null) {
                data.set("number", (Object)bean.getItemCode());
            }
        });
        this.wtcFormulaConfigEntityService.save(configSyncDataArr);
    }

    private String retrievalBusinessModelService(List<WtcFormulaConfigSyncBean> beanList) {
        ArrayList mapList = Lists.newArrayListWithExpectedSize((int)beanList.size());
        beanList.stream().forEach(bean -> mapList.add(JsonUtils.convertJSONObjectToMap((Object)bean)));
        LOG.info("syncToWtcFormulaConfig  IRetrievalBusinessModelService addRetrievalBusinessModel start size:{}", (Object)mapList.size());
        Map returnMsg = (Map)HRMServiceHelper.invokeBizService((String)"wtc", (String)"wtbd", (String)RETRIEVAL_BUSINESS_MODEL_SERVICE, (String)ADD_RETRIEVAL_BUSINESS_MODEL, (Object[])new Object[]{mapList});
        String status = String.valueOf(returnMsg.get("status"));
        String msg = (String)returnMsg.get("msg");
        LOG.info("syncToWtcFormulaConfig  IRetrievalBusinessModelService addRetrievalBusinessModel end status:{} msg:{}  ", (Object)status, (Object)msg);
        if (!StringUtils.equals((String)status, (String)"1")) {
            return msg;
        }
        return null;
    }

    private void buildHisTypeCondition(WtcFormulaConfigSyncBean bean, String type) {
        HrPiPersonHisTypeEnum hisType;
        List<WtcFormulaConfigSyncFilterBean> filterList = bean.getRetrievalBusinessModelFilterInfoList();
        if (filterList == null) {
            filterList = new ArrayList<WtcFormulaConfigSyncFilterBean>(10);
        }
        if ((hisType = HrPiPersonHisTypeEnum.getHisTypeByNumber((String)type)) == null) {
            return;
        }
        filterList.add(new WtcFormulaConfigSyncFilterBean("initstatus", RuleOperatorEnum.EQUAL.getValue(), ConfigCompareValueTypeEnum.THREE.getValueType(), "2"));
        if (hisType == HrPiPersonHisTypeEnum.TIME) {
            filterList.add(new WtcFormulaConfigSyncFilterBean("bsed", RuleOperatorEnum.LESS_OR_EQUAL.getValue(), ConfigCompareValueTypeEnum.TWO.getValueType(), AffiliationParamsEnum.PARAM_AFFILIATION.getCode()));
            filterList.add(new WtcFormulaConfigSyncFilterBean("bsled", RuleOperatorEnum.GREATER_OR_EQUAL.getValue(), ConfigCompareValueTypeEnum.TWO.getValueType(), AffiliationParamsEnum.PARAM_AFFILIATION.getCode()));
            ImmutableList dataStatusList = ImmutableList.of((Object)"0", (Object)"1", (Object)"2");
            filterList.add(new WtcFormulaConfigSyncFilterBean("datastatus", RuleOperatorEnum.IN.getValue(), ConfigCompareValueTypeEnum.THREE.getValueType(), Joiner.on((String)";").join((Iterable)dataStatusList)));
        } else if (hisType == HrPiPersonHisTypeEnum.NON_TIME) {
            filterList.add(new WtcFormulaConfigSyncFilterBean("datastatus", RuleOperatorEnum.EQUAL.getValue(), ConfigCompareValueTypeEnum.THREE.getValueType(), "1"));
            filterList.add(new WtcFormulaConfigSyncFilterBean("iscurrentversion", RuleOperatorEnum.EQUAL.getValue(), ConfigCompareValueTypeEnum.THREE.getValueType(), "1"));
            List<WtcFormulaConfigSyncSortBean> sortList = bean.getRetrievalBusinessModelSortedInfoList();
            if (sortList == null) {
                sortList = new ArrayList<WtcFormulaConfigSyncSortBean>(10);
            }
            sortList.add(new WtcFormulaConfigSyncSortBean("modifytime", OrderEnum.DESC.getName()));
            bean.setRetrievalBusinessModelSortedInfoList(sortList);
        }
        bean.setRetrievalBusinessModelFilterInfoList(filterList);
    }

    private void buildPersonClassifyCondition(WtcFormulaConfigSyncBean bean, String classify, String metaNumber) {
        HrPiPersonClassifyEnum personClassify;
        List<WtcFormulaConfigSyncFilterBean> filterList = bean.getRetrievalBusinessModelFilterInfoList();
        if (filterList == null) {
            filterList = new ArrayList<WtcFormulaConfigSyncFilterBean>(10);
        }
        if ((personClassify = HrPiPersonClassifyEnum.getPersonClassifyByNumber((String)classify)) == null) {
            return;
        }
        if (personClassify == HrPiPersonClassifyEnum.PERSON_MODEL && HRPI_PERSON.equals(metaNumber)) {
            filterList.add(new WtcFormulaConfigSyncFilterBean("boid", RuleOperatorEnum.EQUAL.getValue(), ConfigCompareValueTypeEnum.ONE.getValueType(), PersonParamsEnum.PARAM_PERSON.getCode()));
        } else if (personClassify == HrPiPersonClassifyEnum.PER_ATTACHED) {
            filterList.add(new WtcFormulaConfigSyncFilterBean("person.id", RuleOperatorEnum.EQUAL.getValue(), ConfigCompareValueTypeEnum.ONE.getValueType(), PersonParamsEnum.PARAM_PERSON.getCode()));
        } else if (personClassify == HrPiPersonClassifyEnum.PERSON_MODEL && HRPI_EMPLOYEE.equals(metaNumber)) {
            filterList.add(new WtcFormulaConfigSyncFilterBean("boid", RuleOperatorEnum.EQUAL.getValue(), ConfigCompareValueTypeEnum.ONE.getValueType(), PersonParamsEnum.PARAM_EMPLOYEE.getCode()));
        } else if (personClassify == HrPiPersonClassifyEnum.PERSON_MODEL && HRPI_CMPEMP.equals(metaNumber) || personClassify == HrPiPersonClassifyEnum.EMP_ATTACHED) {
            filterList.add(new WtcFormulaConfigSyncFilterBean("employee.id", RuleOperatorEnum.EQUAL.getValue(), ConfigCompareValueTypeEnum.ONE.getValueType(), PersonParamsEnum.PARAM_EMPLOYEE.getCode()));
        } else if (personClassify == HrPiPersonClassifyEnum.PERSON_MODEL && HRPI_DEPEMP.equals(metaNumber)) {
            filterList.add(new WtcFormulaConfigSyncFilterBean("boid", RuleOperatorEnum.EQUAL.getValue(), ConfigCompareValueTypeEnum.ONE.getValueType(), PersonParamsEnum.PARAM_ORG_PERSON.getCode()));
        } else if (personClassify == HrPiPersonClassifyEnum.DEP_EMP_ATTACHED) {
            filterList.add(new WtcFormulaConfigSyncFilterBean("depemp.id", RuleOperatorEnum.EQUAL.getValue(), ConfigCompareValueTypeEnum.ONE.getValueType(), PersonParamsEnum.PARAM_ORG_PERSON.getCode()));
        }
        bean.setRetrievalBusinessModelFilterInfoList(filterList);
    }

    @Override
    public boolean getAndRefreshRetrievalGroup() {
        boolean result = true;
        try {
            List groupList = (List)HRMServiceHelper.invokeBizService((String)"wtc", (String)"wtbd", (String)RETRIEVAL_BUSINESS_MODEL_SERVICE, (String)QUERY_RETRIEVAL_GROUP, null);
            if (CollectionUtils.isNotEmpty((Collection)groupList)) {
                List idList = groupList.stream().map(data -> (Long)data.get("id")).collect(Collectors.toList());
                this.retrievalGroupEntityService.delete(idList.toArray());
                ArrayList retrievalGroupDbList = Lists.newArrayListWithExpectedSize((int)groupList.size());
                groupList.stream().forEach(data -> {
                    DynamicObject retrievalGroupEntity = this.retrievalGroupEntityService.generateEmptyDynamicObject();
                    retrievalGroupEntity.set("id", data.get("id"));
                    retrievalGroupEntity.set("number", data.get("number"));
                    retrievalGroupEntity.set("name", data.get("name"));
                    retrievalGroupEntity.set("status", (Object)"C");
                    retrievalGroupEntity.set("enable", (Object)"1");
                    retrievalGroupDbList.add(retrievalGroupEntity);
                });
                this.retrievalGroupEntityService.save(retrievalGroupDbList.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception ex) {
            LOG.error("getAndRefreshRetrievalGroup error", (Throwable)ex);
            result = false;
        }
        return result;
    }

    @Override
    public boolean getAndRefreshRetrievalRule() {
        boolean result = true;
        try {
            List groupList = (List)HRMServiceHelper.invokeBizService((String)"wtc", (String)"wtbd", (String)RETRIEVAL_BUSINESS_MODEL_SERVICE, (String)QUERY_RETRIEVAL_RULE, null);
            if (CollectionUtils.isNotEmpty((Collection)groupList)) {
                List idList = groupList.stream().map(data -> (Long)data.get("id")).collect(Collectors.toList());
                this.retrievalRuleEntityService.delete(idList.toArray());
                ArrayList retrievalRuleDbList = Lists.newArrayListWithExpectedSize((int)groupList.size());
                groupList.stream().forEach(data -> {
                    DynamicObject retrievalRuleEntity = this.retrievalRuleEntityService.generateEmptyDynamicObject();
                    retrievalRuleEntity.set("id", data.get("id"));
                    retrievalRuleEntity.set("number", data.get("number"));
                    retrievalRuleEntity.set("name", data.get("name"));
                    retrievalRuleEntity.set("status", (Object)"C");
                    retrievalRuleEntity.set("enable", (Object)"1");
                    retrievalRuleDbList.add(retrievalRuleEntity);
                });
                this.retrievalRuleEntityService.save(retrievalRuleDbList.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception ex) {
            LOG.error("getAndRefreshRetrievalRule error", (Throwable)ex);
            result = false;
        }
        return result;
    }

    @Override
    public boolean validateItemExist(String number) {
        try {
            boolean exist = (Boolean)HRMServiceHelper.invokeBizService((String)"wtc", (String)"wtbd", (String)RETRIEVAL_BUSINESS_MODEL_SERVICE, (String)VALIDATE_ITEM_EXIST, (Object[])new Object[]{number});
            return exist;
        }
        catch (Exception ex) {
            LOG.error("validateItemExist error", (Throwable)ex);
            return true;
        }
    }

    @Override
    public void deleteEntryRowEntity(long id) {
        if (id != 0L) {
            this.wtcFormulaConfigEntityService.deleteByFilter(new QFilter[]{new QFilter("id", "=", (Object)id)});
        }
    }

    @Override
    public Boolean isRetrievalOpen() {
        try {
            Map map = (Map)HRMServiceHelper.invokeBizService((String)"wtc", (String)"wtbd", (String)RETRIEVAL_BUSINESS_MODEL_SERVICE, (String)QUERY_RETRIEVAL_GRAYSCALE_STATUS, null);
            if (map != null) {
                return (Boolean)map.get("grayscaleStatus");
            }
            return false;
        }
        catch (Exception ex) {
            LOG.error("isRetrievalOpen error", (Throwable)ex);
            return false;
        }
    }
}

