/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.file.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hdtc.hrbm.business.domain.file.IFilePackageDomainService;

public class FilePackageDomainServiceImpl
implements IFilePackageDomainService {
    private static final Log LOG = LogFactory.getLog(FilePackageDomainServiceImpl.class);
    private static final byte[] BUF = new byte[1024];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compress(List<String> filePaths, String zipFileName, IFormView view) {
        if (CollectionUtils.isEmpty(filePaths)) {
            return false;
        }
        LOG.info("FilePackageDomainServiceImpl compress  filePaths:, {}", filePaths);
        LOG.info("FilePackageDomainServiceImpl compress  zipFileName:, {}", (Object)zipFileName);
        File zipFile = new File(zipFileName);
        boolean crateNewFile = true;
        if (!zipFile.exists()) {
            try {
                crateNewFile = zipFile.createNewFile();
            }
            catch (IOException e) {
                crateNewFile = false;
                LOG.error("FilePackageDomainServiceImpl compress ERROR create zipFile Error,  zipFileName, {}", (Object)zipFileName);
            }
        }
        if (!crateNewFile) {
            return false;
        }
        ZipOutputStream zos = null;
        InputStream input = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(zipFile));
            for (String filePath : filePaths) {
                this.addFileToZip(zos, filePath);
            }
            zos.close();
            input = new FileInputStream(zipFile);
            String resultPath = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(zipFile.getPath(), input, 5000);
            view.openUrl(resultPath);
            if (zipFile.delete()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            LOG.error("FilePackageDomainServiceImpl compress ERROR, \u6253\u5305\u62a5\u9519, {}", (Object)e.getMessage());
            LOG.error("FilePackageDomainServiceImpl compress ERROR, filePaths, {}", filePaths);
            boolean bl = false;
            return bl;
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    LOG.error("zos close IOException:", (Object)e.getMessage());
                }
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    LOG.error("input close IOException:", (Object)e.getMessage());
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileToZip(ZipOutputStream zos, String fullPath) {
        LOG.info("FilePackageDomainServiceImpl addFileToZip INFO, fullPath\uff1a{}", (Object)fullPath);
        if (zos == null) {
            return;
        }
        File sourceFile = new File(fullPath = this.translatePath(fullPath));
        if (!sourceFile.exists()) {
            return;
        }
        FileInputStream fis = null;
        try {
            int len;
            zos.putNextEntry(new ZipEntry(fullPath));
            fis = new FileInputStream(sourceFile);
            while ((len = fis.read(BUF)) > 0) {
                zos.write(BUF, 0, len);
            }
            if (sourceFile.delete()) {
                return;
            }
        }
        catch (IOException e) {
            LOG.error("FilePackageDomainServiceImpl  addFileToZip error fullPath{} :", (Object)fullPath, (Object)e.getMessage());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                zos.closeEntry();
            }
            catch (IOException e) {
                LOG.error("FilePackageDomainServiceImpl  addFileToZip close fis error :", (Object)e.getMessage());
            }
        }
    }

    private String translatePath(String path) {
        return path.replace('\\', '/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createFileByString(String content, String filePath) {
        FileOutputStream os = null;
        OutputStreamWriter writer = null;
        try {
            filePath = this.translatePath(filePath);
            File file = new File(filePath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            os = new FileOutputStream(file);
            writer = new OutputStreamWriter((OutputStream)os, "utf-8");
            writer.write(content);
            String string = file.getPath();
            return string;
        }
        catch (Exception e) {
            LOG.error("FilePackageDomainServiceImpl creatFileByString ERROR, \u751f\u6210\u6587\u4ef6\u62a5\u9519, {}", (Object)e.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOG.error("writer close IOException:", (Object)e.getMessage());
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    LOG.error("os close IOException:", (Object)e.getMessage());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPresetPath(String content, String filePath) {
        FileOutputStream os = null;
        OutputStreamWriter writer = null;
        InputStream input = null;
        String presetPath = "";
        File file = null;
        try {
            filePath = this.translatePath(filePath);
            file = new File(filePath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            os = new FileOutputStream(file);
            input = new FileInputStream(file);
            writer = new OutputStreamWriter((OutputStream)os, "utf-8");
            writer.write(content);
        }
        catch (Exception e) {
            LOG.error("FilePackageDomainServiceImpl creatFileByString ERROR, \u751f\u6210\u6587\u4ef6\u62a5\u9519, {}", (Object)e.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOG.error("writer close IOException:" + e.getMessage());
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    LOG.error("os close IOException:" + e.getMessage());
                }
            }
            if (file != null) {
                presetPath = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(file.getPath(), input, 5000);
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    LOG.error("input close IOException:" + e.getMessage());
                }
            }
        }
        return presetPath;
    }
}

