/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.model.bo;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.tree.TreeNode;
import kd.hdtc.hrdbs.common.util.CollectionUtils;

public class LeftTreeNodeBo {
    private Set<DynamicObject> cloudSet;
    private Map<String, List<DynamicObject>> cloudAppMap;
    private Map<String, List<DynamicObject>> appBizMap;

    public LeftTreeNodeBo(DynamicObject[] cloudDyList, DynamicObject[] appDyList, DynamicObject[] bizObjDyList) {
        this.cloudSet = Arrays.stream(cloudDyList).collect(Collectors.toSet());
        this.cloudAppMap = Arrays.stream(appDyList).filter(app -> app.getDynamicObject("cloud") != null).collect(Collectors.groupingBy(app -> app.getDynamicObject("cloud").getString("number")));
        this.appBizMap = Arrays.stream(bizObjDyList).filter(biz -> biz.getDynamicObject("app") != null).collect(Collectors.groupingBy(bizObj -> bizObj.getDynamicObject("app").getString("number")));
    }

    public LeftTreeNodeBo(DynamicObject[] cloudDyList) {
        this.cloudSet = Arrays.stream(cloudDyList).collect(Collectors.toSet());
    }

    public TreeNode buildTreeNode(boolean isContainApp) {
        TreeNode rootNode = new TreeNode("", "-1", "ALL");
        rootNode.setIsOpened(true);
        this.cloudSet.stream().sorted(Comparator.comparing(dyn -> dyn.getInt("index"))).forEach(cloud -> this.addCloudNode((DynamicObject)cloud, rootNode, isContainApp));
        return rootNode;
    }

    private void addCloudNode(DynamicObject cloud, TreeNode rootNode, boolean isContainApp) {
        TreeNode cloudNode = new TreeNode(rootNode.getId(), LeftTreeNodeBo.joinNodeId(rootNode.getId(), cloud.getString("id")), cloud.getLocaleString("name").getLocaleValue());
        rootNode.addChild(cloudNode);
        if (isContainApp) {
            this.addAppNode(cloudNode, cloud.getString("number"));
        }
    }

    private void addAppNode(TreeNode cloudNode, String cloudNumber) {
        List<DynamicObject> appList = this.cloudAppMap.get(cloudNumber);
        if (CollectionUtils.isEmpty(appList)) {
            return;
        }
        appList.stream().sorted(Comparator.comparing(dyn -> dyn.getInt("index"))).forEach(app -> {
            TreeNode appNode = new TreeNode(cloudNode.getId(), LeftTreeNodeBo.joinNodeId(cloudNode.getId(), app.getString("id")), app.getLocaleString("name").getLocaleValue());
            this.addBizObjNode(appNode, app.getString("number"));
            cloudNode.addChild(appNode);
        });
    }

    private void addBizObjNode(TreeNode appNode, String appNumber) {
        List<DynamicObject> bizObjList = this.appBizMap.get(appNumber);
        if (CollectionUtils.isEmpty(bizObjList)) {
            return;
        }
        bizObjList.stream().sorted(Comparator.comparing(dyn -> dyn.getInt("index"))).forEach(bizObj -> {
            TreeNode bizObjNode = new TreeNode(appNode.getId(), LeftTreeNodeBo.joinNodeId(appNode.getId(), bizObj.getString("id")), bizObj.getLocaleString("name").getLocaleValue());
            if (this.isRenderLogicEntityData()) {
                this.addLogicEntityNode(bizObjNode, bizObj.getString("number"));
            }
            appNode.addChild(bizObjNode);
        });
    }

    protected void addLogicEntityNode(TreeNode bizObjNode, String bizObjNumber) {
    }

    protected boolean isRenderLogicEntityData() {
        return false;
    }

    protected static String joinNodeId(String parentId, String id) {
        return parentId + "." + id;
    }
}

