/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.model.bo;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.tree.TreeNode;
import kd.hdtc.hrbm.business.domain.model.bo.LeftTreeNodeBo;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hr.hbp.common.util.HRArrayUtils;

public class LogicEntityLeftTreeNodeBo
extends LeftTreeNodeBo {
    private Map<String, List<DynamicObject>> bizObjLogicEntityMap;

    public LogicEntityLeftTreeNodeBo(DynamicObject[] cloudDyList, DynamicObject[] appDyList, DynamicObject[] bizObjDyList, DynamicObject[] LogicEntityDyList) {
        super(cloudDyList, appDyList, bizObjDyList);
        if (HRArrayUtils.isNotEmpty((Object[])LogicEntityDyList)) {
            this.bizObjLogicEntityMap = Arrays.stream(LogicEntityDyList).filter(logicEntity -> logicEntity.getDynamicObject("bizobj") != null).collect(Collectors.groupingBy(logicEntity -> logicEntity.getDynamicObject("bizobj").getString("number")));
        }
    }

    @Override
    protected void addLogicEntityNode(TreeNode bizObjNode, String bizObjNumber) {
        if (this.bizObjLogicEntityMap == null) {
            return;
        }
        List<DynamicObject> logicEntityList = this.bizObjLogicEntityMap.get(bizObjNumber);
        if (CollectionUtils.isEmpty(logicEntityList)) {
            return;
        }
        logicEntityList.stream().sorted(Comparator.comparing(dyn -> dyn.getInt("index"))).forEach(bizObj -> {
            TreeNode logicEntityNode = new TreeNode(bizObjNode.getId(), LogicEntityLeftTreeNodeBo.joinNodeId(bizObjNode.getId(), bizObj.getString("id")), bizObj.getLocaleString("name").getLocaleValue());
            bizObjNode.addChild(logicEntityNode);
        });
    }

    @Override
    protected boolean isRenderLogicEntityData() {
        return true;
    }
}

