/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.model.bo;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrbm.common.enums.ExtCaseEnum;
import kd.hdtc.hrbm.common.pojo.LogicEntityPageSourceParam;

public class LogicEntityNumberGenerateBo {
    private ILogicEntityDomainService iLogicEntityDomainService = ServiceFactory.getService(ILogicEntityDomainService.class);
    private static final Set<String> PERSON_BILL_CASE_SET = ImmutableSet.of((Object)ExtCaseEnum.PERSON_BILL_ADD_ENTRY.getStrId());
    private Map<TYPE, Supplier<String>> TYPE_MAP = ImmutableMap.of((Object)((Object)TYPE.NORMAL), () -> this.generateNormalNumber(), (Object)((Object)TYPE.PERSON_BILL), () -> this.generatePersonBillNumber());
    private LogicEntityPageSourceParam logicEntityPageSourceParam;
    private Map<String, Object> customParamMap;

    private String generatePersonBillNumber() {
        String entryKey = "entry";
        DynamicObject subLogicEntity = this.iLogicEntityDomainService.getLogicEntityInfoById(this.customParamMap.get("sublogicentity"));
        String location = (String)this.customParamMap.get("location");
        String subLogicEntityNumber = subLogicEntity.getString("number");
        String relLogicEntityNumber = subLogicEntityNumber.substring(subLogicEntityNumber.lastIndexOf("_") + 1);
        if ("1".equals(location)) {
            entryKey = entryKey + "_b_" + relLogicEntityNumber;
        } else if ("2".equals(location)) {
            entryKey = entryKey + "_a_" + relLogicEntityNumber;
        }
        DynamicObject mainLogicEntity = this.iLogicEntityDomainService.getLogicEntityInfoById(this.customParamMap.get("mainentity"));
        return mainLogicEntity.get("number") + "." + entryKey;
    }

    private String generateNormalNumber() {
        return this.iLogicEntityDomainService.getLogicEntityNumber(this.logicEntityPageSourceParam.getMainEntityId(), this.logicEntityPageSourceParam.getOpenType(), this.logicEntityPageSourceParam.getNodeId());
    }

    public LogicEntityNumberGenerateBo(LogicEntityPageSourceParam logicEntityPageSourceParam) {
        this.logicEntityPageSourceParam = logicEntityPageSourceParam;
        this.customParamMap = logicEntityPageSourceParam.getCustomParamMap();
    }

    public String generate() {
        return this.TYPE_MAP.get((Object)this.judgeType()).get();
    }

    private TYPE judgeType() {
        String extCaseStrValue = this.logicEntityPageSourceParam.getExtCaseStrValue();
        if (PERSON_BILL_CASE_SET.contains(extCaseStrValue)) {
            return TYPE.PERSON_BILL;
        }
        return TYPE.NORMAL;
    }

    private static enum TYPE {
        PERSON_BILL,
        NORMAL;

    }
}

