/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.model.entity.impl;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.domain.model.bean.BizObjBean;
import kd.hdtc.hrbm.business.domain.model.entity.IBizObjEntityService;
import kd.hdtc.hrdbs.business.entity.AbstractBaseEntityService;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.util.CollectionUtils;

public class BizObjEntityServiceImpl
extends AbstractBaseEntityService
implements IBizObjEntityService {
    private static final Log LOG = LogFactory.getLog(BizObjEntityServiceImpl.class);
    private static final String SELECT_PROPERTIES = "id,name,number,app,type,sortnumber,isbearaddobj";

    public BizObjEntityServiceImpl() {
        super("hrbm_bizobj");
    }

    @Override
    public Map<Long, DynamicObject> queryBizObjById(Collection<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return new HashMap<Long, DynamicObject>();
        }
        QFilter numberFilter = new QFilter("id", "in", idList);
        Object[] dynamicObjects = this.query(SELECT_PROPERTIES, new QFilter[]{QFilterConstants.Q_ENABLE, numberFilter});
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        return Stream.of(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
    }

    @Override
    public Map<Long, BizObjBean> queryBizObjEntryById(Collection<Long> idList) {
        Map<Long, DynamicObject> bizObjIdAndBizObjMap = this.queryBizObjById(idList);
        HashMap bizObjIdAndBizEntryMap = Maps.newHashMapWithExpectedSize((int)bizObjIdAndBizObjMap.size());
        bizObjIdAndBizObjMap.forEach((bizObjId, bizObj) -> {
            BizObjBean bizObjBean = new BizObjBean();
            bizObjBean.setName(bizObj.getString("name"));
            bizObjBean.setNumber(bizObj.getString("number"));
            DynamicObject app = bizObj.getDynamicObject("app");
            if (app != null) {
                bizObjBean.setAppId(app.getLong("id"));
                bizObjBean.setAppName(app.getString("name"));
                bizObjBean.setAppNumber(app.getString("number"));
                DynamicObject cloud = app.getDynamicObject("cloud");
                if (cloud != null) {
                    bizObjBean.setCloudId(cloud.getLong("id"));
                    bizObjBean.setCloudName(cloud.getString("name"));
                    bizObjBean.setCloudNumber(cloud.getString("number"));
                }
            }
            bizObjIdAndBizEntryMap.put(bizObjId, bizObjBean);
        });
        return bizObjIdAndBizEntryMap;
    }
}

