/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.model.entity.impl;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.domain.model.bean.LogicEntityRelBean;
import kd.hdtc.hrbm.business.domain.model.entity.ILogicEntityRelEntityService;
import kd.hdtc.hrdbs.business.entity.AbstractBaseEntityService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;

public class LogicEntityRelEntityServiceImpl
extends AbstractBaseEntityService
implements ILogicEntityRelEntityService {
    private static final String SELECT_PROPERTIES = "id,logicentity,metadatanum,metadataname,table,tablename,modifytime,modifier";

    public LogicEntityRelEntityServiceImpl() {
        super("hrbm_logicentityrel");
    }

    @Override
    public Map<Long, List<LogicEntityRelBean>> queryLogicEntityRelEntryByLogicEntityId(Collection<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        QFilter logicEntityFilter = new QFilter("logicentity", "in", idList);
        Object[] dynamicObjects = this.query(SELECT_PROPERTIES, new QFilter[]{logicEntityFilter});
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashMap logicEntityIdAndLogicEntityRelEntryListMap = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        Stream.of(dynamicObjects).forEach(logicEntityRel -> {
            DynamicObject logicEntity = logicEntityRel.getDynamicObject("logicentity");
            if (logicEntity != null) {
                long logicEntityId = logicEntity.getLong("id");
                List logicEntityRelBeanList = logicEntityIdAndLogicEntityRelEntryListMap.getOrDefault(logicEntityId, new ArrayList());
                LogicEntityRelBean logicEntityRelBean = new LogicEntityRelBean();
                logicEntityRelBean.setLogicEntityId(logicEntityId);
                logicEntityRelBean.setLogicEntityName(logicEntity.getString("name"));
                logicEntityRelBean.setLogicEntityNumber(logicEntity.getString("number"));
                logicEntityRelBean.setMetadataNum(logicEntityRel.getString("metadatanum"));
                logicEntityRelBean.setMetadataName(logicEntityRel.getString("metadataname"));
                logicEntityRelBean.setTable(logicEntityRel.getString("table"));
                logicEntityRelBean.setTableName(logicEntityRel.getString("tablename"));
                logicEntityRelBeanList.add(logicEntityRelBean);
                logicEntityIdAndLogicEntityRelEntryListMap.put(logicEntityId, logicEntityRelBeanList);
            }
        });
        return logicEntityIdAndLogicEntityRelEntryListMap;
    }

    @Override
    public DynamicObject[] queryLogicEntityRelByLogicEntityId(long logicEntityId) {
        QFilter logicEntityFilter = new QFilter("logicentity", "=", (Object)logicEntityId);
        return this.query(SELECT_PROPERTIES, new QFilter[]{logicEntityFilter});
    }
}

