/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.model.factory;

import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrbm.business.domain.model.bo.IPageTitleBo;
import kd.hdtc.hrbm.common.msgEnum.BizModelMsgEnum;
import kd.hdtc.hrbm.common.pojo.PageTitleParam;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class PageTitleBoFactory {
    private static final ILogicEntityDomainService SERVICE = ServiceFactory.getService(ILogicEntityDomainService.class);

    public static IPageTitleBo generate(PageTitleParam pageTitleParam) {
        if (PageTitleBoFactory.isBDOpenType(pageTitleParam.getOpenTypeObj())) {
            return () -> PageTitleBoFactory.getDefaultPageTitle(pageTitleParam, BizModelMsgEnum.BASEDATA.get(), BizModelMsgEnum.NEWE_BASEDATA.get());
        }
        return () -> PageTitleBoFactory.getDefaultPageTitle(pageTitleParam, BizModelMsgEnum.SON_BASEDATA.get(), BizModelMsgEnum.NEWE_SON_BASEDATA.get());
    }

    private static String getDefaultPageTitle(PageTitleParam pageTitleParam, String titlePrefix, String newTitle) {
        Object pkId = ((BillShowParameter)pageTitleParam.getFormShowParameter()).getPkId();
        if (!ObjectUtils.isEmpty((Object)pkId)) {
            DynamicObject logicEntity = SERVICE.getLogicEntityInfoById(ConvertUtils.toLong((Object)pkId));
            ILocaleString name = logicEntity.getLocaleString("name");
            StringBuilder sb = new StringBuilder(titlePrefix);
            sb.append("-").append(name.getLocaleValue());
            return sb.toString();
        }
        return newTitle;
    }

    private static boolean isBDOpenType(Object openTypeObj) {
        return HRStringUtils.equals((String)((String)openTypeObj), (String)"bdmode");
    }
}

