/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.model.IAppDomainService;
import kd.hdtc.hrbm.business.domain.model.entity.IAppEntityService;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdbs.common.util.ObjectUtils;

public class AppDomainServiceImpl
implements IAppDomainService {
    IAppEntityService appEntityService = ServiceFactory.getService(IAppEntityService.class);
    private static final String SELECT_COLS = "id,name,appnumber,description,index,cloud,enable";

    @Override
    public DynamicObject getAppInfoById(Object id) {
        return this.appEntityService.query(SELECT_COLS, id);
    }

    @Override
    public DynamicObject getValidAppInfoById(Object id) {
        QFilter qFilter = new QFilter("id", "=", id);
        qFilter.and("enable", "=", (Object)"1");
        return this.appEntityService.queryOne(SELECT_COLS, new QFilter[]{qFilter});
    }

    @Override
    public List<DynamicObject> getAppInfoListByCloudId(Long id) {
        if (id == null) {
            return new ArrayList<DynamicObject>();
        }
        return this.getAppInfoListByCloudId(Collections.singletonList(id));
    }

    @Override
    public List<DynamicObject> getAppInfoListByCloudId(Collection<Long> cloudIdList) {
        if (CollectionUtils.isEmpty(cloudIdList)) {
            return new ArrayList<DynamicObject>();
        }
        QFilter cloudFilter = new QFilter("cloud", "in", cloudIdList);
        Object[] appArr = this.appEntityService.query("id,name,number,index,appnumber,cloud", new QFilter[]{cloudFilter, QFilterConstants.Q_ENABLE});
        if (ObjectUtils.isEmpty((Object[])appArr)) {
            return new ArrayList<DynamicObject>();
        }
        return ConvertUtils.toList((Object[])appArr);
    }
}

