/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.model.impl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.model.IAppDomainService;
import kd.hdtc.hrbm.business.domain.model.IBizModelDataDomainService;
import kd.hdtc.hrbm.business.domain.model.IBizObjDomainService;
import kd.hdtc.hrbm.business.domain.model.ICloudDomainService;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrbm.business.domain.model.bean.BizModelDataBean;
import kd.hdtc.hrbm.common.enums.BizModelTypeEnum;

public class BizModelDataDomainServiceImpl
implements IBizModelDataDomainService {
    private final ICloudDomainService cloudDomainService = ServiceFactory.getService(ICloudDomainService.class);
    private final IAppDomainService appDomainService = ServiceFactory.getService(IAppDomainService.class);
    private final IBizObjDomainService bizObjDomainService = ServiceFactory.getService(IBizObjDomainService.class);
    private final ILogicEntityDomainService logicEntityDomainService = ServiceFactory.getService(ILogicEntityDomainService.class);

    @Override
    public BizModelDataBean getBizModelInfoById(BizModelTypeEnum bizModelType, Object id) {
        if (bizModelType == null || id == null) {
            return null;
        }
        if (BizModelTypeEnum.CLOUD == bizModelType) {
            return new BizModelDataBean(bizModelType, this.cloudDomainService.getCloudInfoById(id));
        }
        if (BizModelTypeEnum.APP == bizModelType) {
            return new BizModelDataBean(bizModelType, this.appDomainService.getAppInfoById(id));
        }
        if (BizModelTypeEnum.BIZ_OBJ == bizModelType) {
            return new BizModelDataBean(bizModelType, this.bizObjDomainService.getBizObjInfoById(id));
        }
        if (BizModelTypeEnum.LOGIC_ENTITY == bizModelType) {
            return new BizModelDataBean(bizModelType, this.logicEntityDomainService.getLogicEntityInfoById(id));
        }
        return null;
    }

    @Override
    public BizModelDataBean getValidBizModelInfoById(BizModelTypeEnum bizModelType, Object id) {
        if (bizModelType == null || id == null) {
            return null;
        }
        if (BizModelTypeEnum.CLOUD == bizModelType) {
            return new BizModelDataBean(bizModelType, this.cloudDomainService.getValidCloudInfoById(id));
        }
        if (BizModelTypeEnum.APP == bizModelType) {
            return new BizModelDataBean(bizModelType, this.appDomainService.getValidAppInfoById(id));
        }
        if (BizModelTypeEnum.BIZ_OBJ == bizModelType) {
            return new BizModelDataBean(bizModelType, this.bizObjDomainService.getValidBizObjInfoById(id));
        }
        if (BizModelTypeEnum.LOGIC_ENTITY == bizModelType) {
            return new BizModelDataBean(bizModelType, this.logicEntityDomainService.getValidLogicEntityInfoById(id));
        }
        return null;
    }

    @Override
    public void putParentBean(BizModelDataBean bizModelDataBean, boolean isNeedAllLeve) {
        DynamicObject realModelData;
        if (bizModelDataBean == null || bizModelDataBean.getBizModelType() == null || bizModelDataBean.getBizModel() == null || bizModelDataBean.getBizModelType() == BizModelTypeEnum.CLOUD) {
            return;
        }
        BizModelTypeEnum bizModelType = bizModelDataBean.getBizModelType();
        BizModelTypeEnum parentTypeEnum = BizModelTypeEnum.getBizModelTypeByLevel((int)(bizModelType.getLevel() - 1));
        if (parentTypeEnum == null) {
            return;
        }
        DynamicObject bizModel = bizModelDataBean.getBizModel();
        DynamicObject parenModel = null;
        if (bizModelType == BizModelTypeEnum.LOGIC_ENTITY) {
            DynamicObject realModelData2;
            parenModel = this.getBizOBjByBizModel(bizModel);
            if (parenModel == null && (realModelData2 = this.logicEntityDomainService.getLogicEntityInfoById(bizModel.getLong("id"))) != null && realModelData2.getLong("bizobj.id") != 0L) {
                parenModel = this.bizObjDomainService.getBizObjInfoById(realModelData2.getLong("bizobj.id"));
            }
        } else if (bizModelType == BizModelTypeEnum.BIZ_OBJ) {
            DynamicObject realModelData3 = this.bizObjDomainService.getBizObjInfoById(bizModel.getLong("id"));
            if (realModelData3 != null && realModelData3.getLong("app.id") != 0L) {
                parenModel = this.appDomainService.getAppInfoById(realModelData3.getLong("app.id"));
            }
        } else if (bizModelType == BizModelTypeEnum.APP && (realModelData = this.appDomainService.getAppInfoById(bizModel.getLong("id"))) != null && realModelData.getLong("cloud.id") != 0L) {
            parenModel = this.cloudDomainService.getCloudInfoById(realModelData.getLong("cloud.id"));
        }
        if (parenModel == null) {
            return;
        }
        BizModelDataBean parentBean = new BizModelDataBean(parentTypeEnum, parenModel);
        if (isNeedAllLeve) {
            this.putParentBean(parentBean, true);
        }
        bizModelDataBean.setParentBean(parentBean);
    }

    private DynamicObject getBizOBjByBizModel(DynamicObject bizModel) {
        Object bizObj = bizModel.get("bizobj");
        if (bizObj instanceof DynamicObject) {
            return (DynamicObject)bizObj;
        }
        return null;
    }
}

