/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.model.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.devportal.plugin.BizAppDeployTreePlugin;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Button;
import kd.bos.form.control.TreeView;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.CollectionUtils;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.extcase.entity.IExtCaseManageEntityService;
import kd.hdtc.hrbm.business.domain.file.IFilePackageDomainService;
import kd.hdtc.hrbm.business.domain.model.IBizModelRecordDomainService;
import kd.hdtc.hrbm.business.domain.model.IMetaDataPresetDataDomainService;
import kd.hdtc.hrbm.business.domain.model.entity.IAppEntityService;
import kd.hdtc.hrbm.business.domain.model.entity.IBizModelPublishEntityService;
import kd.hdtc.hrbm.business.domain.model.entity.IBizModelRecordEntityService;
import kd.hdtc.hrbm.business.domain.model.entity.ILogicEntityEntityService;
import kd.hdtc.hrbm.business.domain.model.entity.ILogicEntityRelEntityService;
import kd.hdtc.hrbm.business.domain.model.entity.IPropEntityService;
import kd.hdtc.hrbm.business.domain.model.entity.IPropRelPropService;
import kd.hdtc.hrbm.business.domain.task.bo.BizModelRecordBo;
import kd.hdtc.hrbm.business.domain.task.bo.DataResultBo;
import kd.hdtc.hrbm.business.domain.task.bo.MetadataDataResultBo;
import kd.hdtc.hrbm.business.domain.task.bo.PresetDataResultBo;
import kd.hdtc.hrbm.business.domain.task.tools.IMetadataDomainService;
import kd.hdtc.hrbm.common.msgEnum.BizModelMsgEnum;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdbs.common.util.ObjectUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class BizModelRecordDomainServiceImpl
implements IBizModelRecordDomainService {
    IBizModelRecordEntityService iBizModelRecordEntityService = ServiceFactory.getService(IBizModelRecordEntityService.class);
    IMetadataDomainService iMetadataDomainService = ServiceFactory.getService(IMetadataDomainService.class);
    IMetaDataPresetDataDomainService metaDataPresetDataDomainService = ServiceFactory.createInstance(IMetaDataPresetDataDomainService.class);
    IFilePackageDomainService iFilePackageDomainService = ServiceFactory.getService(IFilePackageDomainService.class);
    IAppEntityService iAppEntityService = ServiceFactory.getService(IAppEntityService.class);
    ILogicEntityEntityService iLogicEntityEntityService = ServiceFactory.getService(ILogicEntityEntityService.class);
    IBizModelPublishEntityService iBizModelPublishEntityService = ServiceFactory.getService(IBizModelPublishEntityService.class);
    ILogicEntityRelEntityService logicEntityRelEntityService = ServiceFactory.getService(ILogicEntityRelEntityService.class);
    ILogicEntityEntityService logicEntityEntityService = ServiceFactory.getService(ILogicEntityEntityService.class);
    IPropEntityService propEntityService = ServiceFactory.getService(IPropEntityService.class);
    IPropRelPropService propRelPropService = ServiceFactory.getService(IPropRelPropService.class);
    IExtCaseManageEntityService extCaseManageEntityService = ServiceFactory.getService(IExtCaseManageEntityService.class);
    HRBaseServiceHelper metaHelper = new HRBaseServiceHelper("bos_formmeta");
    private static final Log LOG = LogFactory.getLog(BizModelRecordDomainServiceImpl.class);
    private static final String QUERY_FIELD = "bizmodel,result,modifier,modifytime";
    private static final String Q_FILTER_STRING = "fid in (";
    private static final String ENTRY_Q_FILTER_STRING = " in (";
    private static final String SUFFIX_SQL = ".sql";
    private static final String SUFFIX_ZIP = ".zip";
    private static final String META_DATA_SUFFIX = "_metadata";
    private static final String PRE_DATA_SUFFIX = "_preinsdata";
    private static final String ROLLBACK_NAME_SUFFIX = "_delete";
    private static final String PRE_INS_DATA_PATH = "/preinsdata/";
    private static final String META_DATA_PATH = "/metadata/";
    private static final String CANCEL_SCRIPT = "cancel_script";

    @Override
    public DynamicObject getBizModelRecordById(Long id) {
        return this.iBizModelRecordEntityService.queryOne(QUERY_FIELD, new QFilter("id", "=", (Object)id).toArray());
    }

    @Override
    public Object saveBizModelRecord(BizModelRecordBo bizModelRecordBo) {
        QFilter basedataTypeQFilter = new QFilter("basedatatype", "=", (Object)bizModelRecordBo.getBaseDatatype());
        QFilter biz = new QFilter("bizmodel", "=", (Object)bizModelRecordBo.getBizModelId());
        DynamicObject bizModelDy = this.iBizModelRecordEntityService.queryOne(QUERY_FIELD, basedataTypeQFilter.and(biz).toArray());
        DataResultBo dataResultBo = new DataResultBo();
        if (!ObjectUtils.isEmpty((Object)bizModelDy) && StringUtils.isNotEmpty((String)bizModelDy.getString("result"))) {
            List<PresetDataResultBo> dataList = DataResultBo.analysisJsonToData(bizModelDy.getString("result"));
            List<MetadataDataResultBo> metaList = DataResultBo.analysisJsonToMeta(bizModelDy.getString("result"));
            dataList.forEach(data -> dataResultBo.addPresetDataResultBo((PresetDataResultBo)data));
            metaList.forEach(meta -> dataResultBo.addMetadataDataResultBoList((MetadataDataResultBo)meta));
        }
        DataResultBo dataResultBoNew = bizModelRecordBo.getDataResultBo();
        DynamicObject dyn = bizModelDy == null ? new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hrbm_bizmodelrecord")) : bizModelDy;
        dyn.set("bizmodel", (Object)bizModelRecordBo.getBizModelId());
        dyn.set("basedatatype", (Object)bizModelRecordBo.getBaseDatatype());
        dyn.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dyn.set("modifytime", (Object)new Date());
        dataResultBoNew.mergeDataResult(dataResultBo);
        dyn.set("result", (Object)dataResultBoNew.resultDataBoToJson());
        return this.iBizModelRecordEntityService.save(dyn);
    }

    @Override
    public boolean downloadRecordByIds(List<Object> ids, IFormView view) {
        ArrayList<MetadataDataResultBo> metaList = new ArrayList<MetadataDataResultBo>(10);
        ArrayList<PresetDataResultBo> dataList = new ArrayList<PresetDataResultBo>(10);
        this.getJsonInfoByRecords(ids, metaList, dataList);
        if (CollectionUtils.isEmpty(dataList) && CollectionUtils.isEmpty(metaList)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u4e0b\u8f7d\u6570\u636e\u3002", (String)"BizModelRecordDomainServiceImpl_0", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
            view.getPageCache().put("datanumber", "0");
            return true;
        }
        List<MetadataDataResultBo> dealMetaList = this.distinctMetaData(metaList);
        List entityNumberList = dealMetaList.stream().map(MetadataDataResultBo::getNumber).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entityNumberList)) {
            return false;
        }
        DynamicObject[] metaDynamicObjects = this.metaHelper.query("bizappid,number", new QFilter("number", "in", entityNumberList).toArray());
        if (metaDynamicObjects == null || metaDynamicObjects.length == 0) {
            return false;
        }
        List bizAppIdList = Arrays.stream(metaDynamicObjects).map(dyc -> dyc.getString("bizappid")).distinct().collect(Collectors.toList());
        String bizAppId = bizAppIdList.stream().findFirst().orElse("");
        if (bizAppIdList.size() > 0) {
            bizAppId = (String)bizAppIdList.get(0);
        }
        Map<String, List<DynamicObject>> metaListMap = Arrays.asList(metaDynamicObjects).stream().collect(Collectors.groupingBy(t -> t.getString("bizappid")));
        List preInsDataNumberList = dataList.stream().map(PresetDataResultBo::getNumber).distinct().collect(Collectors.toList());
        DynamicObject[] dynamicObjects = this.metaHelper.query("bizappid,number", new QFilter("number", "in", preInsDataNumberList).toArray());
        HashMap<String, String> bizAppIdMap = new HashMap<String, String>(16);
        for (DynamicObject object : dynamicObjects) {
            bizAppIdMap.put(object.getString("number"), object.getString("bizappid"));
        }
        FormShowParameter parameter = this.buildMadeAppPackInfo(bizAppId);
        IFormView newView = parameter.createView();
        newView.addService(IPageCache.class, (Object)new PageCache(""));
        newView.initialize(parameter);
        IDataModel dataModel = newView.getModel();
        DynamicObject dyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_devp_madeapppack_inh1"));
        DynamicObjectCollection sqlEntryCollection = this.buildSqlEntryCollection(dataList, dyn, bizAppIdMap);
        dyn.set("sqlentryentity", (Object)sqlEntryCollection);
        dyn.set("patchchecked", (Object)true);
        dataModel.createNewData((Object)dyn);
        newView.getPageCache().put("selectappids", SerializationUtils.toJsonString(bizAppIdList));
        metaListMap.entrySet().stream().forEach(entry -> newView.getPageCache().put((String)entry.getKey(), this.buildMetaTreeInfo(newView, (String)entry.getKey(), metaListMap)));
        this.click(newView, view);
        newView.close();
        return true;
    }

    private void click(IFormView newView, IFormView view) {
        BizAppDeployTreePlugin plugin = new BizAppDeployTreePlugin();
        plugin.setView(newView);
        plugin.addClickListeners(new String[]{"infoconfirm"});
        Button button = (Button)newView.getControl("infoconfirm");
        button.click();
        List objectList = newView.getActionResult();
        for (Object obj : objectList) {
            Map map = (Map)obj;
            if (!map.get("a").equals("openUrl")) continue;
            String url = (String)((List)map.get("p")).get(0);
            view.openUrl(url);
            break;
        }
    }

    private String buildMetaTreeInfo(IFormView view, String bizAppId, Map<String, List<DynamicObject>> metaListMap) {
        TreeView leftTree = (TreeView)view.getControl("treeviewap");
        TreeNode root = new TreeNode("", "rootnode", "rootnode");
        leftTree.addNode(root);
        JSONArray jsonArray = new JSONArray();
        List<String> entityNumberList = metaListMap.get(bizAppId).stream().map(m -> m.getString("number")).collect(Collectors.toList());
        DynamicObject[] bosEntities = this.iMetadataDomainService.getBosFormMetaByEntityNumbers(entityNumberList);
        Set idList = Arrays.stream(bosEntities).map(it -> it.getString("id")).collect(Collectors.toSet());
        JSONObject appChildren = new JSONObject();
        appChildren.put("id", (Object)(bizAppId + "#app_menu##menu"));
        appChildren.put("parentid", (Object)bizAppId);
        jsonArray.add((Object)appChildren);
        for (String id : idList) {
            JSONObject children = new JSONObject();
            children.put("id", (Object)(bizAppId + "#" + id + "_page"));
            children.put("parentid", (Object)bizAppId);
            jsonArray.add((Object)children);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("children", (Object)jsonArray);
        jsonObject.put("id", (Object)bizAppId);
        jsonObject.put("parentid", (Object)"rootnode");
        return jsonObject.toJSONString();
    }

    private DynamicObjectCollection buildSqlEntryCollection(List<PresetDataResultBo> dataList, DynamicObject dynamicObject, Map<String, String> map) {
        String contextUrl = UrlService.getDomainContextUrl();
        Map sqlEntityType = MetadataServiceHelper.getDataEntityType((String)"bos_devp_madeapppack_inh1").getAllEntities();
        EntityType sqlEntryEntityType = (EntityType)sqlEntityType.get("sqlentryentity");
        DynamicObjectCollection queryEntityEntryCollection = new DynamicObjectCollection((DynamicObjectType)sqlEntryEntityType, (Object)dynamicObject);
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>(16);
        for (PresetDataResultBo dataBo : dataList) {
            MainEntityType entityType = MetadataUtils.getMainEntityType((String)dataBo.getNumber());
            StringBuilder metePreInsDataSb = new StringBuilder();
            if (CollectionUtils.isNotEmpty(dataBo.getIdList())) {
                List<Object> allIdList = dataBo.getIdList();
                int total = allIdList.size();
                int size = allIdList.size() / 10000 + 1;
                for (int i = 0; i < size; ++i) {
                    int startIndex = i * 10000;
                    int nexIndex = i * 10000 + 10000;
                    int endIndex = nexIndex > total ? total : nexIndex;
                    List<Object> idList = allIdList.subList(startIndex, endIndex);
                    String simpleName = entityType.getPrimaryKey().getPropertyType().getSimpleName();
                    StringBuilder sqlSb = new StringBuilder();
                    if ("long".equals(simpleName)) {
                        sqlSb.append(Q_FILTER_STRING).append(Joiner.on((char)',').join(idList)).append(')');
                    } else {
                        sqlSb.append(Q_FILTER_STRING).append("'").append(Joiner.on((char)',').join(idList).replace(",", "','")).append("'").append(')');
                    }
                    metePreInsDataSb.append(this.metaDataPresetDataDomainService.getPresetDataString(dataBo.getNumber(), sqlSb.toString()));
                }
            }
            if (metePreInsDataSb.length() > 0) {
                DynamicObject queryEntityEntry = new DynamicObject((DynamicObjectType)sqlEntryEntityType);
                queryEntityEntry.set("sqlname", (Object)(this.getFileName(dataBo.getNumber(), indexMap) + SUFFIX_SQL));
                DynamicObject sqlAppObj = new DynamicObject((DynamicObjectType)MetadataUtils.getMainEntityType((String)"bos_devportal_bizapp"));
                sqlAppObj.set("id", (Object)map.get(dataBo.getNumber()));
                if (ObjectUtils.isEmpty((Object)sqlAppObj.getPkValue())) continue;
                queryEntityEntry.set("sqlapp", (Object)sqlAppObj);
                queryEntityEntry.set("dbtype", (Object)"KSQL");
                queryEntityEntry.set("sqlfiletype", (Object)"preinsdata");
                String presetPath = this.iFilePackageDomainService.getPresetPath(metePreInsDataSb.toString(), entityType.getBizAppNumber() + PRE_INS_DATA_PATH + this.getFileName(dataBo.getNumber(), indexMap) + SUFFIX_SQL);
                queryEntityEntry.set("urlpath", (Object)(contextUrl + presetPath));
                queryEntityEntryCollection.add((Object)queryEntityEntry);
                continue;
            }
            LOG.warn("has no data to export,number:{}", (Object)dataBo.getNumber());
        }
        return queryEntityEntryCollection;
    }

    private String getFileName(String number, Map<String, Integer> indexMap) {
        Integer info = indexMap.get(number);
        if (info != null) {
            StringBuilder stringBuilder = new StringBuilder();
            indexMap.put(number, ConvertUtils.toInt((Object)info) + 1);
            return stringBuilder.append(number).append('_').append(info).toString();
        }
        indexMap.put(number, ConvertUtils.toInt((Object)info) + 1);
        return number;
    }

    private FormShowParameter buildMadeAppPackInfo(String bizAppId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_madeapppack_inh1");
        parameter.setAppId("devportal");
        parameter.setCustomParam("bizappid", (Object)bizAppId);
        FormConfig config = FormMetadataCache.getFormConfig((String)parameter.getFormId());
        parameter.setFormConfig(config);
        return parameter;
    }

    private List<MetadataDataResultBo> distinctMetaData(List<MetadataDataResultBo> metaList) {
        if (CollectionUtils.isNotEmpty(metaList)) {
            Map<String, MetadataDataResultBo> map = metaList.stream().collect(Collectors.toMap(MetadataDataResultBo::getNumber, kk -> kk, (v1, v2) -> v2));
            return new ArrayList<MetadataDataResultBo>(map.values());
        }
        return metaList;
    }

    private void getJsonInfoByRecords(List<Object> ids, List<MetadataDataResultBo> metaList, List<PresetDataResultBo> dataList) {
        DynamicObject[] records;
        for (DynamicObject record : records = this.iBizModelRecordEntityService.query(QUERY_FIELD, new QFilter("id", "in", ids).toArray())) {
            String result = record.getString("result");
            if (HRStringUtils.isEmpty((String)result)) continue;
            dataList.addAll(DataResultBo.analysisJsonToData(result));
            metaList.addAll(DataResultBo.analysisJsonToMeta(result));
        }
    }

    @Override
    public List<Object> getBizModelRecordIdsByIds(List<Object> ids) {
        ArrayList<Object> bizModelRecordIdList = new ArrayList<Object>(10);
        Object[] modelPublishObjects = this.iBizModelPublishEntityService.query("itemclasstype,itemclass", new QFilter[]{new QFilter("id", "in", ids)});
        if (ArrayUtils.isEmpty((Object[])modelPublishObjects)) {
            return bizModelRecordIdList;
        }
        HashSet<String> cloudNumberList = new HashSet<String>(10);
        HashSet<String> appNumberList = new HashSet<String>(10);
        for (Object bizModelPublishDyn : modelPublishObjects) {
            DynamicObject itemClassDynObj = bizModelPublishDyn.getDynamicObject("itemclass");
            if (itemClassDynObj == null) continue;
            if ("hrbm_cloud".equals(bizModelPublishDyn.getString("itemclasstype"))) {
                cloudNumberList.add(itemClassDynObj.getString("number"));
                continue;
            }
            if (!"hrbm_app".equals(bizModelPublishDyn.getString("itemclasstype"))) continue;
            appNumberList.add(itemClassDynObj.getString("number"));
        }
        QFilter cloudNumberQFilter = new QFilter("cloud.number", "in", cloudNumberList);
        cloudNumberQFilter.or(new QFilter("number", "in", appNumberList));
        Object[] appObjects = this.iAppEntityService.query("id,number", new QFilter[]{cloudNumberQFilter.and(QFilterConstants.Q_ENABLE)});
        if (ArrayUtils.isEmpty((Object[])appObjects)) {
            return bizModelRecordIdList;
        }
        List appIdList = Arrays.stream(appObjects).map(dyc -> dyc.getLong("id")).distinct().collect(Collectors.toList());
        DynamicObject[] logicEntityObjects = this.iLogicEntityEntityService.query("id", new QFilter[]{new QFilter("bizobj.app", "in", appIdList)});
        if (logicEntityObjects == null || logicEntityObjects.length == 0) {
            return bizModelRecordIdList;
        }
        List logicEntityIdList = Arrays.stream(logicEntityObjects).map(dyc -> dyc.get("id")).distinct().collect(Collectors.toList());
        QFilter bizModelIdFilter = new QFilter("bizmodel", "in", logicEntityIdList);
        DynamicObject[] bizModelRecordObjects = this.iBizModelRecordEntityService.query("id", new QFilter[]{bizModelIdFilter});
        if (bizModelRecordObjects == null || bizModelRecordObjects.length == 0) {
            return bizModelRecordIdList;
        }
        return Arrays.stream(bizModelRecordObjects).map(dyc -> dyc.get("id")).distinct().collect(Collectors.toList());
    }

    @Override
    public boolean downloadRollbackStrByIds(List<Object> ids, IFormView view) {
        ArrayList<MetadataDataResultBo> metaList = new ArrayList<MetadataDataResultBo>(10);
        ArrayList<PresetDataResultBo> dataList = new ArrayList<PresetDataResultBo>(10);
        this.getJsonInfoByRecords(ids, metaList, dataList);
        dataList.add(new PresetDataResultBo("hrbm_bizmodelrecord", ids));
        this.handleBizModelNeedDeleteData(ids, dataList);
        if (CollectionUtils.isEmpty(dataList) && CollectionUtils.isEmpty(metaList)) {
            view.showTipNotification(BizModelMsgEnum.NO_FILE_DOWNLOAD.get());
            return true;
        }
        List<MetadataDataResultBo> dealMetaList = this.distinctMetaData(metaList);
        List entityNumberList = dealMetaList.stream().map(MetadataDataResultBo::getNumber).distinct().collect(Collectors.toList());
        DynamicObject[] metas = this.iMetadataDomainService.getBosFormMetaByEntityNumbers(entityNumberList.stream().collect(Collectors.toList()));
        Set<String> metaDataIds = Arrays.stream(metas).map(it -> it.getString("bizappid")).collect(Collectors.toSet());
        DynamicObject[] bizApps = this.iMetadataDomainService.getBosFormBizAppNumberByBizAppIds(metaDataIds);
        Map<String, String> bizAppMap = Arrays.stream(bizApps).collect(Collectors.toMap(it -> it.getString("id"), it -> it.getString("number")));
        ArrayList<String> rollbackPathList = new ArrayList<String>(10);
        HashMap bizAppAndSqlResultMap = Maps.newHashMapWithExpectedSize((int)metaDataIds.size());
        Arrays.stream(metas).forEach(it -> {
            String metaRollbackContentString = this.metaDataPresetDataDomainService.getMetaRollbackContentString(it.getString("number"), it.getString("id"));
            String tableStr = "t_" + it.getString("number") + META_DATA_SUFFIX + ROLLBACK_NAME_SUFFIX + SUFFIX_SQL;
            List sqlResultList = bizAppAndSqlResultMap.computeIfAbsent(bizAppMap.get(it.getString("bizappid")), k -> new ArrayList());
            sqlResultList.add(this.sqlResultStr(tableStr, metaRollbackContentString));
        });
        for (Map.Entry rollbackSqlMap : bizAppAndSqlResultMap.entrySet()) {
            List sqlList = (List)rollbackSqlMap.getValue();
            rollbackPathList.add(this.iFilePackageDomainService.createFileByString(this.sqlResultStr(sqlList), (String)rollbackSqlMap.getKey() + META_DATA_PATH + (String)rollbackSqlMap.getKey() + META_DATA_SUFFIX + ROLLBACK_NAME_SUFFIX + SUFFIX_SQL));
        }
        HashMap indexMap = new HashMap(16);
        HashMap bizAppAndDataResultMap = Maps.newHashMapWithExpectedSize((int)dataList.size());
        dataList.forEach(it -> {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)it.getNumber());
            StringBuilder sb = new StringBuilder();
            if (CollectionUtils.isEmpty(it.getIdList())) {
                return;
            }
            sb.append(Q_FILTER_STRING).append(Joiner.on((char)',').join(it.getIdList())).append(')');
            String metePreInsDataString = "";
            List<PresetDataResultBo> subDataList = it.getSubDataList();
            if (CollectionUtils.isNotEmpty(it.getSubDataList())) {
                Map<String, String> entryQFilter = this.buildEntryFilter(entityType, subDataList);
                metePreInsDataString = this.metaDataPresetDataDomainService.getPresetDataRollbackStringOnlyEntry(it.getNumber(), sb.toString(), entryQFilter);
            } else {
                metePreInsDataString = this.metaDataPresetDataDomainService.getPresetDataRollbackString(it.getNumber(), sb.toString());
            }
            String tableStr = "t_" + this.getFileName(it.getNumber(), indexMap) + PRE_DATA_SUFFIX + ROLLBACK_NAME_SUFFIX + SUFFIX_SQL;
            List sqlResultList = bizAppAndDataResultMap.computeIfAbsent(entityType.getBizAppNumber(), k -> new ArrayList());
            sqlResultList.add(this.sqlResultStr(tableStr, metePreInsDataString));
        });
        for (Map.Entry entry : bizAppAndDataResultMap.entrySet()) {
            List sqlList = (List)entry.getValue();
            rollbackPathList.add(this.iFilePackageDomainService.createFileByString(this.sqlResultStr(sqlList), (String)entry.getKey() + PRE_INS_DATA_PATH + (String)entry.getKey() + PRE_DATA_SUFFIX + ROLLBACK_NAME_SUFFIX + SUFFIX_SQL));
        }
        String fileName = CANCEL_SCRIPT + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + SUFFIX_ZIP;
        return this.iFilePackageDomainService.compress(rollbackPathList, fileName, view);
    }

    @Override
    public void deleteByBizModelId(Long bizModelId) {
        QFilter qFilter = new QFilter("basedatatype", "=", (Object)"hrbm_logicentity");
        qFilter.and("bizmodel", "=", (Object)bizModelId);
        List list = this.iBizModelRecordEntityService.queryOriginalList("result", qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        String result = ((DynamicObject)list.get(0)).getString("result");
        List<PresetDataResultBo> dataList = DataResultBo.analysisJsonToData(result);
        List<MetadataDataResultBo> metaList = DataResultBo.analysisJsonToMeta(result);
        this.deletePresetData(dataList);
        this.deleteMetadataData(metaList);
    }

    private void deleteMetadataData(List<MetadataDataResultBo> metaList) {
        if (CollectionUtils.isEmpty(metaList)) {
            return;
        }
        LOG.info("deleteMetadataData start");
        for (MetadataDataResultBo data : metaList) {
            this.iMetadataDomainService.deleteMetadata(data.getNumber(), false);
            LOG.info("deleteMetadataData delete DynamicObject:{} end", (Object)data.getNumber());
        }
    }

    private void deletePresetData(List<PresetDataResultBo> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        LOG.info("deletePresetData start");
        for (PresetDataResultBo data : dataList) {
            String number = data.getNumber();
            List<Object> ids = data.getIdList();
            if (HRStringUtils.isEmpty((String)number) || CollectionUtils.isEmpty(ids)) continue;
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(number);
            List<PresetDataResultBo> subDataList = data.getSubDataList();
            if (CollectionUtils.isEmpty(subDataList)) {
                hrBaseServiceHelper.delete(ids.toArray(new Object[0]));
                continue;
            }
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)number);
            DataEntityPropertyCollection props = type.getProperties();
            HashSet<String> finalProp = new HashSet<String>(subDataList.size());
            Set propSelect = subDataList.stream().map(PresetDataResultBo::getNumber).collect(Collectors.toSet());
            for (IDataEntityProperty property : props) {
                if (!propSelect.contains(property.getName()) || !(property instanceof EntryProp)) continue;
                finalProp.add(property.getName());
            }
            if (CollectionUtils.isEmpty(finalProp)) continue;
            DynamicObject[] dynList = hrBaseServiceHelper.loadDynamicObjectArray(ids.toArray(new Object[0]));
            Map<String, List<PresetDataResultBo>> subDataMap = subDataList.stream().collect(Collectors.groupingBy(PresetDataResultBo::getNumber));
            for (DynamicObject dyn : dynList) {
                finalProp.forEach(prop -> this.removeEntryPropData((String)prop, subDataMap, dyn));
            }
            hrBaseServiceHelper.save(dynList);
        }
    }

    private void removeEntryPropData(String prop, Map<String, List<PresetDataResultBo>> subDataMap, DynamicObject dyn) {
        List<PresetDataResultBo> subList = subDataMap.get(prop);
        if (CollectionUtils.isEmpty(subList)) {
            return;
        }
        ArrayList subData = Lists.newArrayListWithCapacity((int)10);
        subList.forEach(sub -> {
            if (!CollectionUtils.isEmpty(sub.getIdList())) {
                subData.addAll(sub.getIdList());
            }
        });
        DynamicObjectCollection collectionData = dyn.getDynamicObjectCollection(prop);
        if (CollectionUtils.isEmpty((Collection)subData) || CollectionUtils.isEmpty((Collection)collectionData)) {
            return;
        }
        Set subDataVal = subData.stream().map(String::valueOf).collect(Collectors.toSet());
        collectionData.removeIf(dy -> subDataVal.contains(dy.getString("id")));
    }

    private void handleBizModelNeedDeleteData(List<Object> ids, List<PresetDataResultBo> dataList) {
        DynamicObject[] recordsArr = this.iBizModelRecordEntityService.query(QUERY_FIELD, new QFilter("id", "in", ids).toArray());
        List logicEntityIdList = Arrays.stream(recordsArr).map(record -> record.getDynamicObject("bizmodel")).filter(Objects::nonNull).map(bizmodel -> bizmodel.get("id")).collect(Collectors.toList());
        DynamicObject[] logicEntityArr = this.logicEntityEntityService.query("id,isv", new QFilter("id", "in", logicEntityIdList).toArray());
        ArrayList isvList = Lists.newArrayListWithCapacity((int)10);
        ArrayList notCurIsvList = Lists.newArrayListWithCapacity((int)10);
        String curIsv = ISVService.getISVInfo().getId();
        Arrays.stream(logicEntityArr).forEach(logic -> {
            Object id = logic.get("id");
            if (HRStringUtils.equals((String)logic.getString("isv"), (String)curIsv)) {
                isvList.add(id);
            } else {
                notCurIsvList.add(id);
            }
        });
        this.handlePropNeedDeleteData(dataList, isvList, true);
        this.handlePropNeedDeleteData(dataList, notCurIsvList, false);
        DynamicObject[] result = this.extCaseManageEntityService.query("id", new QFilter("bizmodel", "in", logicEntityIdList).toArray());
        List<Object> extCaseManageEntityIdList = Arrays.stream(result).map(rel -> rel.get("id")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(extCaseManageEntityIdList)) {
            dataList.add(new PresetDataResultBo("hrbm_extcasemanage", extCaseManageEntityIdList));
        }
    }

    private void handlePropNeedDeleteData(List<PresetDataResultBo> dataList, List<Object> logicEntityIdList, boolean isCurIsv) {
        DynamicObject[] propRelIdArr;
        List<Object> propRelIdList;
        QFilter logicEntityIdFilter = new QFilter("logicentity", "in", logicEntityIdList);
        if (isCurIsv) {
            DynamicObject[] logicEntityRelArr;
            List<Object> logicEntityRelIdList;
            if (CollectionUtils.isNotEmpty(logicEntityIdList)) {
                dataList.add(new PresetDataResultBo("hrbm_logicentity", logicEntityIdList));
            }
            if (CollectionUtils.isNotEmpty(logicEntityRelIdList = Arrays.stream(logicEntityRelArr = this.logicEntityRelEntityService.query("id", new QFilter("logicentity", "in", logicEntityIdList).toArray())).map(rel -> rel.get("id")).collect(Collectors.toList()))) {
                dataList.add(new PresetDataResultBo("hrbm_logicentityrel", logicEntityRelIdList));
            }
        } else {
            logicEntityIdFilter.and(new QFilter("isv", "=", (Object)ISVService.getISVInfo().getId()));
        }
        DynamicObject[] propIdArr = this.propEntityService.query("id", logicEntityIdFilter.and(QFilterConstants.Q_ENABLE).toArray());
        List<Object> propIdList = Arrays.stream(propIdArr).map(rel -> rel.get("id")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(propIdList)) {
            dataList.add(new PresetDataResultBo("hrbm_prop", propIdList));
        }
        if (CollectionUtils.isNotEmpty(propRelIdList = Arrays.stream(propRelIdArr = this.propRelPropService.query("id", new QFilter("sourceprop", "in", propIdList).toArray())).map(rel -> rel.get("id")).collect(Collectors.toList()))) {
            dataList.add(new PresetDataResultBo("hrbm_proprel", propRelIdList));
        }
    }

    private String sqlResultStr(String tableStr, String RollbackContentString) {
        StringBuilder stringBuilder = new StringBuilder("--------------------------------------------- ");
        stringBuilder.append(tableStr);
        stringBuilder.append(" ---------------------------------------------").append("\n");
        stringBuilder.append(RollbackContentString);
        return stringBuilder.toString();
    }

    private String sqlResultStr(List<String> sqlList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String sqlResult : sqlList) {
            stringBuilder.append(sqlResult);
        }
        return stringBuilder.toString();
    }

    private Map<String, String> buildEntryFilter(MainEntityType entityType, List<PresetDataResultBo> subDataList) {
        HashMap<String, String> filters = new HashMap<String, String>(subDataList.size());
        for (PresetDataResultBo bo : subDataList) {
            String entryNumber = bo.getNumber();
            DynamicProperty type = entityType.getProperty(entryNumber);
            if (type == null || !(type instanceof EntryProp)) continue;
            EntryProp entryType = (EntryProp)type;
            String entryId = entryType.getDynamicCollectionItemPropertyType().getPrimaryKey().getAlias();
            StringBuilder sb = new StringBuilder();
            sb.append(entryId).append(ENTRY_Q_FILTER_STRING).append(Joiner.on((char)',').join(bo.getIdList())).append(')');
            filters.put(entryNumber, sb.toString());
        }
        return filters;
    }
}

