/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.model.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.model.IAppDomainService;
import kd.hdtc.hrbm.business.domain.model.IBizObjDomainService;
import kd.hdtc.hrbm.business.domain.model.bo.LeftTreeNodeBo;
import kd.hdtc.hrbm.business.domain.model.bo.LogicEntityLeftTreeNodeBo;
import kd.hdtc.hrbm.business.domain.model.entity.IAppEntityService;
import kd.hdtc.hrbm.business.domain.model.entity.IBizObjEntityService;
import kd.hdtc.hrbm.business.domain.model.entity.ICloudEntityService;
import kd.hdtc.hrbm.business.domain.model.entity.ILogicEntityEntityService;
import kd.hdtc.hrbm.common.constant.HRBMAppConstants;
import kd.hdtc.hrbm.common.enums.CloudAppMappingEnum;
import kd.hdtc.hrbm.common.exception.HRBMBizException;
import kd.hdtc.hrbm.common.msgEnum.BizModelMsgEnum;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class BizObjDomainServiceImpl
implements IBizObjDomainService {
    private static final Log LOG = LogFactory.getLog(BizObjDomainServiceImpl.class);
    private final IAppEntityService appEntityService = ServiceFactory.getService(IAppEntityService.class);
    private final IBizObjEntityService bizObjEntityService = ServiceFactory.getService(IBizObjEntityService.class);
    private final ICloudEntityService cloudEntityService = ServiceFactory.getService(ICloudEntityService.class);
    private final ILogicEntityEntityService logicEntityEntityService = ServiceFactory.getService(ILogicEntityEntityService.class);
    private final IAppDomainService appDomainService = ServiceFactory.getService(IAppDomainService.class);
    private static final String CLOUD_SELECT_COLS = "number,name,index";
    private static final String APP_SELECT_COLS = "cloud, number, name,index";
    private static final String BIZ_OBJ_SELECT_COLS = "app, number, name,index";
    private static final String SELECT_COLS = "name,number,description,index,app,enable,app.cloud";
    private static final String LOGIC_ENTITY_SELECT_COLS = "id,name,number,cusstatus,deleted,bizobj,index";

    @Override
    public TreeNode getLeftTreeNode(boolean isContainApp) {
        DynamicObject[] cloudDys = this.cloudEntityService.query(CLOUD_SELECT_COLS, new QFilter[]{QFilterConstants.Q_ENABLE});
        if (isContainApp) {
            DynamicObject[] appDys = this.appEntityService.query(APP_SELECT_COLS, new QFilter[]{QFilterConstants.Q_ENABLE});
            QFilter typeFilter = new QFilter("type", "in", (Object)HRBMAppConstants.BIZOBJ_TYPE_SET);
            DynamicObject[] bizObjDys = this.bizObjEntityService.query(BIZ_OBJ_SELECT_COLS, new QFilter[]{QFilterConstants.Q_ENABLE, typeFilter});
            return new LeftTreeNodeBo(cloudDys, appDys, bizObjDys).buildTreeNode(true);
        }
        return new LeftTreeNodeBo(cloudDys).buildTreeNode(false);
    }

    @Override
    public TreeNode getLeftF7TreeNode(boolean isContainLogicEntity, QFilter cloudFilter, QFilter appFilter, QFilter bizObjFilter, QFilter logicEntityFilter) {
        DynamicObject[] cloudDys = this.cloudEntityService.query(CLOUD_SELECT_COLS, new QFilter[]{cloudFilter, QFilterConstants.Q_ENABLE});
        DynamicObject[] appDys = this.appEntityService.query(APP_SELECT_COLS, new QFilter[]{appFilter, QFilterConstants.Q_ENABLE});
        QFilter bizObjectSelectFilter = new QFilter("type", "in", (Object)HRBMAppConstants.BIZOBJ_TYPE_SET);
        if (bizObjFilter != null) {
            bizObjectSelectFilter.and(bizObjFilter).and(QFilterConstants.Q_ENABLE);
        }
        DynamicObject[] bizObjDys = this.bizObjEntityService.query(BIZ_OBJ_SELECT_COLS, new QFilter[]{bizObjectSelectFilter});
        if (isContainLogicEntity) {
            QFilter validFilter = new QFilter("cusstatus", "=", (Object)"1");
            validFilter.and(new QFilter("deleted", "=", (Object)"0"));
            if (logicEntityFilter != null) {
                validFilter.and(logicEntityFilter).and(QFilterConstants.Q_ENABLE);
            }
            DynamicObject[] logicEntityDys = this.logicEntityEntityService.query(LOGIC_ENTITY_SELECT_COLS, validFilter.toArray());
            return new LogicEntityLeftTreeNodeBo(cloudDys, appDys, bizObjDys, logicEntityDys).buildTreeNode(true);
        }
        return new LogicEntityLeftTreeNodeBo(cloudDys, appDys, bizObjDys, null).buildTreeNode(true);
    }

    @Override
    public List<TreeNode> getSearchTreeResult(TreeNode rootNode, String searchText) {
        ArrayList treeNodeList = Lists.newArrayList();
        this.getMateNode(treeNodeList, rootNode, searchText);
        return treeNodeList;
    }

    @Override
    public DynamicObject getBizObjInfoById(Object id) {
        return this.bizObjEntityService.query(SELECT_COLS, id);
    }

    @Override
    public DynamicObject getValidBizObjInfoById(Object id) {
        QFilter qFilter = new QFilter("id", "=", id);
        qFilter.and("enable", "=", (Object)"1");
        return this.bizObjEntityService.queryOne(SELECT_COLS, new QFilter[]{qFilter});
    }

    @Override
    public List<DynamicObject> getBizObjInfoByAppIds(Collection<Long> appIds) {
        if (CollectionUtils.isEmpty(appIds)) {
            return new ArrayList<DynamicObject>();
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("app", "in", appIds)};
        Object[] bizObjArr = this.bizObjEntityService.query("id,name,number,type,app,index", qFilters);
        if (ObjectUtils.isEmpty((Object[])bizObjArr)) {
            return new ArrayList<DynamicObject>();
        }
        return ConvertUtils.toList((Object[])bizObjArr);
    }

    @Override
    public List<DynamicObject> getBizObjInfoByAppId(Long appId) {
        QFilter[] qFilters = new QFilter[3];
        qFilters[0] = new QFilter("enable", "=", (Object)"1");
        qFilters[1] = new QFilter("app", "=", (Object)appId);
        Object[] bizObjArr = this.bizObjEntityService.query("id,name,number,type", qFilters);
        if (ObjectUtils.isEmpty((Object[])bizObjArr)) {
            return new ArrayList<DynamicObject>();
        }
        return ConvertUtils.toList((Object[])bizObjArr);
    }

    @Override
    public List<DynamicObject> getBizObjInfoByCloudId(Long cloudId) {
        if (cloudId == null) {
            return new ArrayList<DynamicObject>();
        }
        List<DynamicObject> appList = this.appDomainService.getAppInfoListByCloudId(cloudId);
        if (CollectionUtils.isEmpty(appList)) {
            return new ArrayList<DynamicObject>();
        }
        Set<Long> appIdSet = appList.stream().map(app -> app.getLong("id")).collect(Collectors.toSet());
        return this.getBizObjInfoByAppIds(appIdSet);
    }

    @Override
    public DynamicObject addBizObjByBDLogicEntity(ILocaleString name, String number, Long cloudId) {
        DynamicObject dbBizObj = this.bizObjEntityService.queryOne("id", new QFilter("number", "=", (Object)number).toArray());
        if (!ObjectUtils.isEmpty((Object)dbBizObj)) {
            dbBizObj.set("name", (Object)name);
            this.bizObjEntityService.save(dbBizObj);
            return dbBizObj;
        }
        DynamicObject bizObj = this.bizObjEntityService.generateEmptyDynamicObject();
        long id = ID.genLongId();
        bizObj.set("id", (Object)id);
        bizObj.set("app", (Object)this.getAppId(cloudId));
        bizObj.set("number", (Object)number);
        bizObj.set("name", (Object)name);
        bizObj.set("type", (Object)"40");
        bizObj.set("isaddlogic", (Object)"0");
        bizObj.set("index", (Object)this.getIndex());
        bizObj.set("classify", (Object)"20");
        bizObj.set("enable", (Object)"1");
        bizObj.set("status", (Object)"C");
        this.bizObjEntityService.save(bizObj);
        return bizObj;
    }

    private Integer getIndex() {
        DynamicObject[] bizObjArr = this.bizObjEntityService.query("id,index", new QFilter[]{QFilterConstants.Q_ENABLE});
        Integer index = Arrays.stream(bizObjArr).map(biz -> biz.getInt("index")).distinct().sorted(Comparator.reverseOrder()).findFirst().orElse(null);
        if (index != null) {
            return index + 1;
        }
        return 999;
    }

    private long getAppId(Long cloudId) {
        DynamicObject cloud = this.cloudEntityService.query("id,number", cloudId);
        CloudAppMappingEnum cloudAppMappingByCloud = CloudAppMappingEnum.getCloudAppMappingByCloud((String)cloud.getString("number"));
        String app = cloudAppMappingByCloud.getApp();
        QFilter cloudFilter = new QFilter("cloud", "=", (Object)cloudId);
        Object[] appArr = this.appEntityService.query("id,appnumber", new QFilter[]{cloudFilter, QFilterConstants.Q_ENABLE});
        if (ObjectUtils.isEmpty((Object[])appArr)) {
            throw new HRBMBizException(BizModelMsgEnum.CURRENT_CLOUD_NOT_APP.get());
        }
        long appId = appArr[0].getLong("id");
        for (int i = 0; i < appArr.length; ++i) {
            DynamicObjectCollection appCol = appArr[i].getDynamicObjectCollection("appnumber");
            long count = appCol.stream().map(ap -> ap.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(ap -> ap.getString("number")).filter(ap -> HRStringUtils.equals((String)ap, (String)app)).count();
            if (count <= 0L) continue;
            appId = appArr[i].getLong("id");
            break;
        }
        return appId;
    }

    private void getMateNode(List<TreeNode> treeNodeList, TreeNode currNode, String searchText) {
        List nodeList = currNode.getChildren();
        if (CollectionUtils.isEmpty((Collection)nodeList)) {
            return;
        }
        nodeList.forEach(node -> {
            String nodeName = node.getText();
            if (nodeName.contains(searchText)) {
                treeNodeList.add((TreeNode)node);
            }
            this.getMateNode(treeNodeList, (TreeNode)node, searchText);
        });
    }
}

