/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.model.impl;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.model.IEntityCardDomainService;
import kd.hdtc.hrbm.business.domain.model.entity.IEntityCardEntityService;
import kd.hdtc.hrbm.business.domain.model.entity.IEntityRelCardEntityService;
import kd.hdtc.hrbm.business.domain.model.entity.ILogicEntityEntityService;
import kd.hdtc.hrdbs.common.util.ObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class EntityCardDomainServiceImpl
implements IEntityCardDomainService {
    private final IEntityCardEntityService entityCardEntryService = ServiceFactory.getService(IEntityCardEntityService.class);
    private final IEntityRelCardEntityService entityRelCardEntityService = ServiceFactory.getService(IEntityRelCardEntityService.class);
    private final ILogicEntityEntityService logicEntityEntityService = ServiceFactory.getService(ILogicEntityEntityService.class);
    private static final String LOGIC_REL_CARD_FIELDS = String.join((CharSequence)",", "logicentity", "rellogicentity");
    private static final String LOGIC_CARD_FIELDS = String.join((CharSequence)",", "metanumber", "logicentity", "number", "name", "description", "index");

    @Override
    public void saveEntityCardAndRelEntityCard(long logicEntityId, String metaNumber) {
        if (HRStringUtils.isEmpty((String)metaNumber)) {
            return;
        }
        DynamicObject logicEntityDy = this.logicEntityEntityService.queryOne("id,number,name", new QFilter[]{new QFilter("id", "=", (Object)logicEntityId)});
        if (HRObjectUtils.isEmpty((Object)logicEntityDy)) {
            return;
        }
        QFilter logicEntityFilter = new QFilter("logicentity", "=", (Object)logicEntityId);
        DynamicObject entityCardDy = this.entityCardEntryService.queryOne(LOGIC_CARD_FIELDS, new QFilter[]{logicEntityFilter});
        if (!HRObjectUtils.isEmpty((Object)entityCardDy)) {
            return;
        }
        entityCardDy = this.entityCardEntryService.generateEmptyDynamicObject();
        entityCardDy.set("logicentity", (Object)logicEntityId);
        entityCardDy.set("metanumber", (Object)metaNumber);
        entityCardDy.set("number", (Object)logicEntityDy.getString("number"));
        String name = logicEntityDy.getString("name");
        entityCardDy.set("name", (Object)name);
        entityCardDy.set("description", (Object)String.format(ResManager.loadKDString((String)"\u70b9\u51fb\u53ef\u5feb\u901f\u8c03\u6574%s\u89c6\u56fe", (String)"EntityCardDomainServiceImpl_0", (String)"hdtc-hrbm-business", (Object[])new Object[0]), name));
        entityCardDy.set("index", (Object)1);
        this.entityCardEntryService.save(entityCardDy);
        this.entityRelCardEntityService.saveEntityRelCard(logicEntityId, logicEntityId);
    }

    @Override
    public void saveEntityRelCard(long logicEntityId, long relLogicEntityId) {
        DynamicObject entityRelCardDy = this.entityRelCardEntityService.queryOne(LOGIC_REL_CARD_FIELDS, new QFilter[]{new QFilter("logicentity", "=", (Object)logicEntityId)});
        if (!HRObjectUtils.isEmpty((Object)entityRelCardDy)) {
            return;
        }
        if (ObjectUtils.isEmpty((Object)relLogicEntityId)) {
            return;
        }
        this.entityRelCardEntityService.saveEntityRelCard(logicEntityId, relLogicEntityId);
    }

    @Override
    public DynamicObject[] queryEntityCards(long logicEntityId) {
        Object[] relCards = this.entityRelCardEntityService.query(LOGIC_REL_CARD_FIELDS, new QFilter[]{new QFilter("logicentity", "=", (Object)logicEntityId)});
        if (ArrayUtils.isEmpty((Object[])relCards)) {
            return new DynamicObject[0];
        }
        Set relLogicEntitySet = Arrays.stream(relCards).map(dynamicObject -> dynamicObject.getLong("rellogicentity.id")).collect(Collectors.toSet());
        return this.entityCardEntryService.query(LOGIC_CARD_FIELDS, new QFilter[]{new QFilter("logicentity", "in", relLogicEntitySet)}, "index asc");
    }

    @Override
    public void deleteByLogicEntityIds(Set<Long> logicEntityIdSet) {
        this.entityCardEntryService.deleteByFilter(new QFilter("logicentity", "in", logicEntityIdSet).toArray());
        this.entityRelCardEntityService.deleteByFilter(new QFilter("rellogicentity", "in", logicEntityIdSet).toArray());
    }
}

