/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.model.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.baseconfig.INumberMaxIndexDomainService;
import kd.hdtc.hrbm.business.domain.model.IBizObjDomainService;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrbm.business.domain.model.bo.ILogicEntityNumberGenerateBo;
import kd.hdtc.hrbm.business.domain.model.bo.logicentity.NormalLogicEntityNumberGenerateBo;
import kd.hdtc.hrbm.business.domain.model.entity.ICloudEntityService;
import kd.hdtc.hrbm.business.domain.model.entity.ILogicEntityEntityService;
import kd.hdtc.hrbm.business.domain.model.entity.ILogicEntityRelEntityService;
import kd.hdtc.hrbm.business.domain.model.factory.LogicEntityNumberGenerateBoFactory;
import kd.hdtc.hrbm.common.constant.HRBMAppConstants;
import kd.hdtc.hrbm.common.enums.CloudAppMappingEnum;
import kd.hdtc.hrbm.common.pojo.LogicEntityPageSourceParam;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdbs.common.util.ObjectUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hies.business.export.ExportHeaderWriterFormat;

public class LogicEntityDomainServiceImpl
implements ILogicEntityDomainService {
    private static final Log LOG = LogFactory.getLog(LogicEntityDomainServiceImpl.class);
    private static final String EXT = "ext";
    private static final String HSPM_APP_ID = "1WXBPN7+OHJZ";
    private static final String SELECT_COLS = "id,number,name,bizobj,template,bizunit,cusstatus,description,isv,pid,pid.extmetanum,mainentity,changetitle,maintitle,location,entryentity,sublogicentity,extmetanum,menulocal,mulline,enable,template,controlentity";
    ILogicEntityEntityService logicEntityEntityService = ServiceFactory.getService(ILogicEntityEntityService.class);
    ILogicEntityRelEntityService logicEntityRelEntityService = ServiceFactory.getService(ILogicEntityRelEntityService.class);
    ICloudEntityService cloudEntityService = ServiceFactory.getService(ICloudEntityService.class);
    IBizObjDomainService bizObjDomainService = ServiceFactory.getService(IBizObjDomainService.class);
    INumberMaxIndexDomainService maxIndexDomainService = ServiceFactory.getService(INumberMaxIndexDomainService.class);

    @Override
    public List<QFilter> getAddEntityMetadataF7QFilter(Long logicEntityId) {
        DynamicObject logicEntity = this.logicEntityEntityService.query("id,bizobj.app.id,bizobj.number", logicEntityId);
        if (logicEntity == null) {
            return null;
        }
        long appId = logicEntity.getLong("bizobj.app.id");
        String bizObjNumber = logicEntity.getString("bizobj.number");
        FormMetadata formMetadata = MetadataUtils.getFormMetadataByNumber((String)bizObjNumber);
        HashSet platAppIdSet = Sets.newHashSet((Object[])new String[]{formMetadata.getBizappId()});
        Set extAppIdSet = kd.hdtc.hrdbs.business.domain.metadata.impl.util.MetadataUtils.getExtAppInfoByAppIds((Set)platAppIdSet);
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)10);
        qFilterList.add(new QFilter("bizappid", "in", (Object)extAppIdSet));
        qFilterList.add(new QFilter("bizappid.isv", "=", (Object)ISVService.getISVInfo().getId()));
        qFilterList.add(new QFilter("modeltype", "=", (Object)"BaseFormModel"));
        List<DynamicObject> bizObjList = this.bizObjDomainService.getBizObjInfoByAppId(appId);
        Set<Long> bizObjIdSet = bizObjList.stream().filter(biz -> HRBMAppConstants.BIZOBJ_TYPE_SET.contains(biz.getString("type"))).map(biz -> biz.getLong("id")).collect(Collectors.toSet());
        List<DynamicObject> logicEntityList = this.getLogicEntityByBizObjIdSet(bizObjIdSet);
        Set logicEntityIdSet = logicEntityList.stream().map(logic -> logic.getLong("id")).collect(Collectors.toSet());
        Object[] logicRelMetaNumArr = this.logicEntityRelEntityService.query("metadatanum", new QFilter("logicentity", "in", logicEntityIdSet).toArray());
        if (ObjectUtils.isEmpty((Object[])logicRelMetaNumArr)) {
            return qFilterList;
        }
        Set metaDataNumSet = Arrays.stream(logicRelMetaNumArr).map(logic -> logic.getString("metadatanum")).collect(Collectors.toSet());
        qFilterList.add(new QFilter("id", "not in", metaDataNumSet));
        return qFilterList;
    }

    @Override
    public DynamicObject structLogicEntityAndRel(String id, String curMainEntity, MainEntityType mainEntityType, String curNodeId) {
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject logicEntity = this.logicEntityEntityService.generateEmptyDynamicObject();
        long logicEntityId = ID.genLongId();
        logicEntity.set("id", (Object)logicEntityId);
        logicEntity.set("name", (Object)mainEntityType.getDisplayName());
        logicEntity.set("number", (Object)mainEntityType.getName());
        logicEntity.set("pid", (Object)ConvertUtils.toLong((Object)curMainEntity));
        logicEntity.set("bizobj", (Object)ConvertUtils.toLong((Object)curNodeId));
        logicEntity.set("type", (Object)"10");
        logicEntity.set("isv", (Object)ISVService.getISVInfo().getId());
        logicEntity.set("index", (Object)this.getLogicEntityIndex(ConvertUtils.toLong((Object)curNodeId)));
        logicEntity.set("controlentity", (Object)BaseDataServiceHelper.checkBaseDataCtrl((String)id));
        logicEntity.set("cusstatus", (Object)"1");
        logicEntity.set("creator", (Object)currUserId);
        logicEntity.set("enable", (Object)"1");
        logicEntity.set("status", (Object)"C");
        this.logicEntityEntityService.save(logicEntity);
        DynamicObject logicEntityRel = this.logicEntityRelEntityService.generateEmptyDynamicObject();
        logicEntityRel.set("logicentity", (Object)logicEntityId);
        logicEntityRel.set("metadatanum", (Object)mainEntityType.getName());
        logicEntityRel.set("metadataname", (Object)mainEntityType.getDisplayName());
        logicEntityRel.set("table", (Object)mainEntityType.getAlias());
        logicEntityRel.set("creator", (Object)currUserId);
        this.logicEntityRelEntityService.save(logicEntityRel);
        return logicEntity;
    }

    @Override
    public DynamicObject[] getRootLogicEntityByBizObjId(long id) {
        QFilter deleteQFilter = new QFilter("deleted", "=", (Object)"0");
        QFilter bizObjQFilter = new QFilter("bizobj", "=", (Object)id);
        QFilter rootQFilter = new QFilter("rootentity", "=", (Object)Boolean.TRUE);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        Object[] result = this.logicEntityEntityService.query("id,name,number,type,index,mulline,isv,cusstatus,description,mainentity,pid,cusstatus,bizrule,mainentity", deleteQFilter.and(bizObjQFilter).and(rootQFilter).and(enableFilter).toArray());
        if (ObjectUtils.isEmpty((Object[])result)) {
            return new DynamicObject[0];
        }
        return result;
    }

    @Override
    public DynamicObject[] getLogicEntityByBizObjId(Set<Long> idSet) {
        QFilter deleteQFilter = new QFilter("deleted", "=", (Object)"0");
        QFilter bizObjQFilter = new QFilter("bizobj", "in", idSet);
        QFilter typeQFilter = new QFilter("type", "like", (Object)"%10%").or(new QFilter("type", "like", (Object)"%30%"));
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        Object[] result = this.logicEntityEntityService.query("id,name,number,type,index,mulline,isv,cusstatus,description,mainentity,pid,cusstatus,bizrule,mainentity,bizobj", deleteQFilter.and(bizObjQFilter).and(typeQFilter).and(enableFilter).toArray());
        if (HRArrayUtils.isEmpty((Object[])result)) {
            return new DynamicObject[0];
        }
        return result;
    }

    @Override
    public List<DynamicObject> getLogicEntityByBizObjIdSet(Set<Long> idSet) {
        QFilter deleteQFilter = new QFilter("deleted", "=", (Object)"0");
        QFilter bizObjQFilter = new QFilter("bizobj", "in", idSet);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        Object[] result = this.logicEntityEntityService.query("id", deleteQFilter.and(bizObjQFilter).and(enableFilter).toArray());
        if (ObjectUtils.isEmpty((Object[])result)) {
            return new ArrayList<DynamicObject>();
        }
        return ConvertUtils.toList((Object[])result);
    }

    @Override
    public DynamicObject getLogicEntityInfoById(Object id) {
        return this.logicEntityEntityService.query(SELECT_COLS, ConvertUtils.toLong((Object)id));
    }

    @Override
    public DynamicObject[] getLogicEntityInfoByIdList(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return new DynamicObject[0];
        }
        QFilter idFilter = new QFilter("id", "in", idList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return this.logicEntityEntityService.query(SELECT_COLS, new QFilter[]{idFilter, enableFilter});
    }

    @Override
    public DynamicObject getValidLogicEntityInfoById(Object id) {
        QFilter qFilter = new QFilter("id", "=", id);
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("cusstatus", "=", (Object)"1");
        return this.logicEntityEntityService.queryOne(SELECT_COLS, new QFilter[]{qFilter});
    }

    @Override
    public DynamicObject[] getLogicEntityBySubLogicEntity(Long mainLogicEntityId, Long subLogicEntityId) {
        QFilter mainFilter = new QFilter("pid", "=", (Object)mainLogicEntityId);
        QFilter subFilter = new QFilter("sublogicentity", "=", (Object)subLogicEntityId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return this.logicEntityEntityService.query("bizobj,template,cusstatus,isv,pid,changetitle,maintitle,location,sublogicentity", new QFilter[]{mainFilter, subFilter, enableFilter});
    }

    @Override
    public DynamicObject[] getLogicEntityInfoByNumber(String number) {
        return this.logicEntityEntityService.query("id,number,name,pid,mainentity,cusstatus", new QFilter("number", "=", (Object)number).toArray());
    }

    @Override
    public void saveLogicEntity(DynamicObject dyc) {
        this.logicEntityEntityService.save(dyc);
    }

    @Override
    public String getLogicEntityNumber(Long mainEntityId, String openType, Long nodeId) {
        StringBuilder sb = new StringBuilder(ISVService.getISVInfo().getId()).append("_");
        String appId = this.getLogicEntityAppId(mainEntityId, openType, nodeId);
        sb.append(appId).append("_");
        return sb.toString();
    }

    private String getMaxNumber(String isv, String appId) {
        String suffixNumber = this.maxIndexDomainService.getMaxIndex(isv, appId);
        suffixNumber = HRStringUtils.equals((String)suffixNumber, (String)"0000") ? this.getsuffixNumberInDb(isv, appId) : String.format("%04d", Integer.parseInt(suffixNumber) + 1);
        return suffixNumber;
    }

    private String getsuffixNumberInDb(String isv, String appId) {
        QFilter isvQFilter = new QFilter("isv", "=", (Object)isv);
        if (HRStringUtils.equals((String)isv, (String)"kingdee")) {
            isvQFilter.and("number", "like", (Object)(appId + "_ext____"));
        } else {
            isvQFilter.and("number", "like", (Object)(isv + "_" + appId + "_ext" + "%"));
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] logicDycArr = this.logicEntityEntityService.query("number", isvQFilter.and(enableFilter).toArray());
        Optional<Integer> maxNumber = Arrays.stream(logicDycArr).map(dyc -> dyc.getString("number")).map(number -> number.substring(number.lastIndexOf(EXT) + 3)).map(number -> Integer.parseInt(number)).max(Comparator.comparingInt(a -> a));
        if (maxNumber.isPresent()) {
            return String.format("%04d", maxNumber.get() + 1);
        }
        return "0001";
    }

    @Override
    public Integer getLogicEntityIndex(Long bizObjId) {
        if (ObjectUtils.isEmpty((Object)bizObjId)) {
            return 1;
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] logicEntityArr = this.logicEntityEntityService.query("index", new QFilter("bizobj", "=", (Object)bizObjId).and(enableFilter).toArray());
        if (logicEntityArr.length == 0) {
            return 1;
        }
        Optional<Integer> maxIndex = Arrays.stream(logicEntityArr).map(prop -> prop.getInt("index")).sorted(Comparator.comparing(Integer::intValue).reversed()).findFirst();
        int index = maxIndex.get();
        if (index >= HRBMAppConstants.LOGICENTITY_MAX_INDEX) {
            return HRBMAppConstants.LOGICENTITY_MAX_INDEX;
        }
        return index + 1;
    }

    @Override
    public void handleCustomColumn(ExportHeaderWriterFormat headerWriterFormat, Map<String, String> addFieldAndFieldNameMap, Map<String, String> addPostFieldAndFieldNameMap) {
        LinkedList<String> fields = new LinkedList<String>();
        int addCustomColumnCount = 0;
        if (CollectionUtils.isNotEmpty(addFieldAndFieldNameMap)) {
            this.addCustomColumn(headerWriterFormat, addFieldAndFieldNameMap, fields);
            addCustomColumnCount += addFieldAndFieldNameMap.size();
        }
        fields.addAll(headerWriterFormat.getFields());
        if (CollectionUtils.isNotEmpty(addPostFieldAndFieldNameMap)) {
            this.addCustomColumn(headerWriterFormat, addPostFieldAndFieldNameMap, fields);
            addCustomColumnCount += addPostFieldAndFieldNameMap.size();
        }
        headerWriterFormat.setFields(fields);
        if (CollectionUtils.isNotEmpty((Collection)headerWriterFormat.getNext())) {
            List exportHeaderWriterFormatList = headerWriterFormat.getNext();
            for (ExportHeaderWriterFormat exportHeaderWriterFormat : exportHeaderWriterFormatList) {
                exportHeaderWriterFormat.setStartColNumber(exportHeaderWriterFormat.getStartColNumber() + addCustomColumnCount);
            }
        }
    }

    @Override
    public boolean existsLogicEntityByPidAndName(Long pid, String name, Long logicEntityId, Long bizObjId) {
        QFilter pidQf = new QFilter("pid", "=", (Object)pid);
        pidQf.and(new QFilter("name", "=", (Object)name));
        pidQf.and(new QFilter("bizobj", "=", (Object)bizObjId));
        if (logicEntityId != 0L) {
            pidQf.and(new QFilter("id", "!=", (Object)logicEntityId));
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        pidQf.and(enableFilter);
        return this.logicEntityEntityService.isExists(pidQf);
    }

    @Override
    public String getLogicEntityAppId(Long mainEntityId, String openType, Long nodeId) {
        String appId = "";
        if (HRStringUtils.equals((String)openType, (String)"bizmode")) {
            String extMetaNum;
            boolean exist;
            DynamicObject logicEntityInfo = this.getLogicEntityInfoById(mainEntityId);
            if (logicEntityInfo != null && (exist = MetadataUtils.isExist((String)(extMetaNum = this.getExtMetadataNumber(logicEntityInfo))))) {
                appId = kd.hdtc.hrdbs.business.domain.metadata.impl.util.MetadataUtils.getMainEntityType((String)extMetaNum).getAppId();
            }
        } else {
            CloudAppMappingEnum cloudAppMappingByCloud;
            DynamicObject cloud = this.cloudEntityService.query("id,number", nodeId);
            if (cloud != null && (cloudAppMappingByCloud = CloudAppMappingEnum.getCloudAppMappingByCloud((String)cloud.getString("number"))) != null) {
                appId = cloudAppMappingByCloud.getApp();
            }
        }
        return appId;
    }

    /*
     * Exception decompiling
     */
    @Override
    public String applyMaxIndex(String isv, String appId, String suffix) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String generateLockKey(String isv, String appId) {
        StringBuilder stringBuilder = new StringBuilder("hrbm_logicentity_number_");
        stringBuilder.append(isv).append("_").append(appId);
        return stringBuilder.toString();
    }

    private String getExtMetadataNumber(DynamicObject logicEntityDynamicObject) {
        String extMetaNumber = logicEntityDynamicObject.getString("extmetanum");
        if (StringUtils.isBlank((CharSequence)extMetaNumber)) {
            extMetaNumber = logicEntityDynamicObject.getString("number");
        }
        return extMetaNumber;
    }

    private void addCustomColumn(ExportHeaderWriterFormat headerWriterFormat, Map<String, String> addFieldAndFieldNameMap, List<String> fields) {
        addFieldAndFieldNameMap.forEach((field, fieldName) -> {
            fields.add((String)field);
            Map<String, Object> cloudProperty = this.generateProperty((String)fieldName, "varchar");
            headerWriterFormat.getProperties().put(field, cloudProperty);
        });
    }

    private Map<String, Object> generateProperty(String columnName, String inputType) {
        HashMap<String, Object> property = new HashMap<String, Object>(16);
        property.put("DisplayName", columnName);
        property.put("InputType", inputType);
        property.put("PropType", null);
        property.put("InputDesc", columnName);
        return property;
    }

    @Override
    public boolean checkNumberIsEnable(String extCase, String isvType) {
        if (StringUtils.isEmpty((String)extCase)) {
            return Boolean.FALSE;
        }
        LogicEntityPageSourceParam param = new LogicEntityPageSourceParam(extCase);
        ILogicEntityNumberGenerateBo logicEntityNumberGenerateBo = LogicEntityNumberGenerateBoFactory.generate(param);
        if (logicEntityNumberGenerateBo instanceof NormalLogicEntityNumberGenerateBo && !StringUtils.equals((String)"10", (String)isvType)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

