/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.model.impl;

import com.google.common.base.Joiner;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hdtc.hrbm.business.domain.model.IMetaDataPresetDataDomainService;
import kd.hdtc.hrdbs.business.model.MetaDataConfigBo;
import kd.hdtc.hrdbs.business.model.MultiEntryDecodeBo;
import kd.hdtc.hrdbs.business.model.MultiTableDecodeBo;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MetaDatePresetDataDomainServiceImpl
implements IMetaDataPresetDataDomainService {
    private static final long DEFAULT_ORG_ID = Long.parseLong("100000");
    private static final long DEFAULT_USERID = Long.parseLong("1");
    private static final long DEFAULT_VALUE_ZERO = Long.parseLong("0");
    private Map<String, List<Object>> pkDataMap = new HashMap<String, List<Object>>();
    private static final String[] PRE_DEFAULT_USER_STR = new String[]{"fcreatorid", "fmodifierid"};
    private static final String[] PRE_DEFAULT_ORG_STR = new String[]{"fcreateorgid", "forgid", "fuseorgid"};
    private static final String IS_SYS_PRESET = "1";
    private static final String KEY_EMPTY = "";
    private static final String WHERE_STRING = " where ";
    private static final String SOURCE_TYPE = "EXPORT_PAGE";
    private static final String META_PATH = "/metadata/";

    @Override
    public String getPresetDataString(String entityNumber, String qFilter) {
        this.pkDataMap = new HashMap<String, List<Object>>();
        List<MetaDataConfigBo> metaList = this.buildMetaConfigBoList(entityNumber, qFilter);
        if (CollectionUtils.isEmpty(metaList)) {
            return KEY_EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (MetaDataConfigBo dataConfig : metaList) {
            this.appendSql(dataConfig, stringBuilder);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getMetaRollbackContentString(String entityNUmber, String entityId) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DELETE FROM T_META_BIZUNITRELFORM WHERE FFORMID = '").append(entityId).append("';\n");
        stringBuilder.append("DELETE FROM T_META_FORMDESIGN WHERE FID = '").append(entityId).append("';\n");
        stringBuilder.append("DELETE FROM T_META_FORMDESIGN_L WHERE FID = '").append(entityId).append("';\n");
        stringBuilder.append("DELETE FROM T_META_ENTITYDESIGN WHERE FID = '").append(entityId).append("';\n");
        stringBuilder.append("DELETE FROM T_META_ENTITYDESIGN_L WHERE FID = '").append(entityId).append("';\n");
        stringBuilder.append("DELETE FROM T_META_FORM WHERE FID = '").append(entityId).append("';\n");
        stringBuilder.append("DELETE FROM T_META_ENTITY WHERE FID = '").append(entityId).append("';\n");
        stringBuilder.append("DELETE FROM T_META_ENTITYINFO WHERE FID = '").append(entityNUmber).append("';\n");
        stringBuilder.append("DELETE FROM T_META_MAINENTITYINFO WHERE FID = '").append(entityNUmber).append("';\n");
        stringBuilder.append("DELETE FROM T_META_MAINENTITYINFO_L WHERE FID = '").append(entityNUmber).append("';\n");
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    @Override
    public String getPresetDataRollbackStringOnlyEntry(String entityNumber, String qFilter, Map<String, String> entryQFilter) {
        List<MetaDataConfigBo> metaList = this.buildMetaConfigBoListOnlyEntry(entityNumber, qFilter, entryQFilter);
        if (CollectionUtils.isEmpty(metaList)) {
            return KEY_EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (MetaDataConfigBo dataConfig : metaList) {
            this.appendDeleteSql(dataConfig, stringBuilder);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getPresetDataRollbackString(String entityNumber, String qFilter) {
        List<MetaDataConfigBo> metaList = this.buildMetaConfigBoList(entityNumber, qFilter);
        if (CollectionUtils.isEmpty(metaList)) {
            return KEY_EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (MetaDataConfigBo dataConfig : metaList) {
            this.appendDeleteSql(dataConfig, stringBuilder);
        }
        return stringBuilder.toString();
    }

    private void appendDeleteSql(MetaDataConfigBo metaDataConfigBo, StringBuilder stringBuilder) {
        String where = this.getWhere(metaDataConfigBo);
        String alias = metaDataConfigBo.getAlias();
        if (alias == null || alias.length() == 0 || KEY_EMPTY.equals(where)) {
            return;
        }
        String sql = "select " + this.getFieldKey(metaDataConfigBo) + " from " + alias + " " + where;
        DB.query((DBRoute)DBRoute.of((String)metaDataConfigBo.getDbRouteKey()), (String)sql, resultSet -> {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                this.appendDeleteSQL(stringBuilder, resultSetMetaData, metaDataConfigBo, resultSet);
            }
            return KEY_EMPTY;
        });
    }

    private List<MetaDataConfigBo> buildMetaConfigBoListOnlyEntry(String entityNumber, String qFilter, Map<String, String> entryQFilter) {
        if (CollectionUtils.isEmpty(entryQFilter)) {
            return this.buildMetaConfigBoList(entityNumber, qFilter);
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        if (null == entityType) {
            return null;
        }
        ArrayList<MetaDataConfigBo> metaList = new ArrayList<MetaDataConfigBo>(16);
        MetaDataConfigBo metaDataConfigBo = new MetaDataConfigBo(entityType, null);
        metaDataConfigBo.setWhere(qFilter);
        MultiTableDecodeBo.addMetaDataConfig((MetaDataConfigBo)metaDataConfigBo, metaList, null);
        MultiTableDecodeBo multiTableDecodeBo = new MultiTableDecodeBo(metaList);
        multiTableDecodeBo.parseMainMetaData(metaDataConfigBo);
        metaList.clear();
        if (multiTableDecodeBo.isContainMulTab(metaDataConfigBo, (IDataEntityProperty)new EntryProp(), false)) {
            new MultiEntryDecodeBo(metaList).addMetaDataOnlyWithFilter(metaDataConfigBo, entryQFilter);
        }
        return metaList;
    }

    private List<MetaDataConfigBo> buildMetaConfigBoList(String entityNumber, String qFilter) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        if (null == entityType) {
            return null;
        }
        ArrayList<MetaDataConfigBo> metaList = new ArrayList<MetaDataConfigBo>(16);
        MetaDataConfigBo metaDataConfigBo = new MetaDataConfigBo(entityType, null);
        metaDataConfigBo.setWhere(qFilter);
        MultiTableDecodeBo.addMetaDataConfig((MetaDataConfigBo)metaDataConfigBo, metaList, null);
        MultiTableDecodeBo multiTableDecodeBo = new MultiTableDecodeBo(metaList);
        multiTableDecodeBo.parseMainMetaData(metaDataConfigBo);
        if (multiTableDecodeBo.isContainMulTab(metaDataConfigBo, (IDataEntityProperty)new EntryProp(), false)) {
            new MultiEntryDecodeBo(metaList).addMetaData(metaDataConfigBo);
        }
        return metaList;
    }

    private void appendSql(MetaDataConfigBo metaDataConfigBo, StringBuilder stringBuilder) {
        String where = this.getWhere(metaDataConfigBo);
        String alias = metaDataConfigBo.getAlias();
        if (alias == null || alias.length() == 0 || KEY_EMPTY.equals(where)) {
            return;
        }
        String sql = "select " + this.getFieldKey(metaDataConfigBo) + " from " + alias + " " + where;
        DB.query((DBRoute)DBRoute.of((String)metaDataConfigBo.getDbRouteKey()), (String)sql, resultSet -> {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                this.appendDeleteSQL(stringBuilder, resultSetMetaData, metaDataConfigBo, resultSet);
                this.appendInsertSql(resultSet, resultSetMetaData, stringBuilder, metaDataConfigBo);
            }
            return KEY_EMPTY;
        });
    }

    private String getWhere(MetaDataConfigBo metaDataConfigBo) {
        String where = metaDataConfigBo.getWhere();
        if (StringUtils.isNotEmpty((CharSequence)where)) {
            return StringUtils.join((Object[])new String[]{WHERE_STRING, where});
        }
        if (StringUtils.isEmpty((CharSequence)metaDataConfigBo.getTableGroup())) {
            return this.getRefWhere(metaDataConfigBo);
        }
        return this.getExtendTableWhere(metaDataConfigBo);
    }

    private String getRefWhere(MetaDataConfigBo metaDataConfigBo) {
        StringBuilder stringBuilder = new StringBuilder();
        Map refMap = metaDataConfigBo.getReferenceMap();
        boolean isAppendFlag = false;
        for (Map.Entry entry : refMap.entrySet()) {
            List<Object> list;
            String value = ((String)entry.getValue()).toUpperCase(Locale.ROOT);
            String key = (String)entry.getKey();
            if (StringUtils.isEmpty((CharSequence)value) || !key.contains(".") || CollectionUtils.isEmpty(list = this.pkDataMap.get(value))) continue;
            String field = key.substring(key.lastIndexOf(46) + 1);
            if (stringBuilder.length() == 0) {
                stringBuilder.append(WHERE_STRING);
            } else {
                stringBuilder.append(" and ");
            }
            String str = Joiner.on((String)",").join(list);
            stringBuilder.append(field).append(" in(").append(str).append(") ");
            isAppendFlag = true;
        }
        if (!isAppendFlag) {
            return KEY_EMPTY;
        }
        return stringBuilder.toString();
    }

    private String getExtendTableWhere(MetaDataConfigBo metaDataConfigBo) {
        String tableGroup = "_" + metaDataConfigBo.getTableGroup();
        String tableName = metaDataConfigBo.getAlias();
        if (StringUtils.isNotEmpty((CharSequence)tableName) && tableName.contains(tableGroup)) {
            tableName = tableName.substring(0, tableName.indexOf(tableGroup));
        }
        if (CollectionUtils.isEmpty((Collection)metaDataConfigBo.getPkList())) {
            return KEY_EMPTY;
        }
        String filed = ((IDataEntityProperty)metaDataConfigBo.getPkList().get(0)).getAlias();
        String key = (metaDataConfigBo.getAppId() + "." + tableName + "." + ((IDataEntityProperty)metaDataConfigBo.getPkList().get(0)).getAlias()).toUpperCase(Locale.ROOT);
        List<Object> list = this.pkDataMap.get(key);
        if (CollectionUtils.isEmpty(list)) {
            return KEY_EMPTY;
        }
        return WHERE_STRING + filed + " in(" + Joiner.on((String)",").join(list) + ")";
    }

    private String getFieldKey(MetaDataConfigBo metaDataConfigBo) {
        List filedNameList = metaDataConfigBo.getPropList().stream().filter(Objects::nonNull).filter(arg -> !this.isIgnoreField(metaDataConfigBo, (IDataEntityProperty)arg, metaDataConfigBo.getTableGroup())).map(arg -> arg.getAlias().toLowerCase(Locale.ROOT)).distinct().collect(Collectors.toList());
        return String.join((CharSequence)",", filedNameList);
    }

    private boolean isIgnoreField(MetaDataConfigBo config, IDataEntityProperty property, String tableGroup) {
        boolean mulCondition;
        if (property == null || StringUtils.isEmpty((CharSequence)property.getAlias())) {
            return true;
        }
        boolean bl = mulCondition = property.isDbIgnore() && property instanceof MuliLangTextProp && !config.getAlias().endsWith("_L");
        if (mulCondition) {
            return true;
        }
        if (property instanceof MulBasedataProp) {
            return true;
        }
        List list = config.getPropList().stream().filter(arg -> arg instanceof DynamicComplexProperty).map(arg -> (DynamicComplexProperty)arg).collect(Collectors.toList());
        if (list.stream().anyMatch(arg -> property.getName().equalsIgnoreCase(arg.getRefIdPropName()))) {
            return true;
        }
        return !this.isStrEquals(tableGroup, property.getTableGroup());
    }

    private boolean isStrEquals(String str, String arg) {
        if (str == null) {
            return arg == null;
        }
        return str.equalsIgnoreCase(arg);
    }

    private void appendDeleteSQL(StringBuilder stringBuilder, ResultSetMetaData resultSetMetaData, MetaDataConfigBo metaDataConfigBo, ResultSet resultSet) throws SQLException {
        List list = metaDataConfigBo.getPkList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        String pkName = ((IDataEntityProperty)list.get(0)).getAlias();
        int count = resultSetMetaData.getColumnCount();
        Object value = null;
        for (int i = 1; i <= count; ++i) {
            if (!pkName.equalsIgnoreCase(resultSetMetaData.getColumnName(i))) continue;
            value = resultSet.getObject(i);
        }
        if (value == null) {
            return;
        }
        stringBuilder.append("DELETE FROM ").append(metaDataConfigBo.getAlias().toUpperCase(Locale.ROOT)).append(" WHERE ");
        stringBuilder.append(pkName.toLowerCase(Locale.ROOT)).append(" =");
        String key = (metaDataConfigBo.getAppId() + "." + metaDataConfigBo.getAlias() + "." + pkName).toUpperCase(Locale.ROOT);
        List<Object> pkValueList = this.pkDataMap.get(key);
        if (CollectionUtils.isEmpty(pkValueList)) {
            pkValueList = new ArrayList<Object>();
        }
        if (list.get(0) instanceof VarcharProp) {
            pkValueList.add("'" + value.toString().trim() + "'");
            stringBuilder.append(" '").append(value).append("';\n");
        } else {
            pkValueList.add(value);
            stringBuilder.append(value).append(";\n");
        }
        this.pkDataMap.put(key, pkValueList);
    }

    private void appendInsertSql(ResultSet resultSet, ResultSetMetaData resultSetMetaData, StringBuilder stringBuilder, MetaDataConfigBo metaDataConfigBo) throws SQLException {
        stringBuilder.append("INSERT INTO ").append(metaDataConfigBo.getAlias()).append('(');
        int size = resultSetMetaData.getColumnCount();
        for (int i = 1; i <= size; ++i) {
            String columnName = resultSetMetaData.getColumnName(i);
            if (i == size) {
                stringBuilder.append(columnName).append(')');
                continue;
            }
            stringBuilder.append(columnName).append(',');
        }
        stringBuilder.append(" VALUES(");
        this.getInsertSqlByResultMetaData(resultSet, resultSetMetaData, stringBuilder);
    }

    private void getInsertSqlByResultMetaData(ResultSet rs, ResultSetMetaData rsmd, StringBuilder insertSql) throws SQLException {
        int size = rsmd.getColumnCount();
        block6: for (int i = 1; i <= size; ++i) {
            int columnType = rsmd.getColumnType(i);
            String columnName = rsmd.getColumnName(i);
            switch (columnType) {
                case -5: 
                case 2: 
                case 4: 
                case 5: {
                    long columnValue = this.getDefaultFieldValue(columnName, rs.getLong(i));
                    if (i == size) {
                        insertSql.append(columnValue).append(");\n");
                        continue block6;
                    }
                    insertSql.append(columnValue).append(',');
                    continue block6;
                }
                case 3: {
                    double columnValue = rs.getDouble(i);
                    if (i == size) {
                        insertSql.append(columnValue).append(");\n");
                        continue block6;
                    }
                    insertSql.append(columnValue).append(',');
                    continue block6;
                }
                case -9: 
                case 1: 
                case 12: {
                    this.initString(rs, insertSql, i, size, columnName);
                    continue block6;
                }
                case 91: 
                case 93: {
                    String tmpVal;
                    if (i == size) {
                        Timestamp timeVal = rs.getTimestamp(i);
                        if (timeVal != null) {
                            tmpVal = ((Object)timeVal).toString();
                            tmpVal = tmpVal.substring(0, tmpVal.lastIndexOf(46));
                            insertSql.append("{ts'").append(tmpVal).append("'});\n");
                            continue block6;
                        }
                        insertSql.append(timeVal).append(");\n ");
                        continue block6;
                    }
                    Timestamp timeVal = rs.getTimestamp(i);
                    if (timeVal != null) {
                        tmpVal = ((Object)timeVal).toString();
                        tmpVal = tmpVal.substring(0, tmpVal.lastIndexOf(46));
                        insertSql.append("{ts'").append(tmpVal).append("'},");
                        continue block6;
                    }
                    insertSql.append(timeVal).append(',');
                    continue block6;
                }
                default: {
                    this.initString(rs, insertSql, i, size, columnName);
                }
            }
        }
    }

    private long getDefaultFieldValue(String columnName, long columnValue) {
        long columnVal = this.getBaseDefaultUserId(columnName, columnValue);
        columnVal = this.getBaseDefaultOrgId(columnName, columnVal);
        return columnVal;
    }

    private long getBaseDefaultUserId(String columnName, long value) {
        long columnVal = value;
        for (int i = 0; i < PRE_DEFAULT_USER_STR.length; ++i) {
            if (columnName.equalsIgnoreCase(PRE_DEFAULT_USER_STR[i])) {
                columnVal = DEFAULT_USERID;
                continue;
            }
            if (!columnName.equals("fdisablerid")) continue;
            columnVal = DEFAULT_VALUE_ZERO;
        }
        return columnVal;
    }

    private long getBaseDefaultOrgId(String columnName, long value) {
        long columnVal = value;
        for (int i = 0; i < PRE_DEFAULT_ORG_STR.length; ++i) {
            if (!columnName.equalsIgnoreCase(PRE_DEFAULT_ORG_STR[i])) continue;
            columnVal = DEFAULT_ORG_ID;
        }
        return columnVal;
    }

    private void initString(ResultSet rs, StringBuilder insertSql, int i, int size, String columnName) throws SQLException {
        if (i == size) {
            if (rs.getString(i) == null) {
                insertSql.append("null").append(");\n ");
            } else {
                String columnValue = this.getIsSysPreset(columnName, rs.getString(i));
                if (columnValue != null && columnValue.contains("'")) {
                    columnValue = columnValue.replace("'", "' '");
                } else if (StringUtils.isBlank((CharSequence)columnValue)) {
                    columnValue = " ";
                }
                insertSql.append(" '").append(columnValue).append("');\n");
            }
        } else if (rs.getString(i) == null) {
            insertSql.append("null,");
        } else {
            String columnValue = this.getIsSysPreset(columnName, rs.getString(i));
            if (columnValue != null && columnValue.contains("'")) {
                columnValue = columnValue.replace("'", "' '");
            } else if (StringUtils.isBlank((CharSequence)columnValue)) {
                columnValue = " ";
            }
            insertSql.append(" '").append(columnValue).append("',");
        }
    }

    private String getIsSysPreset(String columnName, String value) {
        String columnVal = value;
        if (columnName.equalsIgnoreCase("fIsSysPreset")) {
            columnVal = IS_SYS_PRESET;
        }
        return columnVal;
    }
}

