/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.model.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.id.ID;
import kd.bos.isv.ISVService;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.common.metadatafield.parse.BaseDataMetaDataFieldParser;
import kd.hdtc.hrbm.business.common.metadatafield.parse.IMetaDataFieldParser;
import kd.hdtc.hrbm.business.common.metadatafield.parse.MetaDataFieldParserFactory;
import kd.hdtc.hrbm.business.domain.baseconfig.IBaseConfigDomainService;
import kd.hdtc.hrbm.business.domain.model.IPropDomainService;
import kd.hdtc.hrbm.business.domain.model.entity.ILogicEntityRelEntityService;
import kd.hdtc.hrbm.business.domain.model.entity.IPropEntityService;
import kd.hdtc.hrbm.business.domain.model.entity.IPropRelPropService;
import kd.hdtc.hrbm.common.constant.HRBMAppConstants;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdbs.common.util.ObjectUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class PropDomainServiceImpl
implements IPropDomainService {
    private static final String SELECT_FIELD = "id,name,number,fieldtype,must,bizrule,fieldconfig,proptype,propkey,coreprop,cusstatus,index,modifier,isv,description,proplabelmul,deleted,bizrule,table,multilang,tablefield,unique,metadata,logicentity,primary,extend";
    private static final String BASEDATA_LIMIT_FIELD = "id,name,number,logicentity";
    private static final List<String> BASEDATA_FIELD_LIST = ImmutableList.of((Object)"BasedataField", (Object)"MulBasedataField");
    private final ILogicEntityRelEntityService logicEntityRelEntityService = ServiceFactory.getService(ILogicEntityRelEntityService.class);
    private final IPropEntityService propEntityService = ServiceFactory.getService(IPropEntityService.class);
    private final IPropRelPropService propRelPropService = ServiceFactory.getService(IPropRelPropService.class);
    private final IBaseConfigDomainService iBaseConfigDomainService = ServiceFactory.createInstance(IBaseConfigDomainService.class);

    @Override
    public void structPropAndRel(MainEntityType mainEntityType, DynamicObject logicEntity) {
        long logicEntityId = logicEntity.getLong("id");
        String logicEntityNumber = logicEntity.getString("number");
        Long currUserId = RequestContext.get().getCurrUserId();
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainEntityType.getName(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List items = entityMetadata.getItems();
        LinkedList<Integer> propIndexList = this.getPropIndexList(logicEntityId, items.size());
        Set entryEntityIdSet = items.stream().filter(item -> item instanceof EntryEntity).map(item -> item.getId()).collect(Collectors.toSet());
        ArrayList propAddList = new ArrayList(items.size());
        ArrayList propRelAddList = new ArrayList(items.size());
        int[] start = new int[]{10};
        items.forEach(item -> {
            if (item instanceof MainEntity) {
                DynamicObject propDyc = this.structPrimaryKey((EntityItem<?>)item, mainEntityType);
                if (propDyc == null) {
                    return;
                }
                propDyc.set("number", (Object)(logicEntityNumber + "." + propDyc.getString("propkey")));
                propDyc.set("logicentity", (Object)logicEntityId);
                propDyc.set("table", (Object)mainEntityType.getAlias());
                propAddList.add(propDyc);
                return;
            }
            if (item instanceof EntryEntity || entryEntityIdSet.contains(item.getParentId())) {
                return;
            }
            if (!(item instanceof MulBasedataField) && HRStringUtils.isEmpty((String)((Field)item).getFieldName())) {
                return;
            }
            DynamicObject propDyc = this.propEntityService.generateEmptyDynamicObject();
            propDyc.set("logicentity", (Object)logicEntityId);
            propDyc.set("name", (Object)item.getName());
            String propKey = item.getKey();
            propDyc.set("number", (Object)(logicEntityNumber + "." + propKey));
            propDyc.set("propkey", (Object)propKey);
            String fieldType = MetaDataFieldParserFactory.META_FIELD_MAP.get(item.getClass().getName());
            propDyc.set("fieldtype", (Object)fieldType);
            IMetaDataFieldParser metaDataFieldParser = MetaDataFieldParserFactory.getMetaDataFieldParser(fieldType);
            if (metaDataFieldParser != null) {
                propDyc.set("fieldconfig", (Object)metaDataFieldParser.fieldConfigContent((EntityItem<?>)item));
            }
            propDyc.set("must", (Object)((Field)item).isMustInput());
            propDyc.set("isv", (Object)ISVService.getISVInfo().getId());
            if (item instanceof MulBasedataField) {
                propDyc.set("tablefield", null);
                propDyc.set("table", (Object)((IDataEntityProperty)properties.get((Object)item.getKey())).getAlias());
            } else {
                propDyc.set("table", (Object)mainEntityType.getAlias());
                propDyc.set("tablefield", (Object)((IDataEntityProperty)properties.get((Object)item.getKey())).getAlias());
            }
            propDyc.set("extend", (Object)item.isInherit());
            Set<String> excludeColumns = this.iBaseConfigDomainService.getPropBlackList();
            if (excludeColumns.contains(propKey)) {
                propDyc.set("proptype", (Object)"20");
                propDyc.set("index", (Object)start[0]);
                start[0] = start[0] + 10;
            } else {
                propDyc.set("proptype", (Object)"10");
                propDyc.set("index", propIndexList.poll());
            }
            propDyc.set("cusstatus", (Object)"1");
            propDyc.set("primary", (Object)false);
            propDyc.set("multilang", (Object)(item instanceof MuliLangTextField));
            propDyc.set("enable", (Object)"1");
            propDyc.set("status", (Object)"C");
            propDyc.set("creator", (Object)currUserId);
            propAddList.add(propDyc);
            this.structPropRel(propRelAddList, (EntityItem<?>)item, propDyc, currUserId);
        });
        this.propEntityService.save(propAddList.toArray(new DynamicObject[0]));
        this.propEntityService.save(propRelAddList.toArray(new DynamicObject[0]));
    }

    private void structPropRel(List<DynamicObject> propRelAddList, EntityItem<?> item, DynamicObject propDyc, Long currUserId) {
        if (!(item instanceof BasedataField) && !(item instanceof MulBasedataField)) {
            return;
        }
        String baseEntityId = "";
        if (item instanceof BasedataField) {
            baseEntityId = ((BasedataField)item).getBaseEntityId();
        } else if (item instanceof MulBasedataField) {
            baseEntityId = ((MulBasedataField)item).getBaseEntityId();
        }
        if (HRStringUtils.isEmpty((String)baseEntityId)) {
            return;
        }
        String baseEntityNumber = MetadataDao.getNumberById((String)baseEntityId);
        DynamicObject[] logicEntityRelArr = this.logicEntityRelEntityService.query("logicentity", new QFilter("metadatanum", "=", (Object)baseEntityNumber).toArray());
        if (logicEntityRelArr.length == 0) {
            return;
        }
        DynamicObject logicEntityDyc = logicEntityRelArr[0].getDynamicObject("logicentity");
        if (logicEntityDyc == null) {
            return;
        }
        List<DynamicObject> propList = this.getPropInfobyLogicEntityId(logicEntityDyc.getLong("id"));
        Optional<DynamicObject> primary = propList.stream().filter(prop -> prop.getBoolean("primary")).findFirst();
        if (primary.isPresent()) {
            DynamicObject propRel = this.propRelPropService.generateEmptyDynamicObject();
            propRel.set("sourceprop", (Object)propDyc);
            propRel.set("targetprop", (Object)primary.get());
            propRel.set("reltype", (Object)"A2");
            propRel.set("creator", (Object)currUserId);
            propRelAddList.add(propRel);
        }
    }

    private DynamicObject structPrimaryKey(EntityItem<?> item, MainEntityType mainEntityType) {
        boolean isMustInput;
        String fieldType;
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        Optional<IDataEntityProperty> primaryKeyProp = properties.stream().filter(prop -> prop instanceof PKFieldProp).findFirst();
        if (!primaryKeyProp.isPresent()) {
            return null;
        }
        IDataEntityProperty primaryKey = primaryKeyProp.get();
        if (primaryKey instanceof LongProp) {
            fieldType = "BigIntField";
            isMustInput = ((LongProp)primaryKey).isMustInput();
        } else if (primaryKey instanceof VarcharProp) {
            fieldType = "TextField";
            isMustInput = ((VarcharProp)primaryKey).isMustInput();
        } else {
            return null;
        }
        DynamicObject propDyc = this.propEntityService.generateEmptyDynamicObject();
        propDyc.set("name", (Object)"ID");
        propDyc.set("propkey", (Object)primaryKey.getName());
        propDyc.set("fieldtype", (Object)fieldType);
        IMetaDataFieldParser metaDataFieldParser = MetaDataFieldParserFactory.getMetaDataFieldParser(fieldType);
        if (metaDataFieldParser != null) {
            propDyc.set("fieldconfig", (Object)metaDataFieldParser.fieldConfigContent(item));
        }
        propDyc.set("must", (Object)isMustInput);
        propDyc.set("proptype", (Object)"10");
        propDyc.set("isv", (Object)ISVService.getISVInfo().getId());
        propDyc.set("tablefield", (Object)primaryKey.getAlias());
        propDyc.set("primary", (Object)true);
        propDyc.set("extend", (Object)true);
        propDyc.set("index", (Object)1);
        propDyc.set("multilang", (Object)false);
        propDyc.set("coreprop", (Object)true);
        propDyc.set("enable", (Object)"1");
        propDyc.set("status", (Object)"C");
        propDyc.set("creator", (Object)RequestContext.get().getCurrUserId());
        return propDyc;
    }

    @Override
    public void savePropAndPropRel(DynamicObjectCollection propEntryEntity, long logicEntityId, String propNumberPrefix) {
        String isvId = ISVServiceHelper.getISVInfo().getId();
        QFilter logicEntityFilter = new QFilter("logicentity", "=", (Object)logicEntityId);
        Set<String> excludeColumns = this.iBaseConfigDomainService.getPropBlackList();
        if (CollectionUtils.isNotEmpty(excludeColumns)) {
            QFilter whitcQFilter = new QFilter("propkey", "not in", excludeColumns);
            logicEntityFilter.and(whitcQFilter);
        }
        QFilter deleteFilter = new QFilter("deleted", "=", (Object)Boolean.FALSE);
        DynamicObject[] allPropArr = this.propEntityService.query(SELECT_FIELD, new QFilter[]{logicEntityFilter, deleteFilter, QFilterConstants.Q_ENABLE});
        Set allPropSet = Arrays.stream(allPropArr).collect(Collectors.toSet());
        Set allPropIdSet = allPropSet.stream().map(prop -> prop.getLong("id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> allDBPropMap = allPropSet.stream().collect(Collectors.toMap(prop -> prop.getLong("id"), prop -> prop));
        Set propIdSet = propEntryEntity.stream().map(prop -> prop.getLong("id")).filter(prop -> prop != 0L).collect(Collectors.toSet());
        Map<Long, DynamicObject> existPropMap = allPropSet.stream().filter(prop -> propIdSet.contains(prop.getLong("id"))).collect(Collectors.toMap(prop -> prop.getLong("id"), prop -> prop));
        allPropIdSet.removeAll(propIdSet);
        LinkedList idQueue = new LinkedList();
        long[] ids = ID.genLongIds((int)(propEntryEntity.size() * 2));
        Arrays.stream(ids).forEach(id -> idQueue.offer(id));
        long currUserId = RequestContext.get().getCurrUserId();
        ArrayList<DynamicObject> propAddList = new ArrayList<DynamicObject>(propEntryEntity.size());
        ArrayList<DynamicObject> propModList = new ArrayList<DynamicObject>(propEntryEntity.size());
        for (DynamicObject dyn : propEntryEntity) {
            long propId = dyn.getLong("id");
            if (propId == 0L || !existPropMap.containsKey(propId)) {
                DynamicObject newDyn = this.propEntityService.generateEmptyDynamicObject();
                Long newId = (Long)idQueue.poll();
                newDyn.set("id", (Object)newId);
                newDyn.set("logicentity", (Object)logicEntityId);
                newDyn.set("enable", (Object)"1");
                newDyn.set("status", (Object)"C");
                newDyn.set("creator", (Object)currUserId);
                this.propSetValue(dyn, newDyn, propNumberPrefix);
                DynamicObjectCollection targetPropLabelMulList = newDyn.getDynamicObjectCollection("proplabelmul");
                DynamicObjectCollection propLabelMulList = dyn.getDynamicObjectCollection("proplabelmul");
                propLabelMulList.forEach(baseData -> {
                    DynamicObject propLabelMul = targetPropLabelMulList.addNew();
                    propLabelMul.set("fbasedataid", (Object)baseData.getDynamicObject("fbasedataid"));
                });
                dyn.set("id", (Object)newId);
                propAddList.add(newDyn);
                continue;
            }
            DynamicObject existPropDyn = existPropMap.get(propId);
            if (!isvId.equals(existPropDyn.get("isv")) || existPropDyn.getBoolean("extend")) continue;
            this.propSetValue(dyn, existPropDyn, propNumberPrefix);
            existPropDyn.set("proplabelmul", (Object)dyn.getDynamicObjectCollection("proplabelmul"));
            propModList.add(existPropDyn);
        }
        if (CollectionUtils.isNotEmpty(allPropIdSet)) {
            for (Long propId : allPropIdSet) {
                DynamicObject propDy = allDBPropMap.get(propId);
                if (HRObjectUtils.isEmpty((Object)propDy)) continue;
                propDy.set("deleted", (Object)Boolean.TRUE);
                propModList.add(propDy);
            }
        }
        this.propEntityService.save(propAddList.toArray(new DynamicObject[0]));
        this.propEntityService.save(propModList.toArray(new DynamicObject[0]));
        this.savePropRel(propEntryEntity, existPropMap, propAddList);
    }

    private void savePropRel(DynamicObjectCollection propEntryEntity, Map<Long, DynamicObject> existPropMap, List<DynamicObject> propResultList) {
        List<DynamicObject> propRelList = this.propRelPropService.getPropRelBysourceEntityIds(existPropMap.keySet());
        ArrayList propRelAddList = new ArrayList(propEntryEntity.size());
        HashMap baseEntityIdMappingMap = Maps.newHashMapWithExpectedSize((int)16);
        propResultList.stream().filter(prop -> BASEDATA_FIELD_LIST.contains(prop.getString("fieldtype"))).forEach(prop -> {
            Object fieldConfigMap;
            BaseDataMetaDataFieldParser metaDataFieldParser = (BaseDataMetaDataFieldParser)MetaDataFieldParserFactory.getMetaDataFieldParser(prop.getString("fieldtype"));
            if (metaDataFieldParser != null && (fieldConfigMap = metaDataFieldParser.parseItems(prop.getString("fieldconfig"))) != null) {
                baseEntityIdMappingMap.put(prop.getLong("id"), fieldConfigMap.get("id").toString());
            }
        });
        DynamicObject[] logicEntityRelArr = this.logicEntityRelEntityService.query("logicentity.number,metadatanum", new QFilter("metadatanum", "in", baseEntityIdMappingMap.values()).toArray());
        Map<String, String> logicEntityIdMappingMap = Arrays.stream(logicEntityRelArr).collect(Collectors.toMap(rel -> rel.getString("metadatanum"), rel -> rel.getString("logicentity.number") + ".id", (k1, k2) -> k2));
        QFilter primaryQFilter = new QFilter("primary", "=", (Object)"1");
        DynamicObject[] propEntityInfoArr = this.propEntityService.query("id,number", new QFilter("number", "in", logicEntityIdMappingMap.values()).and(primaryQFilter).toArray());
        Map<String, Long> propIdMappingMap = Arrays.stream(propEntityInfoArr).collect(Collectors.toMap(rel -> rel.getString("number"), rel -> rel.getLong("id"), (k1, k2) -> k1));
        HashMap entryIdPropRelMappingMap = Maps.newHashMapWithExpectedSize((int)16);
        baseEntityIdMappingMap.keySet().forEach(id -> {
            Long cfr_ignored_0 = (Long)entryIdPropRelMappingMap.put(id, propIdMappingMap.get(logicEntityIdMappingMap.get(baseEntityIdMappingMap.get(id))));
        });
        long currUserId = RequestContext.get().getCurrUserId();
        entryIdPropRelMappingMap.entrySet().forEach(entry -> {
            Long sourceId = (Long)entry.getKey();
            Long targetId = (Long)entry.getValue();
            if (ObjectUtils.isEmpty((Object)targetId)) {
                return;
            }
            DynamicObject propRel = this.propRelPropService.generateEmptyDynamicObject();
            propRel.set("sourceprop", (Object)sourceId);
            propRel.set("targetprop", (Object)targetId);
            propRel.set("reltype", (Object)"A2");
            propRel.set("creator", (Object)currUserId);
            propRelAddList.add(propRel);
        });
        this.propRelPropService.save(propRelAddList.toArray(new DynamicObject[0]));
    }

    private void propSetValue(DynamicObject sourceDyc, DynamicObject targetDyc, String propNumberPrefix) {
        targetDyc.set("name", (Object)sourceDyc.getLocaleString("ename"));
        targetDyc.set("number", (Object)(propNumberPrefix + "." + sourceDyc.getString("epropkey")));
        targetDyc.set("propkey", (Object)sourceDyc.getString("epropkey").toLowerCase());
        targetDyc.set("fieldtype", (Object)sourceDyc.getString("fieldtype"));
        targetDyc.set("must", (Object)sourceDyc.getBoolean("must"));
        targetDyc.set("bizrule", (Object)sourceDyc.getLocaleString("ebizrule"));
        targetDyc.set("fieldconfig", (Object)sourceDyc.getString("fieldconfig"));
        targetDyc.set("index", (Object)sourceDyc.getInt("eindex"));
        targetDyc.set("description", (Object)sourceDyc.getLocaleString("edescription"));
        targetDyc.set("isv", (Object)sourceDyc.getString("eisv"));
        targetDyc.set("primary", (Object)sourceDyc.getBoolean("primary"));
        targetDyc.set("extend", (Object)sourceDyc.getBoolean("extend"));
        targetDyc.set("proptype", (Object)sourceDyc.getString("proptype"));
        targetDyc.set("cusstatus", (Object)sourceDyc.getString("ecusstatus"));
    }

    @Override
    public List<DynamicObject> getPropInfobyLogicEntityId(long logicEntityId) {
        QFilter deleteFilter = new QFilter("deleted", "=", (Object)Boolean.FALSE);
        QFilter logicEntityFilter = new QFilter("logicentity", "=", (Object)logicEntityId);
        Object[] logicEntityArr = this.propEntityService.query(SELECT_FIELD, new QFilter[]{logicEntityFilter, deleteFilter, QFilterConstants.Q_ENABLE});
        if (ObjectUtils.isEmpty((Object[])logicEntityArr)) {
            return new ArrayList<DynamicObject>();
        }
        return ConvertUtils.toList((Object[])logicEntityArr);
    }

    @Override
    public Map<Long, Map<Long, DynamicObject>> getPropInfoMapByLogicEntityId(Collection<Long> logicEntityIdSet) {
        if (CollectionUtils.isEmpty(logicEntityIdSet)) {
            return new HashMap<Long, Map<Long, DynamicObject>>();
        }
        QFilter logicEntityFilter = new QFilter("logicentity", "in", logicEntityIdSet);
        Object[] allPropArr = this.propEntityService.query(SELECT_FIELD, new QFilter[]{logicEntityFilter, QFilterConstants.Q_ENABLE});
        if (ArrayUtils.isEmpty((Object[])allPropArr)) {
            return new HashMap<Long, Map<Long, DynamicObject>>();
        }
        return Stream.of(allPropArr).collect(Collectors.groupingBy(dy -> dy.getLong("logicentity.id"), Collectors.toMap(prop -> prop.getLong("id"), Function.identity())));
    }

    @Override
    public List<DynamicObject> getAllPropInfoByLogicEntityId(long logicEntityId) {
        QFilter logicEntityFilter = new QFilter("logicentity", "=", (Object)logicEntityId);
        Object[] logicEntityArr = this.propEntityService.query(SELECT_FIELD, new QFilter[]{logicEntityFilter, QFilterConstants.Q_ENABLE}, "index asc");
        if (ObjectUtils.isEmpty((Object[])logicEntityArr)) {
            return new ArrayList<DynamicObject>();
        }
        return ConvertUtils.toList((Object[])logicEntityArr);
    }

    @Override
    public List<DynamicObject> getExcludeWhitePropInfobyLogicEntityId(long logicEntityId) {
        QFilter logicEntityFilter = new QFilter("logicentity", "=", (Object)logicEntityId);
        Set<String> propBlackList = this.iBaseConfigDomainService.getPropBlackList();
        if (CollectionUtils.isNotEmpty(propBlackList)) {
            QFilter whitcQFilter = new QFilter("propkey", "not in", propBlackList);
            logicEntityFilter.and(whitcQFilter);
        }
        QFilter deleteFilter = new QFilter("deleted", "=", (Object)Boolean.FALSE);
        logicEntityFilter.and(deleteFilter);
        Object[] logicEntityArr = this.propEntityService.query(SELECT_FIELD, new QFilter[]{logicEntityFilter, deleteFilter, QFilterConstants.Q_ENABLE});
        if (ObjectUtils.isEmpty((Object[])logicEntityArr)) {
            return new ArrayList<DynamicObject>();
        }
        return ConvertUtils.toList((Object[])logicEntityArr);
    }

    @Override
    public List<DynamicObject> getPropByEntityIdAndIsv(Long logicEntityId, String isv) {
        QFilter qFilter = new QFilter("logicentity", "in", (Object)logicEntityId);
        qFilter.and("isv", "=", (Object)isv);
        Object[] logicEntityArr = this.propEntityService.query(SELECT_FIELD, qFilter.and(QFilterConstants.Q_ENABLE).toArray(), "index");
        return ConvertUtils.toList((Object[])logicEntityArr);
    }

    @Override
    public List<DynamicObject> getPropByEntityIdAndExtends(Long logicEntityId) {
        QFilter qFilter = new QFilter("logicentity", "in", (Object)logicEntityId);
        qFilter.and("extend", "=", (Object)Boolean.FALSE);
        Object[] logicEntityArr = this.propEntityService.query(SELECT_FIELD, qFilter.and(QFilterConstants.Q_ENABLE).toArray(), "index asc");
        return ConvertUtils.toList((Object[])logicEntityArr);
    }

    @Override
    public List<DynamicObject> getPropsByEntityIdAndQFilter(Long logicEntityId, QFilter qFilter, String orderBy) {
        QFilter logicEntityQf = new QFilter("logicentity", "in", (Object)logicEntityId);
        if (qFilter != null) {
            logicEntityQf.and(qFilter);
        }
        Object[] logicEntityArr = this.propEntityService.query(SELECT_FIELD, logicEntityQf.and(QFilterConstants.Q_ENABLE).toArray(), orderBy);
        return ConvertUtils.toList((Object[])logicEntityArr);
    }

    @Override
    public List<DynamicObject> getPropInfoByIds(Collection<Long> ids) {
        Object[] logicEntityArr = this.propEntityService.query(SELECT_FIELD, new QFilter("id", "in", ids).and(QFilterConstants.Q_ENABLE).toArray());
        return ConvertUtils.toList((Object[])logicEntityArr);
    }

    @Override
    public LinkedList<String> getPropNumberList(int count, Long logicEntityId, DynamicObjectCollection entityCol) {
        return this.getPropNumberList(count, logicEntityId, null, null, entityCol);
    }

    @Override
    public LinkedList<String> getPropNumberList(int count, Long logicEntityId, String logicEntityNumber, String location, DynamicObjectCollection entityCol) {
        String isv = ISVService.getISVInfo().getId();
        Boolean before = null;
        if (!StringUtils.isEmpty((String)location)) {
            before = "1".equals(location);
        }
        String prefix = this.getPrefix(logicEntityNumber, before, isv);
        LinkedList<String> numberList = new LinkedList<String>();
        QFilter qFilter = new QFilter("isv", "=", (Object)isv);
        qFilter.and("logicentity", "=", (Object)logicEntityId);
        qFilter.and("propkey", "like", (Object)(prefix + "%"));
        List propDycList = this.propEntityService.queryOriginalList("propkey", qFilter.and(QFilterConstants.Q_ENABLE).toArray());
        Pattern pattern = Pattern.compile("\\d{3}");
        Optional<Integer> dbMaxNumber = propDycList.stream().map(dy -> dy.getString("propkey").replace(prefix, "")).filter(str -> pattern.matcher((CharSequence)str).matches()).map(Integer::parseInt).max(Integer::compare);
        Optional<Integer> max = entityCol.stream().map(dy -> dy.getString("epropkey").replace(prefix, "")).filter(str -> pattern.matcher((CharSequence)str).matches()).map(Integer::parseInt).max(Integer::compare);
        int maxInt = dbMaxNumber.orElse(0);
        if (max.isPresent()) {
            maxInt = Math.max(maxInt, max.get());
        }
        for (int i = 1; i <= count; ++i) {
            numberList.offer(prefix + String.format("%03d", ++maxInt));
        }
        return numberList;
    }

    private String getPrefix(String logicEntityNumber, Boolean before, String isv) {
        StringBuilder sb;
        StringBuilder stringBuilder = sb = HRStringUtils.equals((String)isv, (String)"kingdee") ? new StringBuilder() : new StringBuilder(isv);
        if (before != null) {
            sb.append("_").append(PropDomainServiceImpl.getBeforeKey(before));
        }
        if (logicEntityNumber != null) {
            sb.append("_").append(PropDomainServiceImpl.getSuffix(logicEntityNumber));
        }
        sb.append("_").append("field");
        String result = sb.toString();
        if (result.startsWith("_")) {
            result = result.substring(1);
        }
        return result;
    }

    private static String getSuffix(String logicEntityNumber) {
        if (logicEntityNumber.length() >= 4) {
            return logicEntityNumber.substring(logicEntityNumber.length() - 4);
        }
        return logicEntityNumber;
    }

    private static String getBeforeKey(boolean before) {
        return before ? "b" : "a";
    }

    @Override
    public LinkedList<Integer> getPropIndexList(Long logicEntityId, int count) {
        LinkedList<Integer> indexList = new LinkedList<Integer>();
        QFilter deleteFilter = new QFilter("deleted", "=", (Object)Boolean.FALSE);
        QFilter logicEntityFilter = new QFilter("logicentity", "=", (Object)logicEntityId);
        DynamicObject[] propArr = logicEntityId == null || logicEntityId == 0L ? new DynamicObject[]{} : this.propEntityService.query("index", new QFilter[]{logicEntityFilter, deleteFilter, QFilterConstants.Q_ENABLE});
        if (propArr.length == 0) {
            for (int i = 10; i <= count * 10; i += 10) {
                indexList.offer(i + HRBMAppConstants.THREE_HUNDRED);
            }
            return indexList;
        }
        Optional<Integer> maxIndex = Arrays.stream(propArr).map(prop -> prop.getInt("index")).sorted(Comparator.comparing(Integer::intValue).reversed()).findFirst();
        int index = maxIndex.get();
        if (index >= HRBMAppConstants.PROP_MAX_INDEX) {
            for (int i = 1; i <= count; ++i) {
                indexList.offer(HRBMAppConstants.PROP_MAX_INDEX);
            }
        } else {
            for (int i = 1; i <= count; ++i) {
                int seq;
                index = seq = index + 10;
                if (seq >= HRBMAppConstants.PROP_MAX_INDEX) {
                    indexList.offer(HRBMAppConstants.PROP_MAX_INDEX);
                    continue;
                }
                indexList.offer(seq);
            }
        }
        return indexList;
    }

    @Override
    public void batchSaveProp(List<DynamicObject> propList) {
        if (CollectionUtils.isEmpty(propList)) {
            return;
        }
        this.propEntityService.save(propList.toArray(new DynamicObject[0]));
    }

    @Override
    public List<Long> getTargetPropIdList(Long logicEntityId, List<Long> propIdList) {
        QFilter idFilter = new QFilter("sourceprop.logicentity.pid", "=", (Object)logicEntityId);
        idFilter.and("targetprop", "in", propIdList);
        idFilter.and("sourceprop.propkey", "like", (Object)"%_a_%");
        Object[] propRelArr = this.propRelPropService.query("targetprop", new QFilter[]{idFilter});
        if (ArrayUtils.isEmpty((Object[])propRelArr)) {
            return new ArrayList<Long>();
        }
        return Arrays.asList(propRelArr).stream().filter(prop -> prop.get("targetprop") != null).map(prop -> prop.getLong("targetprop.id")).collect(Collectors.toList());
    }

    @Override
    public List<DynamicObject> getSimplePropList(Collection<Long> idCollection) {
        Object[] logicEntityArr = this.propEntityService.query(BASEDATA_LIMIT_FIELD, new QFilter("id", "in", idCollection).toArray());
        return ConvertUtils.toList((Object[])logicEntityArr);
    }
}

