/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.model.impl;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.model.IPropRelPropDomainService;
import kd.hdtc.hrbm.business.domain.model.entity.IPropRelPropService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;

public class PropRelPropDomainServiceImpl
implements IPropRelPropDomainService {
    IPropRelPropService propRelPropService = ServiceFactory.getService(IPropRelPropService.class);

    @Override
    public DynamicObject[] getPropRelPropInfoBySourcePropId(Long id) {
        DynamicObject[] result = this.propRelPropService.query("id,targetprop,reltype", new QFilter("sourceprop", "=", (Object)id).toArray());
        if (result == null) {
            return new DynamicObject[0];
        }
        return result;
    }

    @Override
    public List<DynamicObject> getProRelByEntityIdAndRelType(Long logicEntityId, String relType) {
        QFilter qFilter = new QFilter("sourceprop.deleted", "=", (Object)Boolean.FALSE);
        return this.getProRel(logicEntityId, relType, qFilter);
    }

    private List<DynamicObject> getProRel(Long logicEntityId, String relType, QFilter qFilter) {
        QFilter mainFilter = new QFilter("sourceprop.logicentity.id", "=", (Object)logicEntityId);
        if (relType != null) {
            mainFilter.and("reltype", "=", (Object)relType);
        }
        if (qFilter != null) {
            mainFilter.and(qFilter);
        }
        return this.propRelPropService.queryOriginalList("id,sourceprop,sourceprop.propkey,sourceprop.deleted,targetprop,targetprop.logicentity,targetprop.logicentity.number,targetprop.propkey,reltype,targetprop.number", mainFilter.toArray());
    }

    @Override
    public void saveCopyProRel(DynamicObjectCollection propEntryEntity, List<DynamicObject> oldRelList) {
        Map<Long, DynamicObject> oldRelMap = oldRelList.stream().collect(Collectors.toMap(dy -> dy.getLong("sourceprop"), dy -> dy));
        List<DynamicObject> relDyList = propEntryEntity.stream().filter(dy -> dy.getLong("otherImportProp") != 0L).map(dy -> {
            DynamicObject relDy = this.propRelPropService.generateEmptyDynamicObject();
            relDy.set("sourceprop", (Object)dy.getLong("id"));
            relDy.set("reltype", (Object)"B1");
            relDy.set("targetprop", (Object)dy.getLong("otherImportProp"));
            return relDy;
        }).collect(Collectors.toList());
        Long currentId = RequestContext.get().getCurrUserId();
        relDyList.removeIf(dy -> {
            Long sourceProp = dy.getLong("sourceprop");
            DynamicObject oldRelDy = (DynamicObject)oldRelMap.get(sourceProp);
            if (oldRelDy != null) {
                if (oldRelDy.getLong("targetprop") == dy.getLong("targetprop")) {
                    oldRelMap.remove(sourceProp);
                    return true;
                }
                return false;
            }
            dy.set("creator", (Object)currentId);
            return false;
        });
        if (!CollectionUtils.isEmpty(relDyList)) {
            this.propRelPropService.save(relDyList.toArray(new DynamicObject[0]));
        }
    }
}

