/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.model.impl;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.model.ITempMappingDomainService;
import kd.hdtc.hrbm.business.domain.model.entity.ITempMappingEntityService;
import kd.hdtc.hrbm.common.constant.TempMappingConstants;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class TempMappingDomainServiceImpl
implements ITempMappingDomainService {
    ITempMappingEntityService tempMappingEntityService = ServiceFactory.getService(ITempMappingEntityService.class);

    @Override
    public String generateRuleStr(String personType, String mulLine) {
        return personType + "|" + mulLine;
    }

    @Override
    public DynamicObject getTempMapping(String pidNumber, boolean mulLine) {
        if (StringUtils.isEmpty((String)pidNumber)) {
            return null;
        }
        String tempMappingNumber = this.getTempMappingNumber(pidNumber, mulLine);
        if (StringUtils.isNotEmpty((String)tempMappingNumber)) {
            QFilter numberFilter = new QFilter("number", "=", (Object)tempMappingNumber);
            return this.tempMappingEntityService.queryOne("id,template", new QFilter[]{numberFilter});
        }
        return null;
    }

    private String getTempMappingNumber(String pidNumber, boolean mulLine) {
        String tempMappingNumber = "";
        switch (pidNumber) {
            case "hcf_candidate": {
                tempMappingNumber = "1060_S";
                break;
            }
            case "hrpi_person": {
                tempMappingNumber = mulLine ? "1020_S" : "1010_S";
                break;
            }
            case "hrpi_employee": {
                tempMappingNumber = mulLine ? "1040_S" : "1030_S";
                break;
            }
            case "hrpi_depemp": {
                tempMappingNumber = "1050_S";
                break;
            }
        }
        return tempMappingNumber;
    }

    @Override
    public DynamicObject getTempMappingByRule(String ruleStr) {
        DynamicObject[] tempMapping = this.tempMappingEntityService.query("template,mappingrule", new QFilter[]{QFilterConstants.Q_ENABLE});
        Map<String, DynamicObject> tempMappingMap = Arrays.stream(tempMapping).filter(dynamicObject -> HRStringUtils.isNotEmpty((String)dynamicObject.getString("mappingrule"))).collect(Collectors.toMap(dy -> {
            String mappingRule = dy.getString("mappingrule");
            if (HRStringUtils.isEmpty((String)mappingRule)) {
                return "";
            }
            Map mappingRuleMap = (Map)JsonUtils.castType((String)mappingRule, Map.class);
            return this.generateRuleStr((String)mappingRuleMap.get("personType"), (String)mappingRuleMap.get("mulLine"));
        }, d -> d, (v1, v2) -> v1));
        return tempMappingMap.get(ruleStr);
    }

    @Override
    public DynamicObject getTempMappingById(Long id) {
        return this.tempMappingEntityService.query("id,template", id);
    }

    @Override
    public String getBaseDataPlatTemplateIdById(boolean controlEntity) {
        Long templateId = TempMappingConstants.BASEDATA_TEMPLATE_ID;
        if (controlEntity) {
            templateId = TempMappingConstants.ORG_BASEDATA_TEMPLATE_ID;
        }
        return this.getPlatTemplateIdByTempMappingId(templateId);
    }

    @Override
    public String getPlatTemplateIdByTempMappingId(Long tempMappingId) {
        if (tempMappingId == null || tempMappingId == 0L) {
            return "";
        }
        DynamicObject tempDyc = this.getTempMappingById(tempMappingId);
        DynamicObject templateEntity = tempDyc.getDynamicObject("template");
        return templateEntity.getString("id");
    }

    @Override
    public String getPersonClassify(Long id) {
        DynamicObject tempMapping = this.tempMappingEntityService.query("id,template, mappingrule", id);
        String mappingRule = Optional.ofNullable(tempMapping).map(dy -> dy.getString("mappingrule")).orElse("");
        if (HRStringUtils.isEmpty((String)mappingRule)) {
            return "perattached";
        }
        Map mappingRuleMap = (Map)JsonUtils.castType((String)mappingRule, Map.class);
        Object personType = mappingRuleMap.get("personType");
        if ("1".equals(personType)) {
            return "perattached";
        }
        if ("2".equals(personType)) {
            return "empattached";
        }
        if ("3".equals(personType)) {
            return "depempattached";
        }
        return "perattached";
    }
}

