/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task;

import java.util.Map;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrbm.business.domain.task.IOperateService;
import kd.hdtc.hrbm.business.domain.task.bo.OperateBo;
import kd.hdtc.hrbm.business.domain.task.bo.OperateResultBo;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.util.JsonUtils;

public abstract class AbstractOperateService
implements IOperateService {
    private static final Log LOG = LogFactory.getLog(AbstractOperateService.class);
    private OperateBo operateBo;
    private String runParamStr;
    private Map<String, Object> runParamMap;
    private OperateResultBo operateResultBo = new OperateResultBo();

    public void init(OperateBo operateBo) {
        if (this.operateBo != null) {
            throw new HRDBSBizException("already inited");
        }
        this.operateBo = operateBo;
    }

    @Override
    public OperateResultBo operate(Map<String, Object> runParamMap) {
        LOG.info("do operate start, runParamStr: {}", runParamMap);
        this.runParamMap = runParamMap;
        this.runParamStr = JsonUtils.toStr(runParamMap);
        try (TXHandle txHandle = TX.requiresNew();){
            this.doOperate();
        }
        return this.operateResultBo;
    }

    protected abstract void doOperate();

    @Override
    public OperateResultBo rollback(String runParamStr) {
        return this.operateResultBo;
    }

    public Map<String, Object> getRunParamMap() {
        return this.runParamMap;
    }

    public String getRunParamStrByKey(String key) {
        Object value = this.runParamMap.get(key);
        return value instanceof String ? (String)value : String.valueOf(value);
    }

    public String getRunParamStr() {
        return this.runParamStr;
    }

    public OperateResultBo getOperateResultBo() {
        return this.operateResultBo;
    }

    public OperateBo getOperateBo() {
        return this.operateBo;
    }
}

