/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.bo;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.hdtc.hrbm.business.domain.task.bo.MetadataDataResultBo;
import kd.hdtc.hrbm.business.domain.task.bo.PresetDataResultBo;
import kd.hdtc.hrbm.common.enums.MetadataTypeEnum;

public class DataResultBo {
    private long subTaskId;
    private List<PresetDataResultBo> presetDataResultBoList = new ArrayList<PresetDataResultBo>(4);
    private List<MetadataDataResultBo> metadataDataResultBoList = new ArrayList<MetadataDataResultBo>(4);

    public long getSubTaskId() {
        return this.subTaskId;
    }

    public void setSubTaskId(long subTaskId) {
        this.subTaskId = subTaskId;
    }

    public List<PresetDataResultBo> getPresetDataResultBoList() {
        return this.presetDataResultBoList;
    }

    public void addPresetDataResultBoList(PresetDataResultBo presetDataResultBo) {
        this.presetDataResultBoList.add(presetDataResultBo);
    }

    public List<MetadataDataResultBo> getMetadataDataResultBoList() {
        return this.metadataDataResultBoList;
    }

    public void addMetadataDataResultBoList(MetadataDataResultBo metadataDataResultBo) {
        this.metadataDataResultBoList.add(metadataDataResultBo);
    }

    public static List<PresetDataResultBo> analysisJsonToData(String jsonString) {
        JSONObject json = JSONObject.parseObject((String)jsonString);
        JSONArray presetDataResultJSONArray = JSONArray.parseArray((String)json.getString("dataList"));
        return JSONArray.parseArray((String)((JSONArray)presetDataResultJSONArray.get(0)).toJSONString(), PresetDataResultBo.class);
    }

    public static List<MetadataDataResultBo> analysisJsonToMeta(String jsonString) {
        JSONObject json = JSONObject.parseObject((String)jsonString);
        JSONArray metadataDataResultJSONArray = JSONArray.parseArray((String)json.getString("dynList"));
        return JSONArray.parseArray((String)((JSONArray)metadataDataResultJSONArray.get(0)).toJSONString(), MetadataDataResultBo.class);
    }

    public String resultDataBoToJson() {
        JSONArray dataArray = new JSONArray(Collections.singletonList(this.presetDataResultBoList));
        JSONArray dynArray = new JSONArray(Collections.singletonList(this.metadataDataResultBoList));
        JSONObject json = new JSONObject();
        json.put("dataList", (Object)dataArray);
        json.put("dynList", (Object)dynArray);
        return json.toJSONString();
    }

    public void addMetadataResultBo(String metadataNumber, String metadataId, String versionNumber) {
        MetadataDataResultBo metadataDataResultBo = new MetadataDataResultBo();
        metadataDataResultBo.setNumber(metadataNumber);
        metadataDataResultBo.setId(metadataId);
        metadataDataResultBo.setVersionNumber(versionNumber);
        this.metadataDataResultBoList.add(metadataDataResultBo);
    }

    public void addMetadataResultBo(String metadataNumber, String metadataId, String versionNumber, MetadataTypeEnum metadataTypeEnum) {
        MetadataDataResultBo metadataDataResultBo = new MetadataDataResultBo(metadataId, metadataNumber, metadataTypeEnum);
        metadataDataResultBo.setVersionNumber(versionNumber);
        this.metadataDataResultBoList.add(metadataDataResultBo);
    }

    public void addPresetDataResultBo(PresetDataResultBo presetDataResultBo) {
        this.presetDataResultBoList.add(presetDataResultBo);
    }

    public void mergeDataResult(DataResultBo dataResultBo) {
        this.mergeMetadataDataResult(dataResultBo.getMetadataDataResultBoList());
        this.mergePresetDataResult(dataResultBo.getPresetDataResultBoList());
    }

    private void mergePresetDataResult(List<PresetDataResultBo> presetDataResultBoList) {
        if (presetDataResultBoList == null) {
            return;
        }
        Map<String, PresetDataResultBo> presetDataResultBoMap = this.presetDataResultBoList.stream().collect(Collectors.toMap(it -> it.getNumber(), it -> it));
        presetDataResultBoList.forEach(bo -> {
            if (!presetDataResultBoMap.containsKey(bo.getNumber())) {
                this.presetDataResultBoList.add((PresetDataResultBo)bo);
            }
        });
        Map<String, PresetDataResultBo> presetDataResultBoParamMap = this.presetDataResultBoList.stream().collect(Collectors.toMap(it -> it.getNumber(), it -> it));
        this.presetDataResultBoList.forEach(bo -> {
            PresetDataResultBo presetDataResultBo = (PresetDataResultBo)presetDataResultBoParamMap.get(bo.getNumber());
            if (presetDataResultBo != null && !bo.equals(presetDataResultBoParamMap.get(bo.getNumber()))) {
                bo.addAndRemoveDuplicateIdToList(presetDataResultBo.getIdList());
            }
        });
    }

    private void mergeMetadataDataResult(List<MetadataDataResultBo> metadataDataResultBoList) {
        if (metadataDataResultBoList == null) {
            return;
        }
        HashSet metadataSet = Sets.newHashSet();
        metadataSet.addAll(metadataDataResultBoList);
        if (this.getMetadataDataResultBoList() != null) {
            metadataSet.addAll(this.getMetadataDataResultBoList());
        }
        this.metadataDataResultBoList = Lists.newArrayList((Iterable)metadataSet);
    }
}

