/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.bo;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrbm.common.enums.OperateExistRuleEnum;
import kd.hdtc.hrbm.common.enums.TaskOperateTypeEnum;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import org.apache.commons.lang3.StringUtils;

public class OperateBo {
    private static final Log LOG = LogFactory.getLog(OperateBo.class);
    private DynamicObject operateDynamicObject;
    private String number;
    private String metadataNumber;
    private String name;
    private TaskOperateTypeEnum operateTypeEnum;
    private String operateService;
    private int seq;
    private String mappingRule;
    private boolean rollbackAllow;
    private OperateExistRuleEnum operateExistRuleEnum;
    private Map<String, Object> operateParamMap;

    public OperateBo(DynamicObject operateDynamicObject) {
        this.operateDynamicObject = operateDynamicObject;
        try {
            this.number = this.operateDynamicObject.getString("number");
            this.name = this.operateDynamicObject.getString("name");
            this.operateService = this.operateDynamicObject.getString("serviceclass");
            this.mappingRule = this.operateDynamicObject.getString("mappingrule");
            this.operateTypeEnum = TaskOperateTypeEnum.getOperateTypeByNumber((String)this.operateDynamicObject.getString("operatetype"));
            this.rollbackAllow = this.operateDynamicObject.getBoolean("allowrollback");
            this.seq = this.operateDynamicObject.getInt("runseq");
            this.operateParamMap = StringUtils.isEmpty((CharSequence)this.operateDynamicObject.getString("param")) ? Maps.newLinkedHashMap() : (Map)JsonUtils.cast((String)this.operateDynamicObject.getString("param"), Map.class);
            this.operateExistRuleEnum = OperateExistRuleEnum.getExistRuleByNumber((String)this.operateDynamicObject.getString("existrule"));
        }
        catch (IOException e) {
            throw new HRDBSBizException(e.getMessage());
        }
    }

    public String getNumber() {
        return this.number;
    }

    public String getMetadataNumber() {
        return this.metadataNumber;
    }

    public String getName() {
        return this.name;
    }

    public TaskOperateTypeEnum getOperateTypeEnum() {
        return this.operateTypeEnum;
    }

    public String getOperateService() {
        return this.operateService;
    }

    public int getSeq() {
        return this.seq;
    }

    public String getMappingRule() {
        return this.mappingRule;
    }

    public boolean isRollbackAllow() {
        return this.rollbackAllow;
    }

    public OperateExistRuleEnum getOperateExistRuleEnum() {
        return this.operateExistRuleEnum;
    }

    public Map<String, Object> getOperateParamMap() {
        return this.operateParamMap;
    }
}

