/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.bo;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hdtc.hrbm.business.domain.task.context.TaskGenContext;
import kd.hdtc.hrdbs.business.application.service.rule.IRuleParseApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class OperateGenerateBo {
    private static final String REF_OP = "refOp";
    private IRuleParseApplicationService iRuleParseApplicationService = (IRuleParseApplicationService)ServiceFactory.getService(IRuleParseApplicationService.class);
    private DynamicObject operateDynamicObject;
    private String number;
    private int seq;
    private String runParamStr;
    private boolean ignoreRuleMatch;

    public OperateGenerateBo(DynamicObject operateDynamicObject, String runParamStr) {
        this.operateDynamicObject = operateDynamicObject;
        this.runParamStr = runParamStr;
        this.number = Optional.ofNullable(operateDynamicObject).map(it -> it.getString("number")).orElse("");
        this.seq = Optional.ofNullable(operateDynamicObject).map(it -> it.getInt("runseq")).orElseGet(() -> 1);
    }

    private OperateGenerateBo(DynamicObject operateDynamicObject, String runParamStr, boolean ignoreRuleMatch) {
        this(operateDynamicObject, runParamStr);
        this.ignoreRuleMatch = ignoreRuleMatch;
    }

    public List<OperateGenerateBo> match() {
        boolean match;
        ArrayList operateGenerateBoList = Lists.newArrayList();
        String mappingRule = this.operateDynamicObject.getString("mappingrule");
        String param = this.operateDynamicObject.getString("param");
        boolean bl = match = this.ignoreRuleMatch || this.iRuleParseApplicationService.match(this.runParamStr, mappingRule);
        if (!match) {
            return operateGenerateBoList;
        }
        operateGenerateBoList.add(this);
        HashMap paramMap = StringUtils.isEmpty((String)param) ? Maps.newHashMap() : (Map)JsonUtils.castType((String)param, Map.class);
        String refOpNumber = (String)paramMap.get(REF_OP);
        if (StringUtils.isEmpty((String)refOpNumber)) {
            return operateGenerateBoList;
        }
        DynamicObject operateDy = TaskGenContext.get().getOperateDyByNumber(refOpNumber);
        operateGenerateBoList.addAll(new OperateGenerateBo(operateDy, this.runParamStr, true).match());
        return operateGenerateBoList;
    }

    public DynamicObject getOperateDynamicObject() {
        return this.operateDynamicObject;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OperateGenerateBo) {
            return this.number.equals(((OperateGenerateBo)obj).number);
        }
        return false;
    }

    public int hashCode() {
        return this.number.hashCode();
    }

    public int getSeq() {
        return this.seq;
    }
}

