/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.bo;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.task.bo.DataResultBo;
import kd.hdtc.hrbm.business.domain.task.bo.OperateGenerateBo;
import kd.hdtc.hrbm.business.domain.task.context.TaskGenContext;
import kd.hdtc.hrbm.business.domain.task.entity.ITaskDetailEntityService;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;

public class TaskDetailBo {
    private static final Log LOG = LogFactory.getLog(TaskDetailBo.class);
    private final ITaskDetailEntityService taskDetailEntityService = ServiceFactory.getService(ITaskDetailEntityService.class);
    private long taskId = TaskGenContext.get().getTaskId();
    private String runParamStr = TaskGenContext.get().getRunParamStr();
    private long sceneManagerId = TaskGenContext.get().getSceneManagerId();
    private DataResultBo dataResultBo;
    private long sceneId;

    public void createTaskDetail() {
        List<OperateGenerateBo> operateGenerateBoList = this.getNeedRunOpList();
        operateGenerateBoList = operateGenerateBoList.stream().distinct().sorted(Comparator.comparingInt(OperateGenerateBo::getSeq)).collect(Collectors.toList());
        List<DynamicObject> taskDetailDyList = operateGenerateBoList.stream().map(it -> this.createTask((OperateGenerateBo)it)).collect(Collectors.toList());
        this.taskDetailEntityService.save(taskDetailDyList.toArray(new DynamicObject[0]));
    }

    public DynamicObject createTask(OperateGenerateBo operateGenerateBo) {
        DynamicObject taskDetailDynamicObject = this.taskDetailEntityService.generateEmptyDynamicObject();
        taskDetailDynamicObject.set("task", (Object)this.taskId);
        taskDetailDynamicObject.set("operate", (Object)operateGenerateBo.getOperateDynamicObject());
        taskDetailDynamicObject.set("enable", (Object)"1");
        taskDetailDynamicObject.set("status", (Object)"C");
        DynamicObjectUtils.addAuditInfo((DynamicObject)taskDetailDynamicObject);
        return taskDetailDynamicObject;
    }

    private List<OperateGenerateBo> getNeedRunOpList() {
        ArrayList operateGenerateBoList = Lists.newArrayList();
        for (DynamicObject opDy : TaskGenContext.get().getOpDynamicObjectList()) {
            operateGenerateBoList.addAll(new OperateGenerateBo(opDy, this.runParamStr).match());
        }
        return operateGenerateBoList;
    }
}

