/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.context;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.extcase.entity.IExtCaseEntityService;
import kd.hdtc.hrbm.business.domain.task.entity.IOperateEntityService;

public class TaskGenContext {
    private static final IExtCaseEntityService EXT_CASE_ENTITY_SERVICE = ServiceFactory.getService(IExtCaseEntityService.class);
    private static final IOperateEntityService OPERATE_ENTITY_SERVICE = ServiceFactory.getService(IOperateEntityService.class);
    private long taskId;
    private String runParamStr;
    private long sceneManagerId;
    private Map<String, DynamicObject> operateMap = null;
    private Map<String, DynamicObject> allOperateMap = null;
    private static final ThreadLocal<TaskGenContext> TASK_GEN_CONTEXT_THREAD_LOCAL = new ThreadLocal();

    private TaskGenContext(long taskId) {
        this.taskId = taskId;
    }

    public static TaskGenContext get() {
        return TASK_GEN_CONTEXT_THREAD_LOCAL.get();
    }

    public static TaskGenContext create(long taskId, String runParamStr, long sceneManagerId) {
        TaskGenContext taskGenContext = new TaskGenContext(taskId);
        taskGenContext.runParamStr = runParamStr;
        taskGenContext.sceneManagerId = sceneManagerId;
        taskGenContext.operateMap = EXT_CASE_ENTITY_SERVICE.getOpDynamicObjectMap(sceneManagerId);
        taskGenContext.allOperateMap = OPERATE_ENTITY_SERVICE.getAllOpDynamicObjectMap();
        TASK_GEN_CONTEXT_THREAD_LOCAL.set(taskGenContext);
        return TaskGenContext.get();
    }

    public static void remove() {
        TASK_GEN_CONTEXT_THREAD_LOCAL.remove();
    }

    public DynamicObject getOperateDyByNumber(String refOpNumber) {
        DynamicObject operateDy = this.operateMap.get(refOpNumber);
        if (operateDy != null) {
            return operateDy;
        }
        return this.allOperateMap.get(refOpNumber);
    }

    public List<DynamicObject> getOpDynamicObjectList() {
        return this.operateMap.entrySet().stream().map(it -> (DynamicObject)it.getValue()).sorted(Comparator.comparingInt(o -> o.getInt("runseq"))).collect(Collectors.toList());
    }

    public long getTaskId() {
        return this.taskId;
    }

    public String getRunParamStr() {
        return this.runParamStr;
    }

    public long getSceneManagerId() {
        return this.sceneManagerId;
    }
}

