/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.context;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.extcase.entity.IExtCaseEntityService;
import kd.hdtc.hrbm.business.domain.task.entity.IOperateEntityService;
import kd.hdtc.hrbm.business.domain.task.entity.ITaskRecordEntityService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class TaskRunContext {
    private static final ITaskRecordEntityService TASK_RECORD_ENTITY_SERVICE = ServiceFactory.getService(ITaskRecordEntityService.class);
    private static final IExtCaseEntityService EXT_CASE_ENTITY_SERVICE = ServiceFactory.getService(IExtCaseEntityService.class);
    private static final IOperateEntityService OPERATE_ENTITY_SERVICE = ServiceFactory.getService(IOperateEntityService.class);
    private long taskId;
    private String runParamStr;
    private Map<String, Object> runParamMap;
    private String context;
    private Map<String, Object> runContextMap;
    private DynamicObject taskRecordDynamicObject;
    private Map<String, DynamicObject> operateMap;
    private Map<String, DynamicObject> allOperateMap;
    private long extCaseManageId;
    private static final ThreadLocal<TaskRunContext> TASK_RUN_CONTEXT_THREAD_LOCAL = new ThreadLocal();

    private TaskRunContext() {
    }

    public static TaskRunContext get() {
        return TASK_RUN_CONTEXT_THREAD_LOCAL.get();
    }

    public TaskRunContext(long taskId) {
        this.taskId = taskId;
    }

    public static TaskRunContext create(long taskId) {
        TaskRunContext taskRunContext = new TaskRunContext(taskId);
        TASK_RUN_CONTEXT_THREAD_LOCAL.set(taskRunContext);
        return TaskRunContext.get();
    }

    public static void remove() {
        TASK_RUN_CONTEXT_THREAD_LOCAL.remove();
    }

    public void init() {
        this.taskRecordDynamicObject = TASK_RECORD_ENTITY_SERVICE.queryTaskRecord(this.taskId);
        this.runParamStr = this.taskRecordDynamicObject.getString("execparam");
        this.context = this.taskRecordDynamicObject.getString("execctx");
        this.runContextMap = StringUtils.isEmpty((String)this.context) ? Maps.newLinkedHashMap() : (Map)JsonUtils.castType((String)this.context, Map.class);
        this.operateMap = EXT_CASE_ENTITY_SERVICE.getOpDynamicObjectMap(this.taskRecordDynamicObject.getDynamicObject("extcasemanage").getLong("id"));
        this.allOperateMap = OPERATE_ENTITY_SERVICE.getAllOpDynamicObjectMap();
        this.runParamMap = StringUtils.isEmpty((String)this.runParamStr) ? Maps.newLinkedHashMap() : (Map)JsonUtils.castType((String)this.runParamStr, Map.class);
        this.extCaseManageId = Optional.ofNullable(this.taskRecordDynamicObject).map(it -> it.getDynamicObject("extcasemanage")).map(it -> it.getLong("id")).orElseGet(() -> 0L);
    }

    public DynamicObject getOperateDyByNumber(String refOpNumber) {
        DynamicObject operateDy = this.operateMap.get(refOpNumber);
        if (operateDy != null) {
            return operateDy;
        }
        return this.allOperateMap.get(refOpNumber);
    }

    public <T> T getContextValue(String ctxKey) {
        return (T)this.runContextMap.get(ctxKey);
    }

    public void addContextValue(Map<String, Object> paramMap) {
        if (CollectionUtils.isEmpty(paramMap)) {
            return;
        }
        this.runContextMap.putAll(paramMap);
        this.taskRecordDynamicObject.set("execctx", (Object)JsonUtils.toStr(this.runContextMap));
        TASK_RECORD_ENTITY_SERVICE.saveContextInTrans(this.taskRecordDynamicObject);
    }

    public long getTaskId() {
        return this.taskId;
    }

    public String getRunParamStr() {
        return this.runParamStr;
    }

    public Object getRunParamByKey(String key) {
        return this.runParamMap == null ? null : this.runParamMap.get(key);
    }

    public Map<String, Object> getRunParamMap() {
        return ImmutableMap.copyOf(this.runParamMap);
    }

    public Map<String, Object> getRunContextMap() {
        return ImmutableMap.copyOf(this.runContextMap);
    }

    public long getExtCaseManageId() {
        return this.extCaseManageId;
    }
}

