/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.entity.impl;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.extcase.entity.IExtCaseManageEntityService;
import kd.hdtc.hrbm.business.domain.task.entity.IOperateEntityService;
import kd.hdtc.hrdbs.business.entity.AbstractBaseEntityService;
import kd.hr.hbp.common.util.HRObjectUtils;

public class OperateEntityServiceImpl
extends AbstractBaseEntityService
implements IOperateEntityService {
    private static final Log LOG = LogFactory.getLog(OperateEntityServiceImpl.class);
    private final IExtCaseManageEntityService extCaseManageEntityService = ServiceFactory.getService(IExtCaseManageEntityService.class);
    private static final String ALL_FIELD = "number,operatetype,serviceclass,param,runseq,mappingrule,scenetype,allowrollback,existrule";

    public OperateEntityServiceImpl() {
        super("hrbm_operate");
    }

    @Override
    public Map<String, DynamicObject> getOpDynamicObjectMap(long sceneManagerId) {
        DynamicObject extCaseManage = this.extCaseManageEntityService.queryExtCaseManageById(sceneManagerId);
        QFilter extCaseQFilter = null;
        if (!HRObjectUtils.isEmpty((Object)extCaseManage)) {
            extCaseQFilter = new QFilter("extcase", "=", (Object)extCaseManage.getDynamicObject("extcase").getLong("id"));
        }
        DynamicObject[] taskOperates = this.query(ALL_FIELD, new QFilter[]{extCaseQFilter});
        return Arrays.stream(taskOperates).collect(Collectors.toMap(dy -> dy.getString("number"), Function.identity(), (o1, o2) -> o1));
    }

    @Override
    public Map<String, DynamicObject> getAllOpDynamicObjectMap() {
        Map operateMap = this.getMapFromCache(ALL_FIELD, null);
        return operateMap.entrySet().stream().map(entry -> (DynamicObject)entry.getValue()).collect(Collectors.toMap(dy -> dy.getString("number"), Function.identity(), (o1, o2) -> o1));
    }
}

