/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.entity.impl;

import com.google.common.collect.ImmutableMap;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.domain.task.entity.ITaskRecordEntityService;
import kd.hdtc.hrdbs.business.entity.AbstractBaseEntityService;
import kd.hdtc.hrdbs.common.util.DateTimeUtils;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;

public class TaskRecordEntityServiceImpl
extends AbstractBaseEntityService
implements ITaskRecordEntityService {
    private static final Log LOG = LogFactory.getLog(TaskRecordEntityServiceImpl.class);
    private static final String RUN_TASK_PROPERTIES = "execstatus,exectype,extcasemanage,execparam,execctx,exectime";

    public TaskRecordEntityServiceImpl() {
        super("hrbm_taskrecord");
    }

    @Override
    public void createNewTaskRecord(long taskId, long sceneManagerId, String runParamStr, String callbackServiceName) {
        DynamicObject taskRecordDynamicObject = this.generateEmptyDynamicObject();
        taskRecordDynamicObject.set("number", (Object)ID.genStringId());
        taskRecordDynamicObject.set("name", taskRecordDynamicObject.get("number"));
        taskRecordDynamicObject.set("execparam", (Object)runParamStr);
        taskRecordDynamicObject.set("exectime", (Object)0);
        taskRecordDynamicObject.set("execstatus", (Object)"0");
        taskRecordDynamicObject.set("exectype", (Object)"0");
        taskRecordDynamicObject.set("enable", (Object)"1");
        taskRecordDynamicObject.set("status", (Object)"C");
        taskRecordDynamicObject.set("starttime", (Object)new Date());
        taskRecordDynamicObject.set("id", (Object)taskId);
        taskRecordDynamicObject.set("execctx", (Object)JsonUtils.toStr((Object)ImmutableMap.of((Object)"callbackService", (Object)callbackServiceName)));
        taskRecordDynamicObject.set("extcasemanage", (Object)sceneManagerId);
        DynamicObjectUtils.addAuditInfo((DynamicObject)taskRecordDynamicObject);
        this.save(taskRecordDynamicObject);
    }

    @Override
    public DynamicObject queryTaskRecord(long taskId) {
        QFilter qFilter = new QFilter("id", "=", (Object)taskId);
        return this.queryOne(RUN_TASK_PROPERTIES, qFilter.toArray());
    }

    @Override
    public void saveContextInTrans(DynamicObject taskRecordDynamicObject) {
        try (TXHandle txHandle = TX.requiresNew();){
            this.save(taskRecordDynamicObject);
        }
    }

    @Override
    public void successTaskRecord(long taskId) {
        DynamicObject taskRecordDynamicObject = this.queryOne("execstatus,starttime,endtime,exectime", new QFilter("id", "=", (Object)taskId).toArray());
        taskRecordDynamicObject.set("execstatus", (Object)"1");
        taskRecordDynamicObject.set("endtime", (Object)new Date());
        long execTime = DateTimeUtils.dateDiff((String)"s", (Date)taskRecordDynamicObject.getDate("starttime"), (Date)taskRecordDynamicObject.getDate("endtime"));
        taskRecordDynamicObject.set("exectime", (Object)execTime);
        try (TXHandle txHandle = TX.requiresNew();){
            this.save(taskRecordDynamicObject);
        }
    }
}

