/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl;

import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.metadata.form.FormMetadata;
import kd.hdtc.hrbm.business.domain.task.AbstractOperateService;
import kd.hdtc.hrbm.business.domain.task.bo.RunParamBo;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IBizUnitEntityService;
import kd.hdtc.hrdbs.common.enums.MetadataGenTypeEnum;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;

public abstract class AbstractOtherExtOperateService
extends AbstractOperateService {
    private final IDynamicMetadataApplicationService dynamicMetadataApplicationService = (IDynamicMetadataApplicationService)ServiceFactory.getService(IDynamicMetadataApplicationService.class);
    private final IBizUnitEntityService bizUnitEntityService = (IBizUnitEntityService)ServiceFactory.getService(IBizUnitEntityService.class);

    protected abstract String entityNumber();

    protected abstract String containerNumber();

    protected void fillFieldParam(FieldParam fieldParam) {
    }

    @Override
    protected void doOperate() {
        MetadataGenResult result = this.dynamicMetadataApplicationService.generate(this.buildMetadataGenParam(this.getRunParamStr()));
        if (!result.isSuccess()) {
            throw new HRDBSBizException(result.getThrowable(), new ErrorCode("hrdbs.metadataGenError", "hrdbs.metadataGenError"), new Object[0]);
        }
        this.getOperateResultBo().getDataResultBo().addMetadataResultBo(result.getEntityNumber(), result.getEntityId(), result.getVersionNumber());
    }

    private MetadataGenParam buildMetadataGenParam(String param) {
        RunParamBo bo = (RunParamBo)SerializationUtils.fromJsonString((String)param, RunParamBo.class);
        MetadataGenParam metadataGenParam = bo.getData();
        String entityNumber = this.entityNumber();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        BaseParam baseParam = metadataGenParam.getBaseParam();
        baseParam.setMetadataNumber(entityNumber);
        baseParam.setMetadataName(mainType.getDisplayName().getLocaleValue());
        FormMetadata formMetadata = MetadataUtils.getFormMetadataByNumber((String)entityNumber);
        baseParam.setParentId(formMetadata.getEntityId());
        baseParam.setModelType(formMetadata.getModelType());
        baseParam.setType(MetadataGenTypeEnum.EXTEND_METADATA);
        baseParam.setBizUnitId((String)this.bizUnitEntityService.getMetadataBizUnit(formMetadata.getEntityId(), formMetadata.getBizappId()).orElse(null));
        baseParam.setAppId(mainType.getAppId());
        String containerNumber = this.containerNumber();
        metadataGenParam.getFieldParamList().forEach(field -> {
            field.setContainerNumber(containerNumber);
            this.fillFieldParam((FieldParam)field);
        });
        return metadataGenParam;
    }
}

